/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.equinox.p2.ui.AcceptLicensesWizardPage;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class InstallWizardTest
extends WizardTest {
    private static final String SELECTION_PAGE = "IUSelectionPage";
    private static final String AVAILABLE_SOFTWARE_PAGE = "AvailableSoftwarePage";
    private static final String MAIN_IU = "MainIU";
    IInstallableUnit toInstall;

    protected void setUp() throws Exception {
        super.setUp();
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(MAIN_IU);
        iu.setProperty("org.eclipse.equinox.p2.type.group", "true");
        iu.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iu.setSingleton(true);
        iu.setLicenses(new ILicense[]{new License(null, "There is a license to accept!", null)});
        iu.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)MAIN_IU, (Version)iu.getVersion())});
        this.toInstall = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.toInstall});
    }

    public void testInstallWizardResolved() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.toInstall);
        InstallOperation op = new InstallOperation(this.getSession(), iusInvolved);
        op.setProfileId("TestProfile");
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), op, iusInvolved, null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        ProfileModificationJob longOp = null;
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            InstallWizardTest.assertTrue((String)"1.0", (boolean)page1.isPageComplete());
            IWizardPage page = page1.getNextPage();
            dialog.showPage(page);
            InstallWizardTest.assertTrue((String)"1.1", (boolean)page.isPageComplete());
            longOp = this.getLongTestOperation();
            this.getProvisioningUI().schedule((ProvisioningJob)longOp, 1);
            wizard.recomputePlan((IRunnableContext)dialog);
            InstallWizardTest.assertFalse((String)"1.2", (boolean)page.isPageComplete());
            longOp.cancel();
            wizard.recomputePlan((IRunnableContext)dialog);
            InstallWizardTest.assertFalse((String)"1.4", (boolean)wizard.canFinish());
            dialog.updateButtons();
            Button finishButton = dialog.testGetButton(16);
            InstallWizardTest.assertFalse((String)"1.5", (boolean)finishButton.isEnabled());
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testInstallWizard() throws Exception {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.toInstall);
        MyNewInstallOperation op = new MyNewInstallOperation(this.getSession(), iusInvolved);
        op.setProfileId("TestProfile");
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), (InstallOperation)op, iusInvolved, null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Object longOp = null;
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            InstallWizardTest.assertTrue((String)"1.0", (boolean)page1.isPageComplete());
            InstallWizardPage page = (InstallWizardPage)page1.getNextPage();
            Field opField = ResolutionResultsWizardPage.class.getDeclaredField("resolvedOperation");
            opField.setAccessible(true);
            InstallWizardTest.assertTrue((String)"Expected instance of MyNewInstallOperation", (boolean)(opField.get(page) instanceof MyNewInstallOperation));
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testInstallWizardWithoutLicenceBypass() throws Exception {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.toInstall);
        MyNewInstallOperation op = new MyNewInstallOperation(this.getSession(), iusInvolved);
        op.setProfileId("TestProfile");
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), (InstallOperation)op, iusInvolved, null);
        wizard.setBypassLicencePage(false);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Object longOp = null;
        try {
            SelectableIUsPage selectableIUsPage = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            InstallWizardTest.assertTrue((String)"1.0", (boolean)selectableIUsPage.isPageComplete());
            InstallWizardPage installWizardPage = (InstallWizardPage)selectableIUsPage.getNextPage();
            InstallWizardTest.assertFalse((String)"Licence page bypass flag must be false", (boolean)wizard.isBypassLicencePage());
            IWizardPage licensePage = installWizardPage.getNextPage();
            InstallWizardTest.assertTrue((String)"Expected instance of AcceptLicensesWizardPage", (boolean)(licensePage instanceof AcceptLicensesWizardPage));
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testInstallWizardWithLicenceBypass() throws Exception {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.toInstall);
        MyNewInstallOperation op = new MyNewInstallOperation(this.getSession(), iusInvolved);
        op.setProfileId("TestProfile");
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), (InstallOperation)op, iusInvolved, null);
        wizard.setBypassLicencePage(true);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Object longOp = null;
        try {
            SelectableIUsPage selectableIUsPage = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            InstallWizardTest.assertTrue((String)"1.0", (boolean)selectableIUsPage.isPageComplete());
            InstallWizardPage installWizardPage = (InstallWizardPage)selectableIUsPage.getNextPage();
            InstallWizardTest.assertTrue((String)"Licence page bypass flag must be true", (boolean)wizard.isBypassLicencePage());
            IWizardPage licensePage = installWizardPage.getNextPage();
            InstallWizardTest.assertNull((String)"Expected instance of AcceptLicensesWizardPage must be null", (Object)licensePage);
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testInstallWizardUnresolved() {
        LoadMetadataRepositoryJob job = new LoadMetadataRepositoryJob(this.getProvisioningUI());
        this.getPolicy().setGroupByCategory(false);
        job.runModal(this.getMonitor());
        InstallWizard wizard = new InstallWizard(this.getProvisioningUI(), null, null, job);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(false);
        dialog.open();
        ProfileModificationJob longOp = null;
        try {
            AvailableIUsPage page1 = (AvailableIUsPage)wizard.getPage(AVAILABLE_SOFTWARE_PAGE);
            InstallWizardTest.assertTrue((String)"1.0", (page1.getSelectedIUs().size() == 0 ? 1 : 0) != 0);
            InstallWizardTest.assertFalse((String)"1.1", (boolean)page1.isPageComplete());
            AvailableIUGroup group = page1.testGetAvailableIUGroup();
            group.setRepositoryFilter(1, null);
            DeferredQueryContentProvider provider = (DeferredQueryContentProvider)group.getCheckboxTreeViewer().getContentProvider();
            provider.setSynchronous(true);
            group.getCheckboxTreeViewer().refresh();
            group.getCheckboxTreeViewer().expandAll();
            Tree tree = (Tree)group.getCheckboxTreeViewer().getControl();
            TreeItem[] items = tree.getItems();
            int i = 0;
            while (i < items.length) {
                IInstallableUnit iu;
                Object element = items[i].getData();
                if (element != null && element instanceof IIUElement && (iu = ((IIUElement)element).getIU()) != null && iu.getId().equals(MAIN_IU)) {
                    group.getCheckboxTreeViewer().setChecked(element, true);
                }
                ++i;
            }
            group.setChecked(group.getCheckboxTreeViewer().getCheckedElements());
            InstallWizardTest.assertTrue((String)"2.0", (group.getCheckedLeafIUs().length > 0 ? 1 : 0) != 0);
            InstallWizardTest.assertTrue((String)"2.1", (boolean)page1.isPageComplete());
            IWizardPage page = wizard.getNextPage((IWizardPage)page1);
            dialog.showPage(page);
            InstallWizardTest.assertTrue((String)"3.0", (boolean)page.isPageComplete());
            longOp = this.getLongTestOperation();
            this.getProvisioningUI().schedule((ProvisioningJob)longOp, 1);
            wizard.recomputePlan((IRunnableContext)dialog);
            InstallWizardTest.assertFalse((String)"3.1", (boolean)page.isPageComplete());
            longOp.cancel();
            group.getCheckedLeafIUs();
            group.getDefaultFocusControl();
            group.getSelectedIUElements();
            group.getSelectedIUs();
        }
        finally {
            dialog.close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyNewInstallOperation
    extends InstallOperation {
        public MyNewInstallOperation(ProvisioningSession session, Collection<IInstallableUnit> toInstall) {
            super(session, toInstall);
        }
    }
}

