/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.OperationFactory;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class OperationFactoryTest
extends AbstractProvisioningTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCreateInstallOperation() {
        OperationFactory of = new OperationFactory();
        ArrayList<VersionedId> versions = new ArrayList<VersionedId>();
        versions.add(new VersionedId("aBundle", "1.0.0"));
        ArrayList<URI> coll = new ArrayList<URI>();
        coll.add(OperationFactoryTest.getTestData((String)"Simple repository", (String)"testData/testRepos/simple.1").toURI());
        try {
            of.createInstallOperation(versions, coll, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            OperationFactoryTest.fail((String)"Creation of the install operation failed", (Throwable)e);
        }
    }

    public void testCreateInstallOperationWithUnspecifiedVersion() {
        OperationFactory of = new OperationFactory();
        ArrayList<VersionedId> versions = new ArrayList<VersionedId>();
        versions.add(new VersionedId("aBundle", null));
        ArrayList<URI> coll = new ArrayList<URI>();
        coll.add(OperationFactoryTest.getTestData((String)"Simple repository", (String)"testData/testRepos/simple.1").toURI());
        try {
            of.createInstallOperation(versions, coll, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            OperationFactoryTest.fail((String)"Creation of the install operation failed", (Throwable)e);
        }
    }

    public void testMissingVersionedIdInInstallOperation() {
        OperationFactory of = new OperationFactory();
        ArrayList<VersionedId> versions = new ArrayList<VersionedId>();
        versions.add(new VersionedId("aBundle", "1.0.0"));
        ProvisionException exceptionMet = null;
        try {
            of.createInstallOperation(versions, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            exceptionMet = e;
        }
        OperationFactoryTest.assertNotNull((String)"An exception was expected", (Object)((Object)exceptionMet));
    }

    public void testMissingElementToUninstall() {
        this.createProfileWithOneIU(OperationFactoryTest.getUniqueString());
        OperationFactory of = new OperationFactory();
        IQueryResult installedElements = of.listInstalledElements(true, (IProgressMonitor)new NullProgressMonitor());
        OperationFactoryTest.assertEquals((int)1, (int)installedElements.toSet().size());
        this.testUninstall((IVersionedId)new VersionedId("aBundle", null), false);
        this.testUninstall((IVersionedId)new VersionedId("aBundle", Version.create((String)"1.0.0")), false);
        this.testUninstall((IVersionedId)new VersionedId("aBundle", Version.create((String)"2.0.0")), true);
        this.testUninstall((IVersionedId)new VersionedId("missingBundle", null), true);
        this.testUninstall((IVersionedId)installedElements.toSet().iterator().next(), false);
        this.testUninstall((IVersionedId)OperationFactoryTest.createEclipseIU((String)"doesNotExist"), true);
    }

    private void createProfileWithOneIU(String profileName) {
        try {
            IProfileRegistry profileRegistry = this.getProfileRegistry();
            profileRegistry.addProfile(profileName);
            Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
            selfField.setAccessible(true);
            this.previousSelfValue = selfField.get(profileRegistry);
            selfField.set(profileRegistry, profileName);
        }
        catch (Exception e) {
            OperationFactoryTest.fail((String)"Error while setting up uninstall test", (Throwable)e);
        }
        OperationFactory of = new OperationFactory();
        ArrayList<VersionedId> versions = new ArrayList<VersionedId>();
        versions.add(new VersionedId("aBundle", null));
        ArrayList<URI> coll = new ArrayList<URI>();
        coll.add(OperationFactoryTest.getTestData((String)"Simple repository", (String)"testData/testRepos/simple.1").toURI());
        try {
            InstallOperation iop = of.createInstallOperation(versions, coll, (IProgressMonitor)new NullProgressMonitor());
            IStatus result = iop.resolveModal((IProgressMonitor)new NullProgressMonitor());
            if (result.isOK()) {
                iop.getProvisioningJob((IProgressMonitor)new NullProgressMonitor()).runModal((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (ProvisionException e) {
            OperationFactoryTest.fail((String)"Creation of the install operation failed", (Throwable)e);
        }
    }

    private void testUninstall(IVersionedId vid, boolean shouldFail) {
        OperationFactory of = new OperationFactory();
        ArrayList<IVersionedId> toRemove = new ArrayList<IVersionedId>();
        toRemove.add(vid);
        ProvisionException expectedException = null;
        try {
            of.createUninstallOperation(toRemove, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            expectedException = e;
        }
        if (shouldFail) {
            OperationFactoryTest.assertNotNull((Object)((Object)expectedException));
        } else {
            OperationFactoryTest.assertNull((Object)((Object)expectedException));
        }
    }

    public void testUpdateOperation() {
        this.createProfileWithOneIU(OperationFactoryTest.getUniqueString());
        OperationFactory of = new OperationFactory();
        ArrayList<VersionedId> toUpdate = new ArrayList<VersionedId>();
        toUpdate.add(new VersionedId("doesNotExist", null));
        ArrayList<URI> repos = new ArrayList<URI>();
        repos.add(OperationFactoryTest.getTestData((String)"second repository", (String)"testData/testRepos/simple.2").toURI());
        ProvisionException expectedException = null;
        try {
            of.createUpdateOperation(toUpdate, repos, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            expectedException = e;
        }
        OperationFactoryTest.assertNotNull((Object)((Object)expectedException));
        toUpdate = new ArrayList();
        toUpdate.add(new VersionedId("aBundle", Version.parseVersion((String)"1.0.0")));
        repos = new ArrayList();
        repos.add(OperationFactoryTest.getTestData((String)"second repository", (String)"testData/testRepos/simple.2").toURI());
        try {
            UpdateOperation op = of.createUpdateOperation(toUpdate, repos, (IProgressMonitor)new NullProgressMonitor());
            op.resolveModal((IProgressMonitor)new NullProgressMonitor());
            OperationFactoryTest.assertEquals((int)1, (int)op.getPossibleUpdates().length);
        }
        catch (ProvisionException e) {
            OperationFactoryTest.fail((String)"Exception not expected", (Throwable)e);
        }
        ArrayList<URI> repos2 = new ArrayList<URI>();
        repos2.add(OperationFactoryTest.getTestData((String)"second repository", (String)"testData/testRepos/simple.2").toURI());
        try {
            UpdateOperation op = of.createUpdateOperation(null, repos2, (IProgressMonitor)new NullProgressMonitor());
            op.resolveModal((IProgressMonitor)new NullProgressMonitor());
            OperationFactoryTest.assertEquals((int)1, (int)op.getPossibleUpdates().length);
        }
        catch (ProvisionException e) {
            OperationFactoryTest.fail((String)"Exception not expected", (Throwable)e);
        }
    }
}

