/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.net.URI;
import java.util.HashSet;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;

public class UninstallOperationTests
extends AbstractProvisioningUITest {
    public void testUninstallContactsNoRepositories() {
        HashSet<IInstallableUnit> ius = new HashSet<IInstallableUnit>();
        ius.add(this.top1);
        UninstallOperation op = new UninstallOperation(this.getSession(), ius);
        ProvisioningContext pc = new ProvisioningContext(UninstallOperationTests.getAgent());
        pc.setArtifactRepositories(new URI[]{this.testRepoLocation});
        pc.setMetadataRepositories(new URI[]{this.testRepoLocation});
        op.setProvisioningContext(pc);
        op.setProfileId("TestProfile");
        UninstallOperationTests.assertTrue((String)"Should resolve", (boolean)op.resolveModal(this.getMonitor()).isOK());
        pc = op.getProvisioningPlan().getContext();
        IQueryable queryable = pc.getMetadata(this.getMonitor());
        UninstallOperationTests.assertTrue((String)"metadata queryable should be empty", (boolean)queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).isEmpty());
        IQueryable artifactQueryable = pc.getArtifactRepositories(this.getMonitor());
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        UninstallOperationTests.assertTrue((String)"artifact queryable should be empty", (boolean)artifactQueryable.query((IQuery)all, this.getMonitor()).isEmpty());
    }
}

