/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.query.AvailableIUWrapper;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.MockQueryable;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;
import org.junit.Assert;

public class AvailableIUWrapperTest
extends AbstractQueryTest {
    protected AvailableIUWrapper createWrapper() {
        return this.createWrapper(true);
    }

    protected AvailableIUWrapper createWrapper(boolean makeCategories) {
        return new AvailableIUWrapper((IQueryable)new MockQueryable(), null, makeCategories, true);
    }

    protected IInstallableUnit getIU(Object collected) {
        return ((IIUElement)collected).getIU();
    }

    public void testCollectObject() {
        AvailableIUWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        Object object = new Object();
        collector.accept(object);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.0", (int)1, (int)results.size());
        AvailableIUWrapperTest.assertEquals((String)"1.1", (Object)object, results.iterator().next());
    }

    public void testCollectIU() {
        AvailableIUWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        IInstallableUnit unit = AvailableIUWrapperTest.createIU((String)"f1");
        collector.accept((Object)unit);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.0", (int)1, (int)results.size());
        IInstallableUnit collectedIU = this.getIU(results.iterator().next());
        AvailableIUWrapperTest.assertEquals((String)"1.1", (IInstallableUnit)unit, (IInstallableUnit)collectedIU);
    }

    public void testMakeCategory() {
        AvailableIUWrapper wrapper = this.createWrapper(true);
        Collector collector = new Collector();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.type.category", "true");
        IInstallableUnit category = AvailableIUWrapperTest.createIU((String)"category", (Version)Version.createOSGi((int)1, (int)0, (int)0), (IRequirement[])NO_REQUIRES, properties, (boolean)false);
        IInstallableUnit unit = AvailableIUWrapperTest.createIU((String)"basicIU");
        collector.accept((Object)category);
        collector.accept((Object)unit);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.0", (int)2, (int)collector.size());
        boolean categoryFound = false;
        for (Object element : results) {
            IInstallableUnit collected = this.getIU(element);
            if (collected.equals((Object)category)) {
                categoryFound = true;
                AvailableIUWrapperTest.assertTrue((String)"1.1", (boolean)(element instanceof CategoryElement));
                continue;
            }
            AvailableIUWrapperTest.assertEquals((String)"1.2", (IInstallableUnit)unit, (IInstallableUnit)collected);
        }
        AvailableIUWrapperTest.assertTrue((String)"1.3", (boolean)categoryFound);
    }

    public void testNoMakeCategory() {
        AvailableIUWrapper wrapper = this.createWrapper(false);
        Collector collector = new Collector();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.type.category", "true");
        IInstallableUnit category = AvailableIUWrapperTest.createIU((String)"category", (Version)Version.createOSGi((int)1, (int)0, (int)0), (IRequirement[])NO_REQUIRES, properties, (boolean)false);
        IInstallableUnit unit = AvailableIUWrapperTest.createIU((String)"basicIU");
        collector.accept((Object)category);
        collector.accept((Object)unit);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.0", (int)2, (int)results.size());
        boolean categoryFound = false;
        for (Object element : results) {
            IInstallableUnit collected = this.getIU(element);
            if (collected.equals((Object)category)) {
                categoryFound = true;
                AvailableIUWrapperTest.assertFalse((String)"1.1", (boolean)(element instanceof CategoryElement));
                continue;
            }
            AvailableIUWrapperTest.assertEquals((String)"1.2", (IInstallableUnit)unit, (IInstallableUnit)collected);
        }
        AvailableIUWrapperTest.assertTrue((String)"1.3", (boolean)categoryFound);
    }

    public void testHideInstalled() {
        IProfile profile = this.createProfile("TestProfile");
        AvailableIUWrapper wrapper = this.createWrapper(true);
        Collector collector = new Collector();
        IInstallableUnit installed = AvailableIUWrapperTest.createIU((String)"installed");
        IInstallableUnit notInstalled = AvailableIUWrapperTest.createIU((String)"notInstalled");
        this.install(profile, new IInstallableUnit[]{installed}, true, AvailableIUWrapperTest.createPlanner(), AvailableIUWrapperTest.createEngine());
        wrapper.markInstalledIUs(profile, true);
        collector.accept((Object)installed);
        collector.accept((Object)notInstalled);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.1", (int)1, (int)results.size());
        Object iuElement = results.iterator().next();
        AvailableIUWrapperTest.assertEquals((String)"1.2", (IInstallableUnit)notInstalled, (IInstallableUnit)this.getIU(iuElement));
    }

    public void testUpdate() {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId("NewB");
        iud.setVersion(Version.create((String)"1.0.0"));
        String orExpression = "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && pc.name == 'B')";
        IExpression expr = ExpressionUtil.parse((String)orExpression);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        ArrayList<IMatchExpression> updateExpression = new ArrayList<IMatchExpression>();
        updateExpression.add(matchExpression);
        iud.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(updateExpression, (int)1, null, null));
        IInstallableUnit newIUB = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        IInstallableUnit installed = AvailableIUWrapperTest.createIU((String)"B");
        IProfile profile = this.createProfile("TestProfile");
        AvailableIUWrapper wrapper = this.createWrapper(true);
        Collector collector = new Collector();
        this.installAsRoots(profile, new IInstallableUnit[]{installed}, true, AvailableIUWrapperTest.createPlanner(), AvailableIUWrapperTest.createEngine());
        wrapper.markInstalledIUs(profile, true);
        collector.accept((Object)newIUB);
        Collection results = wrapper.getElements(collector);
        AvailableIUWrapperTest.assertEquals((String)"1.1", (int)1, (int)results.size());
        Object iuElement = results.iterator().next();
        AvailableIUWrapperTest.assertEquals((String)"1.2", (IInstallableUnit)newIUB, (IInstallableUnit)this.getIU(iuElement));
        Assert.assertTrue((boolean)((AvailableIUElement)iuElement).isUpdate());
    }

    protected IQuery getMockQuery() {
        return QueryUtil.createIUPropertyQuery((String)"key", (String)"value");
    }
}

