/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.ElementWrapper;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;

public class QueryDescriptorTest
extends TestCase {
    public void testSimpleDescriptorWithWrapper() {
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), (IQuery)new SimpleMatchQuery(), new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        QueryDescriptorTest.assertEquals((String)"1.0", (int)2, (int)collection.size());
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("a")));
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
    }

    public void testSimpleDescriptorWithoutWrapper() {
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), (IQuery)new SimpleMatchQuery(), new Collector());
        Collection collection = eqDescriptor.performQuery(null);
        QueryDescriptorTest.assertEquals((String)"1.0", (int)2, (int)collection.size());
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains("a"));
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains("b"));
    }

    public void testCompoundDescriptorAND() {
        IQuery query = QueryUtil.createCompoundQuery((IQuery)new SimpleMatchQuery(), (IQuery)new SimpleMatchQuery2(), (boolean)true);
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), query, new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        QueryDescriptorTest.assertEquals((String)"1.0", (int)1, (int)collection.size());
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
    }

    public void testCompoundDescriptorOR() {
        IQuery query = QueryUtil.createCompoundQuery((IQuery)new SimpleMatchQuery(), (IQuery)new SimpleMatchQuery2(), (boolean)false);
        ElementQueryDescriptor eqDescriptor = new ElementQueryDescriptor((IQueryable)new SimpleQueryable(), query, new Collector(), (ElementWrapper)new StringWrapper());
        Collection collection = eqDescriptor.performQuery(null);
        QueryDescriptorTest.assertEquals((String)"1.0", (int)3, (int)collection.size());
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("a")));
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("b")));
        QueryDescriptorTest.assertTrue((String)"1.1", (boolean)collection.contains(new WrappedString("c")));
    }

    class SimpleMatchQuery
    extends MatchQuery {
        SimpleMatchQuery() {
        }

        public boolean isMatch(Object candidate) {
            return candidate == "a" || candidate == "b";
        }
    }

    class SimpleMatchQuery2
    extends MatchQuery {
        SimpleMatchQuery2() {
        }

        public boolean isMatch(Object candidate) {
            return candidate == "b" || candidate == "c";
        }
    }

    class SimpleQueryable
    implements IQueryable {
        List elements = Arrays.asList("a", "b", "c", "d", "e");

        SimpleQueryable() {
        }

        public IQueryResult query(IQuery query, IProgressMonitor monitor) {
            return query.perform(this.elements.iterator());
        }
    }

    class StringWrapper
    extends ElementWrapper {
        StringWrapper() {
        }

        protected Object wrap(Object item) {
            return new WrappedString((String)item);
        }
    }

    class WrappedString {
        String string;

        WrappedString(String string) {
            this.string = string;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WrappedString)) {
                return false;
            }
            WrappedString other = (WrappedString)obj;
            return this.string.equals(other.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }
}

