/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.QueryProvider;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class QueryableMetadataRepositoryManagerTest
extends AbstractQueryTest {
    ProvisioningUI ui;
    ProvisioningSession session;

    protected void setUp() throws Exception {
        this.ui = ProvisioningUI.getDefaultUI();
        this.session = this.ui.getSession();
        super.setUp();
    }

    public void testBrokenRepository() {
        URI brokenRepo;
        try {
            brokenRepo = TestData.getFile((String)"metadataRepo", (String)"bad").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(brokenRepo);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.0", (!manager.areRepositoriesLoaded() ? 1 : 0) != 0);
        LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.ui);
        loadJob.runModal(this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.1", (!manager.areRepositoriesLoaded() ? 1 : 0) != 0);
    }

    public void testCancelLoad() {
        URI location;
        try {
            location = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(location);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.0", (!manager.areRepositoriesLoaded() ? 1 : 0) != 0);
        LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.ui);
        loadJob.runModal((IProgressMonitor)new CancelingProgressMonitor());
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.1", (!manager.areRepositoriesLoaded() ? 1 : 0) != 0);
    }

    public void testCancelQuery() {
        URI broken;
        URI nonExisting;
        URI existing;
        try {
            existing = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
            nonExisting = new File("does/not/exist/testNotFoundRepository").toURI();
            broken = TestData.getFile((String)"metadataRepo", (String)"bad").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(existing);
        metadataRepositoryManager.addRepository(nonExisting);
        metadataRepositoryManager.addRepository(broken);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        IQueryResult result = manager.query(QueryUtil.createIUQuery((String)"test.bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0)), (IProgressMonitor)new CancelingProgressMonitor());
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.0", (boolean)result.isEmpty());
    }

    public void testExistingRepository() {
        URI location;
        try {
            location = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(location);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.0", (!manager.areRepositoriesLoaded() ? 1 : 0) != 0);
        LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.ui);
        loadJob.runModal(this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.1", (boolean)manager.areRepositoriesLoaded());
    }

    public void testNotFoundRepository() {
        URI nonExisting;
        URI existing;
        try {
            existing = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
            nonExisting = new File("does/not/exist/testNotFoundRepository").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(existing);
        metadataRepositoryManager.addRepository(nonExisting);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        QueryableMetadataRepositoryManagerTest.assertFalse((String)"1.0", (boolean)manager.areRepositoriesLoaded());
        LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.ui);
        loadJob.runModal(this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertTrue((String)"1.1", (boolean)manager.areRepositoriesLoaded());
    }

    public void testQuery() {
        URI broken;
        URI nonExisting;
        URI existing;
        try {
            existing = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
            nonExisting = new File("does/not/exist/testNotFoundRepository").toURI();
            broken = TestData.getFile((String)"metadataRepo", (String)"bad").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(existing);
        metadataRepositoryManager.addRepository(nonExisting);
        metadataRepositoryManager.addRepository(broken);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        IQueryResult result = manager.query(QueryUtil.createIUQuery((String)"test.bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0)), this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)1, (int)QueryableMetadataRepositoryManagerTest.queryResultSize((IQueryResult)result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.1", (String)"test.bundle", (String)iu.getId());
        result = manager.locationsQueriable().query((IQuery)new RepositoryLocationQuery(), this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"2.0", (int)3, (int)QueryableMetadataRepositoryManagerTest.queryResultSize((IQueryResult)result));
        QueryableMetadataRepositoryManagerTest.assertContains((String)"2.1", (IQueryResult)result, (Object)existing);
        QueryableMetadataRepositoryManagerTest.assertContains((String)"2.1", (IQueryResult)result, (Object)nonExisting);
        QueryableMetadataRepositoryManagerTest.assertContains((String)"2.1", (IQueryResult)result, (Object)broken);
        result = manager.query(QueryUtil.createIUQuery(null), this.getMonitor());
        int iuCount = QueryableMetadataRepositoryManagerTest.queryResultSize((IQueryResult)result);
        result = manager.query(QueryUtil.createIUPropertyQuery(null, (String)"*"), this.getMonitor());
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"2.2", (int)iuCount, (int)QueryableMetadataRepositoryManagerTest.queryResultSize((IQueryResult)result));
    }

    public void testNonLatestInMultipleRepositories() {
        URI multipleVersion2;
        URI multipleVersion1;
        try {
            multipleVersion1 = TestData.getFile((String)"metadataRepo", (String)"multipleversions1").toURI();
            multipleVersion2 = TestData.getFile((String)"metadataRepo", (String)"multipleversions2").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(multipleVersion1);
        metadataRepositoryManager.addRepository(multipleVersion2);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        IUViewQueryContext context = new IUViewQueryContext(3);
        context.setShowLatestVersionsOnly(false);
        MetadataRepositories rootElement = new MetadataRepositories(context, this.ui, manager);
        QueryProvider queryProvider = new QueryProvider(this.ui);
        ElementQueryDescriptor queryDescriptor = queryProvider.getQueryDescriptor((QueriedElement)rootElement);
        Collection collection = queryDescriptor.performQuery(null);
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)5, (int)collection.size());
    }

    public void testLatestInMultipleRepositories() {
        URI multipleVersion2;
        URI multipleVersion1;
        try {
            multipleVersion1 = TestData.getFile((String)"metadataRepo", (String)"multipleversions1").toURI();
            multipleVersion2 = TestData.getFile((String)"metadataRepo", (String)"multipleversions2").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(multipleVersion1);
        metadataRepositoryManager.addRepository(multipleVersion2);
        QueryableMetadataRepositoryManager manager = this.getQueryableManager();
        IUViewQueryContext context = new IUViewQueryContext(3);
        context.setShowLatestVersionsOnly(true);
        MetadataRepositories rootElement = new MetadataRepositories(context, this.ui, manager);
        QueryProvider queryProvider = new QueryProvider(this.ui);
        ElementQueryDescriptor queryDescriptor = queryProvider.getQueryDescriptor((QueriedElement)rootElement);
        Collection collection = queryDescriptor.performQuery(null);
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)1, (int)collection.size());
        AvailableIUElement next = (AvailableIUElement)collection.iterator().next();
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)3, (int)0, (int)0), (Object)next.getIU().getVersion());
    }

    public void testNicknameOnLoad() {
        URI location;
        try {
            location = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
        }
        catch (Exception e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.98", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = QueryableMetadataRepositoryManagerTest.getMetadataRepositoryManager();
        metadataRepositoryManager.removeRepository(location);
        metadataRepositoryManager.addRepository(location);
        try {
            this.ui.loadMetadataRepository(location, false, this.getMonitor());
        }
        catch (ProvisionException e) {
            QueryableMetadataRepositoryManagerTest.fail((String)"0.99", (Throwable)e);
        }
        QueryableMetadataRepositoryManagerTest.assertEquals((String)"1.0", (String)"Good Test Repository", (String)metadataRepositoryManager.getRepositoryProperty(location, "p2.nickname"));
    }

    private QueryableMetadataRepositoryManager getQueryableManager() {
        return new QueryableMetadataRepositoryManager(this.ui, false);
    }
}

