/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;

public class TranslationSupportTests
extends AbstractQueryTest {
    Profile profile;
    IQueryable oldTranslationSource;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = (Profile)this.createProfile("testLocalizedLicense");
        this.oldTranslationSource = TranslationSupport.getInstance().setTranslationSource((IQueryable)this.profile);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TranslationSupport.getInstance().setTranslationSource(this.oldTranslationSource);
    }

    public void testFeatureProperties() {
        IMetadataRepository repository;
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)TranslationSupportTests.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        File site = TranslationSupportTests.getTestData((String)"0.1", (String)"/testData/metadataRepo/externalized");
        URI location = site.toURI();
        try {
            repository = repoMan.loadRepository(location, this.getMonitor());
        }
        catch (ProvisionException e) {
            TranslationSupportTests.fail((String)"1.99", (Throwable)e);
            return;
        }
        IQueryResult result = repository.query(QueryUtil.createIUQuery((String)"test.feature.feature.group"), this.getMonitor());
        TranslationSupportTests.assertTrue((String)"1.0", (!result.isEmpty() ? 1 : 0) != 0);
        IInstallableUnit unit = (IInstallableUnit)result.iterator().next();
        ICopyright copyright = unit.getCopyright(null);
        TranslationSupportTests.assertEquals((String)"1.1", (String)"Test Copyright", (String)copyright.getBody());
        ILicense license = (ILicense)unit.getLicenses(null).iterator().next();
        TranslationSupportTests.assertEquals((String)"1.2", (String)"Test License", (String)license.getBody());
        String name = unit.getProperty("org.eclipse.equinox.p2.name", null);
        TranslationSupportTests.assertEquals((String)"1.4", (String)"Test Feature Name", (String)name);
        String description = unit.getProperty("org.eclipse.equinox.p2.description", null);
        TranslationSupportTests.assertEquals((String)"1.5", (String)"Test Description", (String)description);
        String provider = unit.getProperty("org.eclipse.equinox.p2.provider", null);
        TranslationSupportTests.assertEquals((String)"1.6", (String)"Test Provider Name", (String)provider);
    }

    public void testLocalizedLicense() throws URISyntaxException {
        String germanLicense = "German License";
        String canadianFRLicense = "Canadian French License";
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId("some IU");
        iuDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iuDescription.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)new URI("http://example.com"), (String)"%license")});
        iuDescription.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"some IU", (Version)Version.createOSGi((int)1, (int)0, (int)0))));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription);
        int i = 0;
        while (i < 10) {
            MetadataFactory.InstallableUnitFragmentDescription installableUnitFragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
            installableUnitFragmentDescription.setId("fragment number: " + i);
            installableUnitFragmentDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
            installableUnitFragmentDescription.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"some IU", (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false)});
            installableUnitFragmentDescription.setProperty("org.eclipse.equinox.p2.type.fragment", "true");
            IInstallableUnitFragment iuFragment = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)installableUnitFragmentDescription);
            this.profile.addInstallableUnit((IInstallableUnit)iuFragment);
            ++i;
        }
        MetadataFactory.InstallableUnitFragmentDescription installableUnitFragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
        IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.localization", (String)"de", (Version)Version.createOSGi((int)1, (int)0, (int)0));
        ArrayList<IProvidedCapability> list = new ArrayList<IProvidedCapability>();
        list.add(providedCapability);
        installableUnitFragmentDescription.addProvidedCapabilities(list);
        installableUnitFragmentDescription.setId("german fragment");
        installableUnitFragmentDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        installableUnitFragmentDescription.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"some IU", (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false)});
        installableUnitFragmentDescription.setProperty("org.eclipse.equinox.p2.type.fragment", "true");
        installableUnitFragmentDescription.setProperty("de.license", germanLicense);
        IInstallableUnitFragment iuFragment = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)installableUnitFragmentDescription);
        this.profile.addInstallableUnit((IInstallableUnit)iuFragment);
        installableUnitFragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
        providedCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.localization", (String)"fr", (Version)Version.createOSGi((int)1, (int)0, (int)0));
        list = new ArrayList();
        list.add(providedCapability);
        installableUnitFragmentDescription.addProvidedCapabilities(list);
        installableUnitFragmentDescription.setId("cnd french fragment");
        installableUnitFragmentDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        installableUnitFragmentDescription.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"some IU", (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false)});
        installableUnitFragmentDescription.setProperty("org.eclipse.equinox.p2.type.fragment", "true");
        installableUnitFragmentDescription.setProperty("fr_CA.license", canadianFRLicense);
        iuFragment = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)installableUnitFragmentDescription);
        this.profile.addInstallableUnit((IInstallableUnit)iuFragment);
        this.profile.addInstallableUnit(iu);
        ILicense license = (ILicense)iu.getLicenses(Locale.GERMAN.toString()).iterator().next();
        TranslationSupportTests.assertEquals((String)"1.0", (String)germanLicense, (String)license.getBody());
        license = (ILicense)iu.getLicenses(Locale.CANADA_FRENCH.toString()).iterator().next();
        TranslationSupportTests.assertEquals((String)"1.1", (String)canadianFRLicense, (String)license.getBody());
    }

    public void testBasicIU() {
        IInstallableUnit unit = TranslationSupportTests.createIU((String)"f1");
        TranslationSupportTests.assertNull((String)"1.1", (Object)unit.getCopyright(null));
        TranslationSupportTests.assertEquals((String)"1.2", (int)0, (int)unit.getLicenses(null).size());
        TranslationSupportTests.assertNull((String)"1.3", (Object)unit.getProperty("org.eclipse.equinox.p2.name", null));
        TranslationSupportTests.assertNull((String)"1.4", (Object)unit.getProperty("org.eclipse.equinox.p2.description", null));
        TranslationSupportTests.assertNull((String)"1.5", (Object)unit.getProperty("org.eclipse.equinox.p2.provider", null));
    }
}

