/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AbstractAntProvisioningTest
extends AbstractProvisioningTest {
    protected static final String TYPE_ARTIFACT = "A";
    protected static final String TYPE_METADATA = "M";
    protected static final String TYPE_BOTH = null;
    private static final String TARGET = "target";
    private static final String ROOT = "project";
    private static final String NAME = "name";
    private static final String DEFAULT_TARGET = "default";
    private static final String DEFAULT_NAME = "default";
    AntTaskElement root;
    AntTaskElement target;
    File buildScript;
    File logLocation;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.buildScript = new File(this.getTestFolder(this.getName()), "build_" + this.getName() + ".xml");
        this.logLocation = new File(this.getTestFolder(this.getName()), "log_" + this.getName() + ".log");
        this.createBuildScript();
    }

    @Override
    public void tearDown() throws Exception {
        AbstractAntProvisioningTest.delete(this.buildScript.getParentFile());
        AbstractAntProvisioningTest.delete(this.logLocation.getParentFile());
        super.tearDown();
    }

    protected void runAntTask(File buildFile) {
        try {
            this.runAntTaskWithExceptions(buildFile);
        }
        catch (CoreException e) {
            AbstractAntProvisioningTest.fail(AbstractAntProvisioningTest.rootCause(e));
        }
    }

    private void runAntTaskWithExceptions(File buildFile) throws CoreException {
        AntRunner ant = new AntRunner();
        ant.setArguments("-logfile \"" + this.logLocation + "\"");
        ant.setBuildFileLocation(buildFile.getAbsolutePath());
        ant.addBuildLogger("org.apache.tools.ant.XmlLogger");
        ant.run();
    }

    protected void runAntTask() {
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            AbstractAntProvisioningTest.fail(AbstractAntProvisioningTest.rootCause(e));
        }
    }

    protected void runAntTaskWithExceptions() throws CoreException {
        try {
            this.writeBuildScript();
        }
        catch (Exception e) {
            AbstractAntProvisioningTest.fail("Error writing build script", e);
        }
        this.runAntTaskWithExceptions(this.buildScript);
    }

    protected void addTask(AntTaskElement task) {
        this.target.addElement(task);
    }

    protected AntTaskElement getRepositoryElement(URI address, String kind) {
        return this.getRepositoryElement(address, kind, null, null, null, null);
    }

    protected AntTaskElement getIUElement(String name, String version) {
        AntTaskElement iuElement = new AntTaskElement("iu");
        iuElement.addAttribute("id", name);
        if (version != null) {
            iuElement.addAttribute("version", version);
        }
        return iuElement;
    }

    protected AntTaskElement getRepositoryElement(URI address, String kind, String name, String format, Boolean compressed, Boolean append) {
        AntTaskElement repo = new AntTaskElement("repository");
        repo.addAttributes(new String[]{"location", URIUtil.toUnencodedString((URI)address)});
        if (kind != null) {
            repo.addAttributes(new String[]{"kind", kind});
        }
        if (name != null) {
            repo.addAttributes(new String[]{NAME, name});
        }
        if (format != null) {
            repo.addAttributes(new String[]{"format", format});
        }
        if (compressed != null) {
            repo.addAttributes(new String[]{"compressed", compressed.toString()});
        }
        if (append != null) {
            repo.addAttributes(new String[]{"append", append.toString()});
        }
        return repo;
    }

    protected AntTaskElement createIUElement(IInstallableUnit iu) {
        return this.createIUElement(iu.getId(), iu.getVersion().toString());
    }

    protected AntTaskElement createIUElement(String id, String version) {
        AntTaskElement iuElement = new AntTaskElement("iu");
        iuElement.addAttribute("id", id);
        iuElement.addAttribute("version", version);
        return iuElement;
    }

    private void createBuildScript() {
        this.root = new AntTaskElement(ROOT);
        this.root.addAttributes(new String[]{NAME, ROOT, "default", "default"});
        this.target = new AntTaskElement(TARGET);
        this.target.addAttributes(new String[]{NAME, "default"});
        this.root.addElement(this.target);
    }

    private void writeBuildScript() throws Exception {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(this.buildScript);
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, null);
            this.writeElement(writer, this.root);
            writer.flush();
        }
    }

    private void writeElement(XMLWriter writer, AntTaskElement task) {
        AbstractAntProvisioningTest.assertTrue((String)("Task " + task + " should have an even number of properties"), (task.attributes.size() % 2 == 0 ? 1 : 0) != 0);
        writer.start(task.name);
        Iterator iter = task.attributes.iterator();
        while (iter.hasNext()) {
            writer.attribute((String)iter.next(), (Object)((String)iter.next()));
        }
        iter = task.elements.iterator();
        while (iter.hasNext()) {
            this.writeElement(writer, (AntTaskElement)iter.next());
        }
        writer.end();
    }

    protected static Throwable rootCause(Throwable e) {
        if (e.getCause() != null) {
            return AbstractAntProvisioningTest.rootCause(e.getCause());
        }
        return e;
    }

    protected static void fail(Throwable e) {
        AbstractAntProvisioningTest.fail("An exception occurred while running the task", e);
    }

    protected void assertLogContains(String content) {
        try {
            AbstractAntProvisioningTest.assertLogContainsLine(this.logLocation, content);
        }
        catch (Exception e) {
            AbstractAntProvisioningTest.fail("Error asserting log contents.", e);
        }
    }

    protected static void assertIUContentEquals(String message, IQueryable source, IQueryable destination) {
        AbstractAntProvisioningTest.assertContains(message, source, destination);
        AbstractAntProvisioningTest.assertContains(message, destination, source);
    }

    protected void assertArtifactKeyContentEquals(String message, IQueryResult ius, URI artifactRepositoryLocation) {
        try {
            IArtifactRepository repo = AbstractAntProvisioningTest.getArtifactRepositoryManager().loadRepository(artifactRepositoryLocation, null);
            List fromIUs = AbstractAntProvisioningTest.getArtifactKeys((IQueryResult<IInstallableUnit>)ius);
            Iterator fromRepo = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).iterator();
            AbstractAntProvisioningTest.assertContains(message, fromIUs, fromRepo);
            AbstractAntProvisioningTest.assertContains(message, fromRepo, fromIUs);
        }
        catch (ProvisionException e) {
            AbstractAntProvisioningTest.fail("Failed to load repository", e);
        }
    }

    protected static List getArtifactKeys(IQueryResult<IInstallableUnit> ius) {
        ArrayList keys = new ArrayList();
        Iterator iter = ius.iterator();
        while (iter.hasNext()) {
            keys.addAll(((IInstallableUnit)iter.next()).getArtifacts());
        }
        return keys;
    }

    protected class AntTaskElement {
        public String name;
        public List attributes = new ArrayList();
        public List elements = new ArrayList();

        public AntTaskElement(String name) {
            this.name = name;
        }

        public AntTaskElement(String name, String[] attributes) {
            this.name = name;
            if (attributes != null && attributes.length > 0) {
                if (attributes.length % 2 != 0) {
                    throw new IllegalStateException();
                }
                this.attributes.addAll(Arrays.asList(attributes));
            }
        }

        public void addAttribute(String attribute, String value) {
            this.attributes.add(attribute);
            this.attributes.add(value);
        }

        public void addAttributes(String[] propertyArray) {
            this.attributes.addAll(Arrays.asList(propertyArray));
        }

        public void addElement(AntTaskElement element) {
            this.elements.add(element);
        }

        public String toString() {
            return this.name;
        }
    }
}

