/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.processors.pack200.Pack200ProcessorStep;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.jarprocessor.PackStep;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Bundle;

public class Pack200ProcessorTest
extends AbstractProvisioningTest {
    private File tempFolder;

    public Pack200ProcessorTest(String name) {
        super(name);
    }

    public Pack200ProcessorTest() {
        super("");
    }

    public void DISABLE_testUnpack() throws IOException {
        if (!PackStep.canPack()) {
            return;
        }
        Pack200ProcessorStep step = new Pack200ProcessorStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/optimizers/org.eclipse.equinox.app_1.0.100.v20071015.jar.pack.gz").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        inputStream = bundle.getEntry("testData/optimizers/org.eclipse.equinox.app_1.0.100.v20071015.jar").openStream();
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)expected, (boolean)true);
        Pack200ProcessorTest.assertTrue((boolean)Arrays.equals(expected.toByteArray(), destination.toByteArray()));
    }

    public void testUnpackFailsBecauseOfZeroLengthPackedFile() throws IOException {
        Pack200ProcessorStep step = new Pack200ProcessorStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        Pack200ProcessorTest.assertFalse((boolean)step.getStatus().isOK());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tempFolder = this.getTempFolder();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Pack200ProcessorTest.delete(this.tempFolder);
    }

    public void testUnpackFileNotPackedByJarProcessor() throws IOException {
        if (!PackStep.canPack()) {
            return;
        }
        Pack200ProcessorStep step = new Pack200ProcessorStep();
        File destinationFile = new File(this.tempFolder, "testUnpackFileNotPackedByJarProcessor.jar");
        BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(destinationFile));
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/optimizers/bug387557.bundle_1.0.0.201208200951.jar.pack.gz").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ((OutputStream)destination).close();
        File expected = Pack200ProcessorTest.getTestData("Missing test data", "testData/optimizers/bug387557.bundle_1.0.0.201208200951.jar");
        this.assertEqualJars(expected, destinationFile);
    }
}

