/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ArtifactLockingTest
extends AbstractProvisioningTest {
    private File targetLocation;
    private SimpleArtifactRepository repo1 = null;
    private SimpleArtifactRepository repo2 = null;
    private boolean lockingValue = false;
    boolean canContinue = false;
    private boolean keepRunning = true;
    IStatus status = null;
    IStatus status1 = null;
    IStatus status2 = null;
    boolean lockAcquired = false;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.lockingValue = Activator.getInstance().enableArtifactLocking();
        System.setProperty("eclipse.p2.internal.simple.artifact.repository.locking", "true");
        this.targetLocation = File.createTempFile("bundlepool", ".repo");
        this.targetLocation.delete();
        this.targetLocation.mkdirs();
        this.repo1 = new SimpleArtifactRepository(ArtifactLockingTest.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
        Thread.sleep(1000L);
        this.repo2 = new SimpleArtifactRepository(ArtifactLockingTest.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
    }

    @Override
    protected void tearDown() throws Exception {
        System.setProperty("eclipse.p2.internal.simple.artifact.repository.locking", "" + this.lockingValue);
        this.targetLocation.delete();
        super.tearDown();
    }

    public void testCancelLoad() throws InterruptedException, ProvisionException {
        this.canContinue = false;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        new Thread(new Runnable((IProgressMonitor)progressMonitor){
            private final /* synthetic */ IProgressMonitor val$progressMonitor;
            {
                this.val$progressMonitor = iProgressMonitor;
            }

            @Override
            public void run() {
                ArtifactLockingTest.this.status = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        try {
                            (this).ArtifactLockingTest.this.canContinue = true;
                            Thread.sleep(3000L);
                            ArtifactLockingTest.this.repo1.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
                            val$progressMonitor.setCanceled(true);
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }).start();
        while (!this.canContinue) {
            Thread.sleep(100L);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)ArtifactLockingTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        boolean expected = false;
        try {
            artifactManager.loadRepository(this.targetLocation.toURI(), (IProgressMonitor)progressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            expected = true;
        }
        ArtifactLockingTest.assertTrue((String)"Expected an Operation Cancled Exception", (boolean)expected);
    }

    public void testWaitForLoad() throws InterruptedException, ProvisionException {
        this.canContinue = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        try {
                            (this).ArtifactLockingTest.this.canContinue = true;
                            Thread.sleep(6000L);
                            ArtifactLockingTest.this.repo1.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }).start();
        while (!this.canContinue) {
            Thread.sleep(100L);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)ArtifactLockingTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        SimpleArtifactRepository artifactRepository = (SimpleArtifactRepository)artifactManager.loadRepository(this.targetLocation.toURI(), (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)1, (int)artifactRepository.getDescriptors().size());
    }

    public void testCancel() throws InterruptedException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.keepRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        long start = System.currentTimeMillis();
                        while (ArtifactLockingTest.this.keepRunning) {
                            long current = System.currentTimeMillis();
                            if (current - start > 10000L) {
                                ArtifactLockingTest.fail((String)"Test case never finished. Likely keep running was never set to false.");
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }).start();
        Thread.sleep(1000L);
        Thread t = new Thread(new Runnable((IProgressMonitor)progressMonitor){
            private final /* synthetic */ IProgressMonitor val$progressMonitor;
            {
                this.val$progressMonitor = iProgressMonitor;
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                this.val$progressMonitor.setCanceled(true);
            }
        });
        t.start();
        this.repo2.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)progressMonitor);
        this.keepRunning = false;
        if (this.status != null && !this.status.isOK()) {
            ArtifactLockingTest.fail((String)this.status.getMessage());
        }
        ArtifactLockingTest.assertEquals((int)0, (int)this.repo2.getDescriptors().size());
    }

    public void testCancelRead() throws InterruptedException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.keepRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        long start = System.currentTimeMillis();
                        while (ArtifactLockingTest.this.keepRunning) {
                            long current = System.currentTimeMillis();
                            if (current - start > 10000L) {
                                ArtifactLockingTest.fail((String)"Test case never finished. Likely keep running was never set to false.");
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }).start();
        Thread.sleep(1000L);
        Thread t = new Thread(new Runnable((IProgressMonitor)progressMonitor){
            private final /* synthetic */ IProgressMonitor val$progressMonitor;
            {
                this.val$progressMonitor = iProgressMonitor;
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                this.val$progressMonitor.setCanceled(true);
            }
        });
        t.start();
        this.repo2.getDescriptors();
        this.keepRunning = false;
        if (this.status != null && !this.status.isOK()) {
            ArtifactLockingTest.fail((String)this.status.getMessage());
        }
    }

    public void testMultipleExecuteBatch() throws InterruptedException {
        this.lockAcquired = false;
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status1 = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        try {
                            if ((this).ArtifactLockingTest.this.lockAcquired) {
                                throw new RuntimeException("Lock already acquired");
                            }
                            (this).ArtifactLockingTest.this.lockAcquired = true;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        finally {
                            (this).ArtifactLockingTest.this.lockAcquired = false;
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        t1.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status2 = ArtifactLockingTest.this.repo2.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        try {
                            if ((this).ArtifactLockingTest.this.lockAcquired) {
                                throw new RuntimeException("Lock already acquired");
                            }
                            (this).ArtifactLockingTest.this.lockAcquired = true;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        finally {
                            (this).ArtifactLockingTest.this.lockAcquired = false;
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        t2.start();
        t1.join();
        t2.join();
        if (!this.status1.isOK() || !this.status2.isOK()) {
            ArtifactLockingTest.fail((String)"Test failed, a lock acquired simultaneously by both execute batch operations");
        }
    }

    public void testWait() throws InterruptedException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArtifactLockingTest.this.status = ArtifactLockingTest.this.repo1.executeBatch(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws OperationCanceledException {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }).start();
        Thread.sleep(1000L);
        this.repo2.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo2.getDescriptors().size());
    }

    public void testMultipleAddDescriptors() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo2.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo2.getDescriptors().size());
    }

    public void testContainsDescriptor() throws InterruptedException {
        ArtifactKey k = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d = new SimpleArtifactDescriptor((IArtifactKey)k);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d, (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertTrue((boolean)this.repo2.contains((IArtifactDescriptor)d));
    }

    public void testContainsKey() throws InterruptedException {
        ArtifactKey k = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d = new SimpleArtifactDescriptor((IArtifactKey)k);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d, (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertTrue((boolean)this.repo2.contains((IArtifactKey)k));
    }

    public void testMultipleRemoveDescriptors() throws InterruptedException {
        SimpleArtifactDescriptor d1 = new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0")));
        SimpleArtifactDescriptor d2 = new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0")));
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo1.removeDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo2.removeDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)0, (int)this.repo2.getDescriptors().size());
    }

    public void testMultipleRemoveKeys() throws InterruptedException {
        ArtifactKey k1 = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        ArtifactKey k2 = new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d1 = new SimpleArtifactDescriptor((IArtifactKey)k1);
        SimpleArtifactDescriptor d2 = new SimpleArtifactDescriptor((IArtifactKey)k2);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo1.removeDescriptor((IArtifactKey)k1, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo2.getDescriptors().size());
        this.repo2.removeDescriptor((IArtifactKey)k2, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)0, (int)this.repo2.getDescriptors().size());
    }

    public void testRemoveBulkKeys() throws InterruptedException {
        ArtifactKey k1 = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        ArtifactKey k2 = new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"));
        ArtifactKey k3 = new ArtifactKey("org.eclipse.test", "test3", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d1 = new SimpleArtifactDescriptor((IArtifactKey)k1);
        SimpleArtifactDescriptor d2 = new SimpleArtifactDescriptor((IArtifactKey)k2);
        SimpleArtifactDescriptor d3 = new SimpleArtifactDescriptor((IArtifactKey)k3);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d3, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)3, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo2.removeDescriptors(new IArtifactKey[]{k1, k2}, (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo2.getDescriptors().size());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo1.getDescriptors().size());
    }

    public void testRemoveBulkDescriptors() throws InterruptedException {
        ArtifactKey k1 = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        ArtifactKey k2 = new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"));
        ArtifactKey k3 = new ArtifactKey("org.eclipse.test", "test3", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d1 = new SimpleArtifactDescriptor((IArtifactKey)k1);
        SimpleArtifactDescriptor d2 = new SimpleArtifactDescriptor((IArtifactKey)k2);
        SimpleArtifactDescriptor d3 = new SimpleArtifactDescriptor((IArtifactKey)k3);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d3, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)3, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo2.removeDescriptors(new IArtifactDescriptor[]{d1, d2}, (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo2.getDescriptors().size());
        ArtifactLockingTest.assertEquals((int)1, (int)this.repo1.getDescriptors().size());
    }

    public void testRemoveAll() throws InterruptedException {
        ArtifactKey k1 = new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"));
        ArtifactKey k2 = new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"));
        SimpleArtifactDescriptor d1 = new SimpleArtifactDescriptor((IArtifactKey)k1);
        SimpleArtifactDescriptor d2 = new SimpleArtifactDescriptor((IArtifactKey)k2);
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)new NullProgressMonitor());
        this.repo1.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo1.getDescriptors().size());
        Thread.sleep(1000L);
        this.repo2.removeAll((IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((int)0, (int)this.repo2.getDescriptors().size());
        ArtifactLockingTest.assertEquals((int)0, (int)this.repo1.getDescriptors().size());
    }

    public void testReloadAdds() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test1", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        this.repo2.addDescriptor((IArtifactDescriptor)new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.test", "test2", Version.create((String)"1.0.0"))), (IProgressMonitor)new NullProgressMonitor());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo2.getDescriptors().size());
        ArtifactLockingTest.assertEquals((int)2, (int)this.repo1.getDescriptors().size());
    }

    public void _testSetProperty() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.setProperty("foo", "bar", (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((String)"bar", (String)this.repo1.getProperty("foo"));
        ArtifactLockingTest.assertEquals((String)"bar", (String)this.repo2.getProperty("foo"));
    }

    public void _testGetProperties() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.setProperty("foo", "bar", (IProgressMonitor)new NullProgressMonitor());
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((String)"bar", (String)((String)this.repo1.getProperties().get("foo")));
        ArtifactLockingTest.assertEquals((String)"bar", (String)((String)this.repo2.getProperties().get("foo")));
    }

    public void _testSetName() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.setName("Foo");
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((String)"Foo", (String)this.repo1.getName());
        ArtifactLockingTest.assertEquals((String)"Foo", (String)this.repo2.getName());
    }

    public void _testSetDescription() throws InterruptedException {
        Thread.sleep(1000L);
        this.repo1.setDescription("Foo Bar");
        Thread.sleep(1000L);
        ArtifactLockingTest.assertEquals((String)"Foo Bar", (String)this.repo1.getDescription());
        ArtifactLockingTest.assertEquals((String)"Foo Bar", (String)this.repo2.getDescription());
    }
}

