/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ArtifactOutputStreamTest
extends AbstractProvisioningTest {
    private SimpleArtifactRepository sar = null;
    private ProcessingStep destination = null;
    private IArtifactKey ak = null;
    private IArtifactDescriptor ad = null;
    private SimpleArtifactRepository.ArtifactOutputStream aos = null;
    private File temp = null;
    private File tempWritableLocation = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tempWritableLocation = File.createTempFile("artifact", ".repo");
        this.tempWritableLocation.delete();
        this.tempWritableLocation.mkdirs();
        this.sar = new SimpleArtifactRepository(ArtifactOutputStreamTest.getAgent(), "name", this.tempWritableLocation.toURI(), null);
        this.destination = new Destination();
        this.ak = new ArtifactKey("classifier", "id", Version.create((String)"1.0"));
        this.ad = new ArtifactDescriptor(this.ak);
        this.temp = File.createTempFile("ArtifactOutputStreamTest", ".tmp");
        this.temp.deleteOnExit();
        SimpleArtifactRepository simpleArtifactRepository = this.sar;
        simpleArtifactRepository.getClass();
        this.aos = new SimpleArtifactRepository.ArtifactOutputStream(simpleArtifactRepository, (OutputStream)this.destination, this.ad, this.temp);
        ArtifactOutputStreamTest.assertNotNull((Object)this.aos);
        Destination.ioe = null;
        Destination.baos = null;
    }

    @Override
    protected void tearDown() throws Exception {
        AbstractProvisioningTest.delete(this.temp);
        AbstractProvisioningTest.delete(this.tempWritableLocation);
        super.tearDown();
    }

    public void testStatefullness() {
        ArtifactOutputStreamTest.assertTrue((boolean)(this.aos instanceof IStateful));
        ArtifactOutputStreamTest.assertTrue((boolean)(this.aos instanceof SimpleArtifactRepository.ArtifactOutputStream));
    }

    public void testSingleCloseStreamOkDestinationOk() throws IOException {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        this.aos.write(22);
        this.aos.close();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        ArtifactOutputStreamTest.assertEquals((String)"1", (String)this.ad.getProperty("download.size"));
    }

    public void testDoubleCloseStreamOkDestinationOk() throws IOException {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        this.aos.write(22);
        this.aos.close();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        ArtifactOutputStreamTest.assertEquals((String)"1", (String)this.ad.getProperty("download.size"));
        this.aos.close();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
    }

    public void testSingleCloseStreamNotOkDestinationOk() throws IOException {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        this.aos.setStatus(Status.CANCEL_STATUS);
        this.aos.close();
        ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
    }

    public void testSingleCloseStreamOkDestinationNotOk() throws IOException {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        this.destination.setStatus(Status.CANCEL_STATUS);
        this.aos.close();
        ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
    }

    public void testSingleCloseStreamOkDestinationCloseFails() {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        Destination.ioe = new IOException("Expected");
        try {
            try {
                this.aos.close();
                ArtifactOutputStreamTest.assertTrue((boolean)false);
            }
            catch (IOException iOException) {
                ArtifactOutputStreamTest.assertTrue((boolean)true);
                ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
            }
        }
        finally {
            ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
        }
    }

    public void testSingleCloseStreamNotOkDestinationCloseFails() {
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        Destination.ioe = new IOException("Expected");
        this.aos.setStatus(Status.CANCEL_STATUS);
        try {
            try {
                this.aos.close();
            }
            catch (IOException iOException) {
                ArtifactOutputStreamTest.assertTrue((boolean)false);
                ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
            }
        }
        finally {
            ArtifactOutputStreamTest.assertFalse((boolean)this.temp.exists());
        }
    }

    public void testWriteToDestinationStreamOkDestinationOk() throws IOException {
        Destination.baos = new ByteArrayOutputStream();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        this.aos.write(22);
        this.aos.close();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        ArtifactOutputStreamTest.assertEquals((String)"1", (String)this.ad.getProperty("download.size"));
        this.aos.close();
        ArtifactOutputStreamTest.assertTrue((boolean)this.temp.exists());
        ArtifactOutputStreamTest.assertEquals((int)1, (int)Destination.baos.toByteArray().length);
        ArtifactOutputStreamTest.assertEquals((int)22, (int)Destination.baos.toByteArray()[0]);
    }

    static class Destination
    extends ProcessingStep {
        static IOException ioe = null;
        static ByteArrayOutputStream baos = null;

        Destination() {
        }

        public void close() throws IOException {
            super.close();
            if (ioe != null) {
                throw ioe;
            }
        }

        public void write(int b) {
            if (baos != null) {
                baos.write(b);
            }
        }
    }
}

