/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.Sizing;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ArtifactRepositoryMissingSizeData
extends AbstractProvisioningTest {
    private static final String testDataLocation = "testData/artifactRepo/missingArtifact";
    IArtifactRepository source = null;
    IMetadataRepository metaRepo;
    URI uri;
    IInstallableUnit missingArtifactIU;
    IInstallableUnit missingSizeIU;
    ProvisioningContext context;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IMetadataRepositoryManager mmgr = ArtifactRepositoryMissingSizeData.getMetadataRepositoryManager();
        this.uri = ArtifactRepositoryMissingSizeData.getTestData("MissingArtifact repo", testDataLocation).toURI();
        this.metaRepo = mmgr.loadRepository(this.uri, null);
        this.missingArtifactIU = (IInstallableUnit)this.metaRepo.query(QueryUtil.createIUQuery((String)"javax.wsdl", (VersionRange)new VersionRange("[1.5, 1.6)")), null).iterator().next();
        this.missingSizeIU = (IInstallableUnit)this.metaRepo.query(QueryUtil.createIUQuery((String)"javax.wsdl", (VersionRange)new VersionRange("[1.4, 1.5)")), null).iterator().next();
        IArtifactRepositoryManager mgr = ArtifactRepositoryMissingSizeData.getArtifactRepositoryManager();
        this.source = mgr.loadRepository(this.uri, null);
        this.context = new ProvisioningContext(ArtifactRepositoryMissingSizeData.getAgent());
        this.context.setMetadataRepositories(new URI[]{this.metaRepo.getLocation()});
        this.context.setArtifactRepositories(new URI[]{this.source.getLocation()});
        this.engine = this.getEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        ArtifactRepositoryMissingSizeData.getMetadataRepositoryManager().removeRepository(this.uri);
        ArtifactRepositoryMissingSizeData.getArtifactRepositoryManager().removeRepository(this.uri);
    }

    public void testMissingArtifact() {
        IProfile profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(profile1);
        req.add(this.missingArtifactIU);
        req.setInstallableUnitInclusionRules(this.missingArtifactIU, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.missingArtifactIU));
        IProvisioningPlan plan = ArtifactRepositoryMissingSizeData.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, this.context, null);
        ArtifactRepositoryMissingSizeData.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        Sizing sizing = new Sizing(100);
        SPhaseSet set = new SPhaseSet((Phase)sizing);
        IStatus status = this.engine.perform(plan, (IPhaseSet)set, (IProgressMonitor)new NullProgressMonitor());
        if (!status.matches(4)) {
            ArtifactRepositoryMissingSizeData.fail((String)"Incorrect status for missing artifact during Sizing.");
        }
    }

    public void testMissingSize() {
        IProfile profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(profile1);
        req.add(this.missingSizeIU);
        req.setInstallableUnitInclusionRules(this.missingSizeIU, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.missingSizeIU));
        IProvisioningPlan plan = ArtifactRepositoryMissingSizeData.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, this.context, null);
        ArtifactRepositoryMissingSizeData.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        Sizing sizing = new Sizing(100);
        SPhaseSet set = new SPhaseSet((Phase)sizing);
        IStatus status = this.engine.perform(plan, (IPhaseSet)set, (IProgressMonitor)new NullProgressMonitor());
        if (!status.matches(2) && status.getCode() != 1202) {
            ArtifactRepositoryMissingSizeData.fail((String)"Incorrect status for missing file size during Sizing");
        }
    }

    private class SPhaseSet
    extends PhaseSet {
        public SPhaseSet(Phase set) {
            super(new Phase[]{set});
        }
    }
}

