/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ArtifactRepositoryWithReferenceDescriptors
extends AbstractProvisioningTest {
    IArtifactRepository repo = null;
    SimpleArtifactDescriptor descriptor1 = null;
    SimpleArtifactDescriptor descriptor2 = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.repo = this.createArtifactRepository(this.getTempFolder().toURI(), null);
        File fileLocation = ArtifactRepositoryWithReferenceDescriptors.getTestData("Artifacts for repositor with references", "testData/referenceArtifactRepo/test1 Reference.jar");
        this.descriptor1 = new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "test1Reference", Version.create((String)"1.0.0")));
        this.descriptor1.setProcessingSteps(new IProcessingStepDescriptor[0]);
        this.descriptor1.setRepositoryProperty("artifact.reference", fileLocation.toURL().toExternalForm());
        this.descriptor1.setRepositoryProperty("file.name", fileLocation.getAbsolutePath());
        this.descriptor1.setRepositoryProperty("file.lastModified", Long.toString(fileLocation.lastModified()));
        this.descriptor2 = new SimpleArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "test1Reference", Version.create((String)"1.0.0")));
        this.descriptor2.setProcessingSteps(new IProcessingStepDescriptor[0]);
        this.descriptor2.setRepositoryProperty("artifact.reference", fileLocation.toURI().toString());
        this.descriptor2.setRepositoryProperty("file.name", fileLocation.getAbsolutePath());
        this.descriptor2.setRepositoryProperty("file.lastModified", Long.toString(fileLocation.lastModified()));
        this.repo.addDescriptor((IArtifactDescriptor)this.descriptor1);
        this.repo.addDescriptor((IArtifactDescriptor)this.descriptor2);
    }

    public void testOldStyleReference() {
        IStatus s = this.repo.getArtifact((IArtifactDescriptor)this.descriptor1, (OutputStream)new ByteArrayOutputStream(500), (IProgressMonitor)new NullProgressMonitor());
        if (!s.isOK()) {
            ArtifactRepositoryWithReferenceDescriptors.fail((String)("1.0 Can not find artifact for the given descriptor. Status" + s.toString()));
        }
    }

    public void testNewStyleReference() {
        IStatus s = this.repo.getArtifact((IArtifactDescriptor)this.descriptor2, (OutputStream)new ByteArrayOutputStream(500), (IProgressMonitor)new NullProgressMonitor());
        if (!s.isOK()) {
            ArtifactRepositoryWithReferenceDescriptors.fail((String)("1.1 Can not find artifact for the given descriptor. Status" + s.toString()));
        }
    }
}

