/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug252308
extends AbstractProvisioningTest {
    private Method transferSingle;
    private Method extractRootCause;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.extractRootCause = MirrorRequest.class.getDeclaredMethod("extractRootCause", IStatus.class);
        this.extractRootCause.setAccessible(true);
        this.transferSingle = MirrorRequest.class.getDeclaredMethod("transferSingle", IArtifactDescriptor.class, IArtifactDescriptor.class, IProgressMonitor.class);
        this.transferSingle.setAccessible(true);
    }

    private IStatus extractRootCause(IStatus status) throws Exception {
        return (IStatus)this.extractRootCause.invoke(null, status);
    }

    private IStatus transferSingle(MirrorRequest request, IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) throws Exception {
        return (IStatus)this.transferSingle.invoke((Object)request, destinationDescriptor, sourceDescriptor, monitor);
    }

    public void testExtractRootCauseNullStatus() throws Exception {
        IStatus status = this.extractRootCause(null);
        Bug252308.assertNull((Object)status);
    }

    public void testExtractRootCauseWarningStatus() throws Exception {
        IStatus status = this.extractRootCause((IStatus)new Status(2, "id1", "Test", (Throwable)new IOException("IO")));
        Bug252308.assertNull((Object)status);
    }

    public void testExtractRootCauseErrorStatusWithException() throws Exception {
        IStatus status = this.extractRootCause((IStatus)new Status(4, "id1", "Test", (Throwable)new IOException("IO")));
        Bug252308.assertNotNull((Object)status);
        Bug252308.assertEquals((String)"id1", (String)status.getPlugin());
        Bug252308.assertEquals((String)"Test", (String)status.getMessage());
        Bug252308.assertEquals((String)"IO", (String)status.getException().getMessage());
    }

    public void testExtractRootCauseFromFlatMultiStatus() throws Exception {
        MultiStatus multiStatus = new MultiStatus("id1", 0, "Message", (Throwable)new FileNotFoundException("FNFE"));
        IStatus status = this.extractRootCause((IStatus)multiStatus);
        Bug252308.assertNull((Object)status);
    }

    public void testExtractRootCauseFromNestedMultiStatus() throws Exception {
        MultiStatus multiStatus = new MultiStatus("id0", 0, "Message", (Throwable)new FileNotFoundException("FNFE"));
        Status status1 = new Status(2, "id1", "Test", (Throwable)new IOException("IO"));
        Status status2 = new Status(4, "id2", "Test", (Throwable)new IOException("IO"));
        Status status3 = new Status(4, "id3", "Test", null);
        multiStatus.add((IStatus)status1);
        multiStatus.add((IStatus)status2);
        multiStatus.add((IStatus)status3);
        IStatus status = this.extractRootCause((IStatus)multiStatus);
        Bug252308.assertNotNull((Object)status);
        Bug252308.assertEquals((String)"id2", (String)status.getPlugin());
    }

    public void testExtractRootCauseFromNestedNestedMultiStatus() throws Exception {
        MultiStatus multiStatus = new MultiStatus("id0", 0, "Message", (Throwable)new FileNotFoundException("FNFE"));
        Status status1 = new Status(2, "id1", "Test", (Throwable)new IOException("IO"));
        MultiStatus status2 = new MultiStatus("id2", 0, "Test", null);
        Status status3 = new Status(4, "id3", "Test", (Throwable)new NullPointerException("NPE"));
        multiStatus.add((IStatus)status1);
        multiStatus.add((IStatus)status2);
        multiStatus.add((IStatus)status3);
        Status status21 = new Status(2, "id21", "Test", (Throwable)new IOException("IO"));
        Status status22 = new Status(4, "id22", "Test", (Throwable)new IOException("IO"));
        Status status23 = new Status(4, "id23", "Test", (Throwable)new ProvisionException("PE"));
        status2.add((IStatus)status21);
        status2.add((IStatus)status22);
        status2.add((IStatus)status23);
        IStatus status = this.extractRootCause((IStatus)multiStatus);
        Bug252308.assertNotNull((Object)status);
        Bug252308.assertEquals((String)"id22", (String)status.getPlugin());
    }

    public void testTransferError() throws Exception {
        File simpleRepo = Bug252308.getTestData("simple repository", "testData/artifactRepo/transferTestRepo");
        IArtifactRepository source = null;
        IArtifactRepository target = null;
        try {
            source = Bug252308.getArtifactRepositoryManager().loadRepository(simpleRepo.toURI(), (IProgressMonitor)new NullProgressMonitor());
            target = this.createArtifactRepository(new File(this.getTempFolder(), this.getName()).toURI(), null);
        }
        catch (ProvisionException e) {
            Bug252308.fail("failing setting up the tests", e);
        }
        IArtifactDescriptor sourceDescriptor = this.getArtifactKeyFor(source, "osgi.bundle", "missingFromFileSystem", Version.createOSGi((int)1, (int)0, (int)0))[0];
        SimpleArtifactDescriptor targetDescriptor = new SimpleArtifactDescriptor(sourceDescriptor);
        targetDescriptor.setRepositoryProperty("artifact.folder", "true");
        class TestRequest
        extends MirrorRequest {
            public TestRequest(IArtifactKey key, IArtifactRepository targetRepository, Map<String, String> targetDescriptorProperties, Map<String, String> targetRepositoryProperties) {
                super(key, targetRepository, targetDescriptorProperties, targetRepositoryProperties, Bug252308.this.getTransport());
            }

            public void setSource(IArtifactRepository source) {
                super.setSourceRepository(source);
            }
        }
        TestRequest request = new TestRequest((IArtifactKey)new ArtifactKey("osgi.bundle", "missingFromFileSystem", Version.createOSGi((int)1, (int)0, (int)0)), target, null, null);
        request.setSource(source);
        IStatus s = this.transferSingle(request, (IArtifactDescriptor)targetDescriptor, sourceDescriptor, (IProgressMonitor)new NullProgressMonitor());
        Bug252308.assertTrue((String)s.toString(), (s.getException().getClass() == FileNotFoundException.class ? 1 : 0) != 0);
    }

    private IArtifactDescriptor[] getArtifactKeyFor(IArtifactRepository repo, String classifier, String id, Version version) {
        return repo.getArtifactDescriptors((IArtifactKey)new ArtifactKey(classifier, id, version));
    }
}

