/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.comparator.MD5ArtifactComparator;
import org.eclipse.equinox.p2.internal.repository.tools.ArtifactRepositoryValidator;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class CompositeArtifactRepositoryTest
extends AbstractProvisioningTest {
    private static final String TEST_KEY = "TestKey";
    private static final String TEST_VALUE = "TestValue";
    private File repositoryFile = null;
    private URI repositoryURI = null;
    private int childCount = 0;

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.repositoryURI != null) {
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(this.repositoryURI);
            this.repositoryURI = null;
        }
        if (this.repositoryFile != null) {
            CompositeArtifactRepositoryTest.delete(this.repositoryFile);
            this.repositoryFile = null;
        }
    }

    public void testCompressedRepositoryCreation() {
        this.createRepo(true);
        File[] files = this.repositoryFile.listFiles();
        boolean jarFilePresent = false;
        boolean artifactFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("compositeArtifacts.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            if ("compositeArtifacts.xml".equalsIgnoreCase(files[i].getName())) {
                artifactFilePresent = false;
            }
            ++i;
        }
        if (!jarFilePresent) {
            CompositeArtifactRepositoryTest.fail((String)"Repository should create JAR for compositeArtifacts.xml");
        }
        if (artifactFilePresent) {
            CompositeArtifactRepositoryTest.fail((String)"Repository should not create compositeArtifacts.xml");
        }
    }

    public void testVerifyUncompressedRepositoryCreation() {
        this.createRepo(false);
        File[] files = this.repositoryFile.listFiles();
        boolean jarFilePresent = false;
        boolean artifactFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("compositeArtifacts.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            if ("compositeArtifacts.xml".equalsIgnoreCase(files[i].getName())) {
                artifactFilePresent = true;
            }
            ++i;
        }
        if (jarFilePresent) {
            CompositeArtifactRepositoryTest.fail((String)"Repository should not create JAR for compositeArtifacts.xml");
        }
        if (!artifactFilePresent) {
            CompositeArtifactRepositoryTest.fail((String)"Repository should create compositeArtifacts.xml");
        }
    }

    public void testAddDescriptor() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        try {
            compRepo.addDescriptor(descriptor);
            CompositeArtifactRepositoryTest.fail((String)"Should not be able to add Artifact Descriptor");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testAddDescriptors() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        IArtifactDescriptor[] descriptors = new IArtifactDescriptor[]{descriptor};
        try {
            compRepo.addDescriptors(descriptors);
            CompositeArtifactRepositoryTest.fail((String)"Should not be able to add Artifact Descriptors using an array");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveDescriptorUsingDescriptor() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        try {
            compRepo.removeDescriptor(descriptor);
            CompositeArtifactRepositoryTest.fail((String)"Should not be able to remove Artifact Descriptor using a Artifact Descriptor");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveDescriptorUsingKey() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        try {
            compRepo.removeDescriptor((IArtifactKey)key);
            CompositeArtifactRepositoryTest.fail((String)"Should not be able to remove Artifact Descriptor using an Artifact Key");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveAll() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        try {
            compRepo.removeAll();
            CompositeArtifactRepositoryTest.fail((String)"Should not be able to Remove All");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testGetProperties() {
        IArtifactRepositoryManager manager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        this.repositoryFile = new File(this.getTempFolder(), "CompositeArtifactRepositoryTest");
        IArtifactRepository repo = null;
        try {
            repo = manager.createRepository(this.repositoryFile.toURI(), "TestRepo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Cannot create repository: ", e);
        }
        Map properties = repo.getProperties();
        try {
            properties.put(TEST_KEY, TEST_VALUE);
            CompositeArtifactRepositoryTest.fail((String)"Should not allow setting property");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testSetProperty() {
        IArtifactRepositoryManager manager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        this.repositoryFile = new File(this.getTempFolder(), "CompositeArtifactRepositoryTest");
        IArtifactRepository repo = null;
        try {
            repo = manager.createRepository(this.repositoryFile.toURI(), "TestRepo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Cannot create repository: ", e);
        }
        Map properties = repo.getProperties();
        CompositeArtifactRepositoryTest.assertTrue((String)"1.0", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        repo.setProperty(TEST_KEY, TEST_VALUE);
        CompositeArtifactRepositoryTest.assertTrue((String)"1.1", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        properties = repo.getProperties();
        CompositeArtifactRepositoryTest.assertTrue((String)"1.2", (boolean)properties.containsKey(TEST_KEY));
        try {
            repo = manager.loadRepository(this.repositoryFile.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Cannot load repository: ", e);
        }
        properties = repo.getProperties();
        CompositeArtifactRepositoryTest.assertTrue((String)"1.3", (boolean)properties.containsKey(TEST_KEY));
        repo.setProperty(TEST_KEY, null);
        properties = repo.getProperties();
        CompositeArtifactRepositoryTest.assertTrue((String)"1.4", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
    }

    public void testAddChild() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        IArtifactRepository repo = null;
        try {
            repo = artifactRepositoryManager.loadRepository(child.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repository for verification", e);
        }
        CompositeArtifactRepositoryTest.assertContentEquals("Verifying contents", (IArtifactRepository)compRepo, repo);
    }

    public void testRemoveChild() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        compRepo.removeChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size after remove", (int)0, (int)compRepo.getChildren().size());
    }

    public void testAddRepeatChild() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        compRepo.addChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size after repeat entry", (int)1, (int)compRepo.getChildren().size());
    }

    public void testAddMultipleChildren() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child1 = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File child2 = CompositeArtifactRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 2 children", (int)2, (int)compRepo.getChildren().size());
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        try {
            repo1 = artifactRepositoryManager.loadRepository(child1.toURI(), null);
            repo2 = artifactRepositoryManager.loadRepository(child2.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repositories for verification", e);
        }
        CompositeArtifactRepositoryTest.assertContains("Assert child1's content is in composite repo", repo1, (IArtifactRepository)compRepo);
        CompositeArtifactRepositoryTest.assertContains("Assert child2's content is in composite repo", repo2, (IArtifactRepository)compRepo);
        CompositeArtifactRepositoryTest.assertEquals((String)"Assert Correct Number of Keys", (int)(this.getArtifactKeyCount(repo1) + this.getArtifactKeyCount(repo2)), (int)this.getArtifactKeyCount((IArtifactRepository)compRepo));
    }

    public void testRemoveNonexistantChild() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File invalidChild = CompositeArtifactRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.removeChild(invalidChild.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size after remove", (int)1, (int)compRepo.getChildren().size());
    }

    public void testRemoveAllChildren() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        CompositeArtifactRepositoryTest.assertEquals((String)"Initial Children size", (int)0, (int)compRepo.getChildren().size());
        File child1 = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 1 child", (int)1, (int)compRepo.getChildren().size());
        File child2 = CompositeArtifactRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size with 2 children", (int)2, (int)compRepo.getChildren().size());
        compRepo.removeAllChildren();
        CompositeArtifactRepositoryTest.assertEquals((String)"Children size after removeAllChildren", (int)0, (int)compRepo.getChildren().size());
    }

    public void testContainsKey() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        IArtifactRepository repo = null;
        try {
            repo = artifactRepositoryManager.loadRepository(child.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repository for verification", e);
        }
        IQueryResult keys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact keys", (!keys.isEmpty() ? 1 : 0) != 0);
        CompositeArtifactRepositoryTest.assertTrue((String)"Asserting key is in composite repo", (boolean)compRepo.contains((IArtifactKey)keys.iterator().next()));
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        CompositeArtifactRepositoryTest.assertFalse((String)"Asserting key is not in composite repo", (boolean)compRepo.contains((IArtifactKey)key));
    }

    public void testContainsDescriptor() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        IArtifactRepository repo = null;
        try {
            repo = artifactRepositoryManager.loadRepository(child.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repository for verification", e);
        }
        IQueryResult keys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact keys", (!keys.isEmpty() ? 1 : 0) != 0);
        IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors((IArtifactKey)keys.iterator().next());
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact descriptors", (descriptors.length > 0 ? 1 : 0) != 0);
        CompositeArtifactRepositoryTest.assertTrue((String)"Asserting key is in composite repo", (boolean)compRepo.contains(descriptors[0]));
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        CompositeArtifactRepositoryTest.assertFalse((String)"Asserting key is not in composite repo", (boolean)compRepo.contains(descriptor));
    }

    public void testGetArtifactFromDescriptor() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        File child = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child.toURI());
        File destRepoLocation = new File(this.getTempFolder(), "CompositeArtifactRepositoryTest");
        CompositeArtifactRepositoryTest.delete(destRepoLocation);
        IArtifactRepository destinationRepo = null;
        try {
            destinationRepo = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(destRepoLocation.toURI(), "Test Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e1) {
            CompositeArtifactRepositoryTest.fail("Error creating destination", e1);
        }
        IQueryResult keys = compRepo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact keys", (!keys.isEmpty() ? 1 : 0) != 0);
        IArtifactKey key = (IArtifactKey)keys.iterator().next();
        IArtifactDescriptor[] descriptors = compRepo.getArtifactDescriptors(key);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact descriptors", (descriptors.length > 0 ? 1 : 0) != 0);
        ArtifactDescriptor newDescriptor = new ArtifactDescriptor(key);
        OrderedProperties properties = new OrderedProperties();
        properties.putAll(descriptors[0].getProperties());
        properties.remove("format");
        newDescriptor.addProperties((Map)properties);
        try (OutputStream repositoryStream = null;){
            repositoryStream = destinationRepo.getOutputStream((IArtifactDescriptor)newDescriptor);
            if (repositoryStream == null) {
                CompositeArtifactRepositoryTest.fail((String)"Error while obtaining OutputStream");
            }
            compRepo.getArtifact(descriptors[0], repositoryStream, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Error while obtaining OutputStream", e);
        }
        catch (IOException e) {
            CompositeArtifactRepositoryTest.fail("Error while downloading artifact", e);
        }
        CompositeArtifactRepositoryTest.assertTrue((String)"Expected Key is not in destination", (boolean)destinationRepo.contains(key));
        IArtifactRepository repo = null;
        try {
            repo = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(child.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repository for verification", e);
        }
        IArtifactDescriptor[] srcDescriptors = repo.getArtifactDescriptors(key);
        if (srcDescriptors == null) {
            CompositeArtifactRepositoryTest.fail((String)"Error finding descriptors for validation");
        }
        boolean found = false;
        int j = 0;
        while (j < srcDescriptors.length && !found) {
            if (srcDescriptors[j].equals(descriptors[0])) {
                File srcFile = ((SimpleArtifactRepository)repo).getArtifactFile(srcDescriptors[j]);
                File destFile = ((SimpleArtifactRepository)destinationRepo).getArtifactFile(descriptors[0]);
                if (srcFile == null || destFile == null) {
                    CompositeArtifactRepositoryTest.fail((String)"Unable to retreive files from repositories");
                }
                if (!srcFile.exists() || !destFile.exists()) {
                    CompositeArtifactRepositoryTest.fail((String)"File does not exist on disk");
                }
                CompositeArtifactRepositoryTest.assertTrue((srcFile.length() == destFile.length() ? 1 : 0) != 0);
                found = true;
            }
            ++j;
        }
        if (!found) {
            CompositeArtifactRepositoryTest.fail((String)"Matching descriptor was nto found in source");
        }
    }

    public void testGetArtifactsFromRequests() {
        CompositeArtifactRepository compRepo = this.createRepo(false);
        File child1 = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        File child2 = CompositeArtifactRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        File destRepoLocation = new File(this.getTempFolder(), "CompositeArtifactRepositoryTest");
        CompositeArtifactRepositoryTest.delete(destRepoLocation);
        IArtifactRepository destinationRepo = null;
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        try {
            repo1 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(child1.toURI(), null);
            repo2 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(child2.toURI(), null);
            destinationRepo = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(destRepoLocation.toURI(), "Test Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e1) {
            CompositeArtifactRepositoryTest.fail("Error retreiving repsoitories", e1);
        }
        IQueryResult keys1 = repo1.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        IArtifactKey key1 = (IArtifactKey)keys1.iterator().next();
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact keys", (!keys1.isEmpty() ? 1 : 0) != 0);
        IArtifactDescriptor[] descriptors1 = repo1.getArtifactDescriptors(key1);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact descriptors", (descriptors1.length > 0 ? 1 : 0) != 0);
        CompositeArtifactRepositoryTest.assertTrue((String)"Expected key not in composite repository", (boolean)compRepo.contains(descriptors1[0]));
        ArtifactDescriptor newDescriptor1 = new ArtifactDescriptor(key1);
        OrderedProperties properties1 = new OrderedProperties();
        properties1.putAll(descriptors1[0].getProperties());
        properties1.remove("format");
        newDescriptor1.addProperties((Map)properties1);
        IArtifactRequest request1 = ((ArtifactRepositoryManager)CompositeArtifactRepositoryTest.getArtifactRepositoryManager()).createMirrorRequest(key1, destinationRepo, null, null);
        IQueryResult keys2 = repo2.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        IArtifactKey key2 = (IArtifactKey)keys2.iterator().next();
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact keys", (!keys2.isEmpty() ? 1 : 0) != 0);
        IArtifactDescriptor[] descriptors2 = repo2.getArtifactDescriptors(key2);
        CompositeArtifactRepositoryTest.assertTrue((String)"Error retreaiving artifact descriptors", (descriptors2.length > 0 ? 1 : 0) != 0);
        CompositeArtifactRepositoryTest.assertTrue((String)"Expected key not in composite repository", (boolean)compRepo.contains(descriptors2[0]));
        ArtifactDescriptor newDescriptor2 = new ArtifactDescriptor(key2);
        OrderedProperties properties2 = new OrderedProperties();
        properties2.putAll(descriptors2[0].getProperties());
        properties2.remove("format");
        newDescriptor2.addProperties((Map)properties2);
        IArtifactRequest request2 = ((ArtifactRepositoryManager)CompositeArtifactRepositoryTest.getArtifactRepositoryManager()).createMirrorRequest(key2, destinationRepo, null, null);
        IArtifactRequest[] requests = new IArtifactRequest[]{request1, request2};
        try (OutputStream repositoryStream = null;){
            compRepo.getArtifacts(requests, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            CompositeArtifactRepositoryTest.fail("Error while downloading artifacts", e);
        }
        CompositeArtifactRepositoryTest.assertTrue((String)"Expected Key is not in destination", (boolean)destinationRepo.contains(key1));
        CompositeArtifactRepositoryTest.assertTrue((String)"Expected Key is not in destination", (boolean)destinationRepo.contains(key2));
        File repo1File = ((SimpleArtifactRepository)repo1).getArtifactFile(descriptors1[0]);
        File destFile1 = ((SimpleArtifactRepository)destinationRepo).getArtifactFile(descriptors1[0]);
        if (repo1File == null || destFile1 == null) {
            CompositeArtifactRepositoryTest.fail((String)"Unable to retreive files from repositories");
        }
        if (!repo1File.exists() || !destFile1.exists()) {
            CompositeArtifactRepositoryTest.fail((String)"File does not exist on disk");
        }
        CompositeArtifactRepositoryTest.assertTrue((repo1File.length() == destFile1.length() ? 1 : 0) != 0);
        File repo2File = ((SimpleArtifactRepository)repo2).getArtifactFile(descriptors2[0]);
        File destFile2 = ((SimpleArtifactRepository)destinationRepo).getArtifactFile(descriptors2[0]);
        if (repo2File == null || destFile2 == null) {
            CompositeArtifactRepositoryTest.fail((String)"Unable to retreive files from repositories");
        }
        if (!repo2File.exists() || !destFile2.exists()) {
            CompositeArtifactRepositoryTest.fail((String)"File does not exist on disk");
        }
        CompositeArtifactRepositoryTest.assertTrue((repo2File.length() == destFile2.length() ? 1 : 0) != 0);
    }

    public void testGetArtifactsWithErrorInChild() throws Exception {
        this.repositoryURI = CompositeArtifactRepositoryTest.getTestData("1", "/testData/artifactRepo/composite/errorInChild").toURI();
        IArtifactRepository repo = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(this.repositoryURI, null);
        IArtifactRequest[] requests = new IArtifactRequest[]{new ArtifactRequest((IArtifactKey)new ArtifactKey("osgi.bundle", "plugin", Version.parseVersion((String)"1.0.0")), null){

            public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
                this.setResult(sourceRepository.getArtifact(sourceRepository.getArtifactDescriptors(this.getArtifactKey())[0], (OutputStream)new ByteArrayOutputStream(), monitor));
            }
        }};
        IStatus status = repo.getArtifacts(requests, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.errorStatus()));
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"while reading artifacts from child repositories"))));
        String brokenChildURI = String.valueOf(this.repositoryURI.toString()) + "child";
        Assert.assertThat(Arrays.asList(status.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)brokenChildURI))));
    }

    public void testLoadingRepositoryRemote() {
        CompositeArtifactRepository compRepo;
        block7: {
            File knownGoodRepoLocation = CompositeArtifactRepositoryTest.getTestData("0.1", "/testData/artifactRepo/composite/good.remote");
            compRepo = null;
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream()));
                    compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(knownGoodRepoLocation.toURI(), null);
                }
                catch (ProvisionException e) {
                    CompositeArtifactRepositoryTest.fail("0.99", e);
                    System.setOut(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        List children = compRepo.getChildren();
        try {
            URI child1 = URIUtil.fromString((String)"http://www.eclipse.org/foo");
            CompositeArtifactRepositoryTest.assertTrue((String)"1.0", (boolean)children.contains(child1));
            URI child2 = URIUtil.fromString((String)"http://www.eclipse.org/bar");
            CompositeArtifactRepositoryTest.assertTrue((String)"1.1", (boolean)children.contains(child2));
            CompositeArtifactRepositoryTest.assertEquals((String)"1.2", (int)2, (int)children.size());
        }
        catch (URISyntaxException e) {
            CompositeArtifactRepositoryTest.fail("1.99", e);
        }
        CompositeArtifactRepositoryTest.assertEquals((String)"2.0", (String)"artifact name", (String)compRepo.getName());
        Map properties = compRepo.getProperties();
        CompositeArtifactRepositoryTest.assertEquals((String)"2.1", (int)3, (int)properties.size());
        String timestamp = (String)properties.get("p2.timestamp");
        CompositeArtifactRepositoryTest.assertNotNull((String)"2.2", (Object)timestamp);
        CompositeArtifactRepositoryTest.assertEquals((String)"2.3", (String)"1234", (String)timestamp);
        String compressed = (String)properties.get("p2.compressed");
        CompositeArtifactRepositoryTest.assertNotNull((String)"2.4", (Object)compressed);
        CompositeArtifactRepositoryTest.assertFalse((String)"2.4", (boolean)Boolean.parseBoolean(compressed));
    }

    public void testLoadingRepositoryLocal() {
        File knownGoodRepoLocation = CompositeArtifactRepositoryTest.getTestData("0.1", "/testData/artifactRepo/composite/good.local");
        CompositeArtifactRepository compRepo = null;
        try {
            compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(knownGoodRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("0.99", e);
        }
        List children = compRepo.getChildren();
        CompositeArtifactRepositoryTest.assertTrue((String)"1.0", (boolean)children.contains(URIUtil.append((URI)compRepo.getLocation(), (String)"one")));
        CompositeArtifactRepositoryTest.assertTrue((String)"1.1", (boolean)children.contains(URIUtil.append((URI)compRepo.getLocation(), (String)"two")));
        CompositeArtifactRepositoryTest.assertEquals((String)"1.2", (int)2, (int)children.size());
        CompositeArtifactRepositoryTest.assertEquals((String)"2.0", (String)"artifact name", (String)compRepo.getName());
        Map properties = compRepo.getProperties();
        CompositeArtifactRepositoryTest.assertEquals((String)"2.1", (int)2, (int)properties.size());
        String timestamp = (String)properties.get("p2.timestamp");
        CompositeArtifactRepositoryTest.assertNotNull((String)"2.2", (Object)timestamp);
        CompositeArtifactRepositoryTest.assertEquals((String)"2.3", (String)"1234", (String)timestamp);
        String compressed = (String)properties.get("p2.compressed");
        CompositeArtifactRepositoryTest.assertNotNull((String)"2.4", (Object)compressed);
        CompositeArtifactRepositoryTest.assertFalse((String)"2.5", (boolean)Boolean.parseBoolean(compressed));
    }

    public void testCompressedPersistence() {
        this.persistenceTest(true);
    }

    public void testUncompressedPersistence() {
        this.persistenceTest(false);
    }

    public void testSyntaxErrorWhileParsing() {
        File badCompositeArtifacts = CompositeArtifactRepositoryTest.getTestData("1", "/testData/artifactRepo/composite/Bad/syntaxError");
        PrintStream err = System.err;
        StringBuffer buffer = new StringBuffer();
        try {
            try {
                System.setErr(new PrintStream(new StringBufferStream(buffer)));
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(badCompositeArtifacts.toURI(), null);
                CompositeArtifactRepositoryTest.fail((String)"Expected ProvisionException has not been thrown");
            }
            catch (ProvisionException provisionException) {
                CompositeArtifactRepositoryTest.assertTrue((boolean)buffer.toString().contains("The element type \"children\" must be terminated by the matching end-tag \"</children>\""));
                System.setErr(err);
            }
        }
        finally {
            System.setErr(err);
        }
    }

    public void testMissingRequireattributeWhileParsing() {
        CompositeArtifactRepository compRepo;
        block5: {
            File badCompositeArtifacts = CompositeArtifactRepositoryTest.getTestData("1", "/testData/artifactRepo/composite/Bad/missingRequiredAttribute");
            compRepo = null;
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream()));
                    compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(badCompositeArtifacts.toURI(), null);
                }
                catch (ProvisionException e) {
                    CompositeArtifactRepositoryTest.fail("Error loading repository", e);
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        CompositeArtifactRepositoryTest.assertEquals((String)"Repository should only have 1 child", (int)1, (int)compRepo.getChildren().size());
    }

    public void testValidate() throws Exception {
        ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        File artifact1 = CompositeArtifactRepositoryTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/artifacts.xml");
        File artifact2 = CompositeArtifactRepositoryTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/artifacts.xml");
        IArtifactDescriptor descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
        IArtifactDescriptor descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact2);
        CompositeArtifactRepositoryTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
        Assert.assertNotEquals((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
        File repo1Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File repo2Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File compRepoLocation = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        CompositeArtifactRepository compRepo = null;
        try {
            repo1 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo1.addDescriptor(descriptor1);
            repo2 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo2.addDescriptor(descriptor2);
            compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(compRepoLocation.toURI(), "Composite Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo1Location.toURI());
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo2Location.toURI());
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Error creating repositories", e);
        }
        compRepo.addChild(repo1Location.toURI());
        compRepo.addChild(repo2Location.toURI());
        ArtifactRepositoryValidator validator = new ArtifactRepositoryValidator(MD5ArtifactComparator.MD5_COMPARATOR_ID);
        CompositeArtifactRepositoryTest.assertFalse((String)"Running verify on invalid repository", (boolean)validator.validateComposite(compRepo).isOK());
    }

    public void testAddChildWithValidate() throws ProvisionException {
        ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        File artifact1 = CompositeArtifactRepositoryTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/artifacts.xml");
        File artifact2 = CompositeArtifactRepositoryTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/artifacts.xml");
        IArtifactDescriptor descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
        IArtifactDescriptor descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact2);
        CompositeArtifactRepositoryTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
        Assert.assertNotEquals((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
        File repo1Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File repo2Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File compRepoLocation = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        CompositeArtifactRepository compRepo = null;
        try {
            repo1 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo1.addDescriptor(descriptor1);
            repo2 = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo2.addDescriptor(descriptor2);
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo1Location.toURI());
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo2Location.toURI());
            compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(compRepoLocation.toURI(), "Composite Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Error creating repositories", e);
        }
        ArtifactRepositoryValidator validator = new ArtifactRepositoryValidator(MD5ArtifactComparator.MD5_COMPARATOR_ID);
        CompositeArtifactRepositoryTest.assertTrue((boolean)validator.validateComposite(compRepo, repo1).isOK());
        compRepo.addChild(repo1Location.toURI());
        CompositeArtifactRepositoryTest.assertFalse((boolean)validator.validateComposite(compRepo, repo2).isOK());
    }

    public void testEnabledAndSystemValues() {
        File repo1Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File repo2Location = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        File compRepoLocation = this.getTestFolder(CompositeArtifactRepositoryTest.getUniqueString());
        CompositeArtifactRepository compRepo = null;
        try {
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo2Location.toURI());
            compRepo = (CompositeArtifactRepository)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(compRepoLocation.toURI(), "Composite Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Error creating repositories", e);
        }
        compRepo.addChild(repo1Location.toURI());
        compRepo.addChild(repo2Location.toURI());
        compRepo.getArtifactDescriptors((IArtifactKey)new ArtifactKey("", "", Version.emptyVersion));
        CompositeArtifactRepositoryTest.assertTrue((String)"Ensuring previously loaded repo is enabled", (boolean)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().isEnabled(repo1Location.toURI()));
        String repo1System = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().getRepositoryProperty(repo1Location.toURI(), "p2.system");
        CompositeArtifactRepositoryTest.assertFalse((String)"Ensuring previously loaded repo is not system", (boolean)(repo1System != null ? repo1System.equals(Boolean.toString(true)) : true));
        CompositeArtifactRepositoryTest.assertFalse((String)"Ensuring not previously loaded repo is not enabled", (boolean)CompositeArtifactRepositoryTest.getArtifactRepositoryManager().isEnabled(repo2Location.toURI()));
        String repo2System = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().getRepositoryProperty(repo2Location.toURI(), "p2.system");
        CompositeArtifactRepositoryTest.assertTrue((String)"Ensuring not previously loaded repo is system", (boolean)(repo2System != null ? repo2System.equals(Boolean.toString(true)) : false));
    }

    private void persistenceTest(boolean compressed) {
        CompositeArtifactRepository compRepo = this.createRepo(compressed);
        File child1 = CompositeArtifactRepositoryTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        compRepo.addChild(child1.toURI());
        File child2 = CompositeArtifactRepositoryTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        compRepo.addChild(child2.toURI());
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        artifactRepositoryManager.removeRepository(this.repositoryURI);
        compRepo = null;
        IArtifactRepository repo = null;
        try {
            repo = artifactRepositoryManager.loadRepository(this.repositoryURI, null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Could not load repository after removal", e);
        }
        CompositeArtifactRepositoryTest.assertTrue((String)"loaded repository was of type CompositeArtifactRepository", (boolean)(repo instanceof CompositeArtifactRepository));
        compRepo = (CompositeArtifactRepository)repo;
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        try {
            repo1 = artifactRepositoryManager.loadRepository(child1.toURI(), null);
            repo2 = artifactRepositoryManager.loadRepository(child2.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.fail("Unable to load repositories for verification", e);
        }
        CompositeArtifactRepositoryTest.assertContains("Assert child1's content is in composite repo", repo1, (IArtifactRepository)compRepo);
        CompositeArtifactRepositoryTest.assertContains("Assert child2's content is in composite repo", repo2, (IArtifactRepository)compRepo);
        CompositeArtifactRepositoryTest.assertEquals((String)"Assert Correct Number of Keys", (int)(this.getArtifactKeyCount(repo1) + this.getArtifactKeyCount(repo2)), (int)this.getArtifactKeyCount((IArtifactRepository)compRepo));
    }

    private CompositeArtifactRepository createRepo(boolean compressed) {
        IArtifactRepositoryManager artifactRepositoryManager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        this.repositoryFile = new File(this.getTempFolder(), "CompositeArtifactRepositoryTest");
        CompositeArtifactRepositoryTest.delete(this.repositoryFile);
        this.repositoryURI = this.repositoryFile.toURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", compressed ? "true" : "false");
        IArtifactRepository repo = null;
        try {
            repo = artifactRepositoryManager.createRepository(this.repositoryURI, "artifact name", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
        }
        catch (ProvisionException provisionException) {
            CompositeArtifactRepositoryTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeArtifactRepository)) {
            CompositeArtifactRepositoryTest.fail((String)"Repository is not a CompositeArtifactRepository");
        }
        return (CompositeArtifactRepository)repo;
    }

    public void testNonLocalRepo() {
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                URI location = new URI("memory:/in/memory");
                URI childOne = new URI("memory:/in/memory/one");
                URI childTwo = new URI("memory:/in/memory/two");
                URI childThree = new URI("memory:/in/memory/three");
                CompositeArtifactRepository repository = this.createRepository(location, "in memory test");
                repository.addChild(childOne);
                repository.addChild(childTwo);
                repository.addChild(childThree);
                CompositeArtifactRepositoryTest.assertEquals((String)"1.0", (int)3, (int)repository.getChildren().size());
                repository.removeChild(childTwo);
                CompositeArtifactRepositoryTest.assertEquals((String)"1.1", (int)2, (int)repository.getChildren().size());
                repository.addChild(childOne);
                CompositeArtifactRepositoryTest.assertEquals((String)"1.2", (int)2, (int)repository.getChildren().size());
                repository.addChild(new URI("one"));
                CompositeArtifactRepositoryTest.assertEquals((String)"1.3", (int)2, (int)repository.getChildren().size());
            }
            catch (URISyntaxException e) {
                CompositeArtifactRepositoryTest.fail("99.0", e);
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    public void testRelativeChildren() {
        File one = CompositeArtifactRepositoryTest.getTestData("0.0", "testData/testRepos/simple.1");
        File two = CompositeArtifactRepositoryTest.getTestData("0.1", "testData/testRepos/simple.2");
        File temp = this.getTempFolder();
        CompositeArtifactRepositoryTest.copy("0.2", one, new File(temp, "one"));
        CompositeArtifactRepositoryTest.copy("0.3", two, new File(temp, "two"));
        URI location = new File(temp, "comp").toURI();
        CompositeArtifactRepository repository = this.createRepository(location, "test");
        try {
            repository.addChild(new URI("../one"));
            repository.addChild(new URI("../two"));
        }
        catch (URISyntaxException e) {
            CompositeArtifactRepositoryTest.fail("1.99", e);
        }
        List children = repository.getChildren();
        CompositeArtifactRepositoryTest.assertEquals((String)"2.0", (int)2, (int)children.size());
        CompositeArtifactRepositoryTest.assertEquals((String)"2.1", (int)2, (int)this.getArtifactKeyCount((IArtifactRepository)repository));
        CompositeRepositoryState state = repository.toState();
        URI[] childURIs = state.getChildren();
        CompositeArtifactRepositoryTest.assertNotNull((String)"3.0", (Object)childURIs);
        CompositeArtifactRepositoryTest.assertEquals((String)"3.1", (int)2, (int)childURIs.length);
        CompositeArtifactRepositoryTest.assertFalse((String)"3.2", (boolean)childURIs[0].isAbsolute());
        CompositeArtifactRepositoryTest.assertFalse((String)"3.3", (boolean)childURIs[1].isAbsolute());
        CompositeArtifactRepositoryTest.delete(temp);
    }

    public void testRelativeRemoveChild() {
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                URI location = new URI("memory:/in/memory");
                URI one = new URI("one");
                URI two = new URI("two");
                CompositeArtifactRepository repository = this.createRepository(location, "in memory test");
                repository.addChild(one);
                repository.addChild(two);
                List children = repository.getChildren();
                CompositeArtifactRepositoryTest.assertEquals((String)"1.0", (int)2, (int)children.size());
                repository.removeChild((URI)children.iterator().next());
                CompositeArtifactRepositoryTest.assertEquals((String)"1.1", (int)1, (int)repository.getChildren().size());
                repository.removeChild(two);
                CompositeArtifactRepositoryTest.assertEquals((String)"1.2", (int)0, (int)repository.getChildren().size());
            }
            catch (URISyntaxException e) {
                CompositeArtifactRepositoryTest.fail("99.0", e);
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    public void testRetryRequest() {
        block17: {
            URI childLocation = CompositeArtifactRepositoryTest.getTestData("Loading test data", "testData/artifactRepo/missingArtifact").toURI();
            File destination = null;
            OutputStream out = null;
            try {
                try {
                    destination = new File(this.getTempFolder(), CompositeArtifactRepositoryTest.getUniqueString());
                    out = new FileOutputStream(destination);
                    CompositeArtifactRepository repository = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                    IArtifactRepository childOne = CompositeArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(childLocation, null);
                    TestArtifactRepository childTwo = new TestArtifactRepository(CompositeArtifactRepositoryTest.getAgent(), new URI("memory:/in/memory/two"));
                    CompositeArtifactRepositoryTest.assertTrue((boolean)childTwo.addToRepositoryManager());
                    repository.addChild(childOne.getLocation());
                    repository.addChild(childTwo.getLocation());
                    ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "missingSize.asdf", Version.create((String)"1.5.1.v200803061910")));
                    IStatus status = repository.getArtifact((IArtifactDescriptor)descriptor, out, (IProgressMonitor)new NullProgressMonitor());
                    CompositeArtifactRepositoryTest.assertFalse((boolean)status.isOK());
                    CompositeArtifactRepositoryTest.assertEquals((int)13, (int)status.getCode());
                    status = repository.getArtifact((IArtifactDescriptor)descriptor, out, (IProgressMonitor)new NullProgressMonitor());
                    CompositeArtifactRepositoryTest.assertFalse((boolean)status.isOK());
                    CompositeArtifactRepositoryTest.assertFalse((String)"Requesting retry with no available children", (13 == status.getCode() ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    CompositeArtifactRepositoryTest.fail("Exception occurred", e);
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childLocation);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (destination != null) {
                        CompositeArtifactRepositoryTest.delete(destination.getParentFile());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childLocation);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destination != null) {
                    CompositeArtifactRepositoryTest.delete(destination.getParentFile());
                }
                throw throwable;
            }
            CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childLocation);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                CompositeArtifactRepositoryTest.delete(destination.getParentFile());
            }
        }
    }

    public void testChildRetryRequest() {
        IArtifactRepository destination = null;
        class BadMirrorSite
        extends TestArtifactRepository {
            int downloadAttempts;

            public BadMirrorSite(URI location) {
                super(CompositeArtifactRepositoryTest.getAgent(), location);
                this.downloadAttempts = 0;
                this.addToRepositoryManager();
            }

            @Override
            public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream out, IProgressMonitor monitor) {
                if (++this.downloadAttempts == 1) {
                    return new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 13, new IStatus[]{new Status(4, "Test", "Test - Download interrupted")}, "Retry another mirror", null);
                }
                return Status.OK_STATUS;
            }

            @Override
            public boolean contains(IArtifactDescriptor desc) {
                return true;
            }

            @Override
            public boolean contains(IArtifactKey desc) {
                return true;
            }
        }
        BadMirrorSite child = null;
        CompositeArtifactRepository source = null;
        ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "missingSize.asdf", Version.create((String)"1.5.1.v200803061910")));
        try {
            try {
                destination = super.createArtifactRepository(this.getTempFolder().toURI(), null);
                child = new BadMirrorSite(new URI("memory:/in/memory/child"));
                source = this.createRepository(new URI("memory:/in/memory/source"), "in memory test");
                source.addChild(child.getLocation());
                MirrorRequest request = new MirrorRequest(descriptor.getArtifactKey(), destination, null, null, (Transport)CompositeArtifactRepositoryTest.getAgent().getService(Transport.SERVICE_NAME));
                request.perform((IArtifactRepository)source, (IProgressMonitor)new NullProgressMonitor());
                IStatus status = request.getResult();
                CompositeArtifactRepositoryTest.assertTrue((boolean)status.isOK());
                CompositeArtifactRepositoryTest.assertEquals((int)2, (int)child.downloadAttempts);
            }
            catch (Exception e) {
                CompositeArtifactRepositoryTest.fail("Exception", e);
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (child != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(child.getLocation());
                }
                if (destination != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(destination.getLocation());
                    CompositeArtifactRepositoryTest.delete(new File(destination.getLocation()));
                }
            }
        }
        finally {
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (child != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(child.getLocation());
            }
            if (destination != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(destination.getLocation());
                CompositeArtifactRepositoryTest.delete(new File(destination.getLocation()));
            }
        }
    }

    protected CompositeArtifactRepository createRepository(URI location, String name) {
        CompositeArtifactRepositoryFactory factory = new CompositeArtifactRepositoryFactory();
        factory.setAgent(CompositeArtifactRepositoryTest.getAgent());
        return (CompositeArtifactRepository)factory.create(location, name, CompositeArtifactRepository.REPOSITORY_TYPE, null);
    }

    public void testFailedDownload() {
        block26: {
            byte[] contents = "Hello".getBytes();
            class BadSite
            extends TestArtifactRepository {
                File location;
                private final /* synthetic */ byte[] val$contents;

                public BadSite(URI location, byte[] byArray) {
                    this.val$contents = byArray;
                    super(CompositeArtifactRepositoryTest.getAgent(), location);
                    this.location = new File(CompositeArtifactRepositoryTest.this.getTempFolder(), CompositeArtifactRepositoryTest.getUniqueString());
                }

                @Override
                public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream out, IProgressMonitor monitor) {
                    super.getArtifact(descriptor, out, monitor);
                    return new Status(4, "Test", "Test - Download interrupted");
                }

                @Override
                public void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
                    super.addDescriptor(descriptor, monitor);
                    super.addArtifact(descriptor.getArtifactKey(), this.val$contents);
                }

                @Override
                public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
                    try {
                        return new FileOutputStream(this.location);
                    }
                    catch (Exception e) {
                        CompositeArtifactRepositoryTest.fail("Failed to open stream", e);
                        return null;
                    }
                }
            }
            BadSite childOne = null;
            BadSite dest = null;
            CompositeArtifactRepository source = null;
            File destination = null;
            OutputStream out = null;
            try {
                try {
                    destination = new File(this.getTempFolder(), CompositeArtifactRepositoryTest.getUniqueString());
                    out = new FileOutputStream(destination);
                    source = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                    ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "missingSize.asdf", Version.create((String)"1.5.1.v200803061910")));
                    childOne = new BadSite(new URI("memory:/in/memory/one"), contents);
                    childOne.addDescriptor((IArtifactDescriptor)descriptor);
                    childOne.addToRepositoryManager();
                    source.addChild(childOne.getLocation());
                    TestArtifactRepository childTwo = new TestArtifactRepository(CompositeArtifactRepositoryTest.getAgent(), new URI("memory:/in/memory/two"));
                    childTwo.addDescriptor((IArtifactDescriptor)descriptor);
                    childTwo.addArtifact(descriptor.getArtifactKey(), contents);
                    childTwo.addToRepositoryManager();
                    source.addChild(childTwo.getLocation());
                    dest = new BadSite(new URI("memory:/in/memory/dest"), contents);
                    MirrorRequest request = new MirrorRequest(descriptor.getArtifactKey(), (IArtifactRepository)dest, null, null, this.getTransport());
                    request.perform((IArtifactRepository)source, (IProgressMonitor)new NullProgressMonitor());
                    IStatus status = request.getResult();
                    CompositeArtifactRepositoryTest.assertTrue((boolean)status.isOK());
                    CompositeArtifactRepositoryTest.assertEquals((long)contents.length, (long)dest.location.length());
                }
                catch (Exception e) {
                    CompositeArtifactRepositoryTest.fail("Exception occurred", e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (source != null) {
                        CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                    }
                    if (childOne != null) {
                        CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                    }
                    if (dest != null) {
                        CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(dest.getLocation());
                        CompositeArtifactRepositoryTest.delete(dest.location.getParentFile());
                    }
                    if (destination != null) {
                        CompositeArtifactRepositoryTest.delete(destination.getParentFile());
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (childOne != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                }
                if (dest != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(dest.getLocation());
                    CompositeArtifactRepositoryTest.delete(dest.location.getParentFile());
                }
                if (destination != null) {
                    CompositeArtifactRepositoryTest.delete(destination.getParentFile());
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (childOne != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
            }
            if (dest != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(dest.getLocation());
                CompositeArtifactRepositoryTest.delete(dest.location.getParentFile());
            }
            if (destination != null) {
                CompositeArtifactRepositoryTest.delete(destination.getParentFile());
            }
        }
    }

    public void testContainsDescriptorBadChild() {
        CompositeArtifactRepository source = null;
        IArtifactRepository childOne = null;
        IArtifactRepository childTwo = null;
        try {
            try {
                ArtifactDescriptor desc = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi", "a", Version.create((String)"1.0.0")));
                source = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                childOne = this.createChild();
                source.addChild(childOne.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"TestSetup failed", (boolean)source.contains((IArtifactDescriptor)desc));
                this.markBad(source, childOne);
                CompositeArtifactRepositoryTest.assertFalse((String)"Composite repo contains descriptor despite child marked bad", (boolean)source.contains((IArtifactDescriptor)desc));
                childTwo = this.createChild();
                source.addChild(childTwo.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo should contain the descriptor", (boolean)source.contains((IArtifactDescriptor)desc));
            }
            catch (Exception e) {
                CompositeArtifactRepositoryTest.fail(e.getMessage(), e);
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (childOne != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                }
                if (childTwo != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
                }
            }
        }
        finally {
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (childOne != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
            }
            if (childTwo != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
            }
        }
    }

    public void testContainsKeyBadChild() {
        CompositeArtifactRepository source = null;
        IArtifactRepository childOne = null;
        IArtifactRepository childTwo = null;
        try {
            try {
                ArtifactKey desc = new ArtifactKey("osgi", "a", Version.create((String)"1.0.0"));
                source = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                childOne = this.createChild();
                source.addChild(childOne.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"TestSetup failed", (boolean)source.contains((IArtifactKey)desc));
                this.markBad(source, childOne);
                CompositeArtifactRepositoryTest.assertFalse((String)"Composite repo contains descriptor despite child marked bad", (boolean)source.contains((IArtifactKey)desc));
                childTwo = this.createChild();
                source.addChild(childTwo.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo should contain the descriptor", (boolean)source.contains((IArtifactKey)desc));
            }
            catch (Exception e) {
                CompositeArtifactRepositoryTest.fail(e.getMessage(), e);
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (childOne != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                }
                if (childTwo != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
                }
            }
        }
        finally {
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (childOne != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
            }
            if (childTwo != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
            }
        }
    }

    public void testGetArtifactKeysBadChild() {
        CompositeArtifactRepository source = null;
        IArtifactRepository childOne = null;
        IArtifactRepository childTwo = null;
        try {
            try {
                source = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                ArtifactKey key = new ArtifactKey("classifier", "name", Version.create((String)"1.0.0"));
                childOne = this.createChild();
                ((TestArtifactRepository)childOne).addArtifact((IArtifactKey)key, new byte[0]);
                source.addChild(childOne.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo does not contain key", (boolean)source.contains((IArtifactKey)key));
                this.markBad(source, childOne);
                CompositeArtifactRepositoryTest.assertFalse((String)"Composite repo contains key but child is marked bad", (boolean)source.contains((IArtifactKey)key));
                childTwo = this.createChild();
                ((TestArtifactRepository)childTwo).addArtifact((IArtifactKey)key, new byte[0]);
                source.addChild(childTwo.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo does not contain key, but it is available", (boolean)source.contains((IArtifactKey)key));
            }
            catch (Exception e) {
                CompositeArtifactRepositoryTest.fail(e.getMessage(), e);
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (childOne != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                }
                if (childTwo != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
                }
            }
        }
        finally {
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (childOne != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
            }
            if (childTwo != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
            }
        }
    }

    public void testGetArtifactDescriptorsBadChild() {
        CompositeArtifactRepository source = null;
        IArtifactRepository childOne = null;
        IArtifactRepository childTwo = null;
        try {
            try {
                source = this.createRepository(new URI("memory:/in/memory"), "in memory test");
                ArtifactKey key = new ArtifactKey("classifier", "name", Version.create((String)"1.0.0"));
                ArtifactDescriptor desc = new ArtifactDescriptor((IArtifactKey)key);
                childOne = this.createChild();
                childOne.addDescriptor((IArtifactDescriptor)desc);
                ((TestArtifactRepository)childOne).addArtifact((IArtifactKey)key, new byte[0]);
                source.addChild(childOne.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo does not contain descriptor", (boolean)Arrays.asList(source.getArtifactDescriptors((IArtifactKey)key)).contains(desc));
                this.markBad(source, childOne);
                CompositeArtifactRepositoryTest.assertFalse((String)"Composite repo contains descriptor but child is marked bad", (boolean)Arrays.asList(source.getArtifactDescriptors((IArtifactKey)key)).contains(desc));
                childTwo = this.createChild();
                childOne.addDescriptor((IArtifactDescriptor)desc);
                ((TestArtifactRepository)childTwo).addArtifact((IArtifactKey)key, new byte[0]);
                source.addChild(childTwo.getLocation());
                CompositeArtifactRepositoryTest.assertTrue((String)"Composite repo does not contain descriptor, but it is available", (boolean)Arrays.asList(source.getArtifactDescriptors((IArtifactKey)key)).contains(desc));
            }
            catch (Exception e) {
                CompositeArtifactRepositoryTest.fail(e.getMessage(), e);
                if (source != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
                }
                if (childOne != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
                }
                if (childTwo != null) {
                    CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
                }
            }
        }
        finally {
            if (source != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(source.getLocation());
            }
            if (childOne != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childOne.getLocation());
            }
            if (childTwo != null) {
                CompositeArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(childTwo.getLocation());
            }
        }
    }

    protected void markBad(CompositeArtifactRepository parent, IArtifactRepository child) {
        try {
            Field field = CompositeArtifactRepository.class.getDeclaredField("loadedRepos");
            field.setAccessible(true);
            Class<?>[] classes = CompositeArtifactRepository.class.getDeclaredClasses();
            Class<?> childInfo = null;
            int i = 0;
            while (i < classes.length && childInfo == null) {
                if (classes[i].getName().equals("org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository$ChildInfo")) {
                    childInfo = classes[i];
                }
                ++i;
            }
            CompositeArtifactRepositoryTest.assertTrue((String)"Unable to locate inner class ChildInfo", (childInfo != null ? 1 : 0) != 0);
            Field repo = childInfo.getDeclaredField("repo");
            repo.setAccessible(true);
            Field good = childInfo.getDeclaredField("good");
            good.setAccessible(true);
            List list = (List)field.get(parent);
            for (Object obj : list) {
                if (!child.equals(repo.get(obj))) continue;
                good.set(obj, false);
                return;
            }
            CompositeArtifactRepositoryTest.fail((String)("Unable to mark as bad:" + child));
        }
        catch (Exception e) {
            CompositeArtifactRepositoryTest.fail("Test setup failed:" + e.getMessage(), e);
        }
    }

    protected IArtifactRepository createChild() {
        try {
            TestArtifactRepository repo = new TestArtifactRepository(CompositeArtifactRepositoryTest.getAgent(), new URI("memory:/in/memory/" + this.childCount++)){

                @Override
                public boolean contains(IArtifactDescriptor desc) {
                    return true;
                }

                @Override
                public boolean contains(IArtifactKey desc) {
                    return true;
                }
            };
            repo.addToRepositoryManager();
            return repo;
        }
        catch (URISyntaxException e) {
            CompositeArtifactRepositoryTest.fail("Failed creating child repo", e);
            return null;
        }
    }

    public void testFailingChildFailsCompleteRepository() throws ProvisionException, OperationCanceledException {
        boolean exception = false;
        IArtifactRepository repo = null;
        IArtifactRepositoryManager manager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        File repoFile = CompositeArtifactRepositoryTest.getTestData("Atomic composite with missing child", "/testData/artifactRepo/composite/missingChild/atomicLoading");
        URI correctChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"one");
        URI repoURI = repoFile.getAbsoluteFile().toURI();
        File alreadyLoadedChildFile = CompositeArtifactRepositoryTest.getTestData("Atomic composite with missing child", "/testData/artifactRepo/composite/missingChild/atomicLoading/three");
        IArtifactRepository alreadyLoadedChild = manager.loadRepository(alreadyLoadedChildFile.toURI(), null);
        CompositeArtifactRepositoryTest.assertNotNull((Object)alreadyLoadedChild);
        URI previouslyAddedChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"three");
        CompositeArtifactRepositoryTest.assertFalse((String)"Child one should not be available in repo manager", (boolean)manager.contains(correctChildURI));
        try {
            repo = manager.loadRepository(repoFile.toURI(), null);
        }
        catch (ProvisionException e) {
            CompositeArtifactRepositoryTest.assertFalse((String)"Exception message should not contain the location of failing child", (boolean)e.getMessage().contains(URIUtil.append((URI)repoURI, (String)"two").toString()));
            CompositeArtifactRepositoryTest.assertTrue((String)("Exception message should contain the composite repository location " + repoURI + ": " + e.getMessage()), (boolean)e.getMessage().contains(repoURI.toString()));
            exception = true;
        }
        CompositeArtifactRepositoryTest.assertNull((Object)repo);
        CompositeArtifactRepositoryTest.assertTrue((String)"an exception should have been reported", (boolean)exception);
        CompositeArtifactRepositoryTest.assertFalse((String)"Successfully loaded child should be removed when composite loading mode is set to atomic", (boolean)manager.contains(correctChildURI));
        CompositeArtifactRepositoryTest.assertTrue((String)"Periously loaded child should remain in repo manager", (boolean)manager.contains(previouslyAddedChildURI));
    }

    public void testFailingChildLoadsCompleteRepository() {
        boolean exception = false;
        IArtifactRepository repo = null;
        IArtifactRepositoryManager manager = CompositeArtifactRepositoryTest.getArtifactRepositoryManager();
        File repoFile = CompositeArtifactRepositoryTest.getTestData("Composite with missing child", "/testData/artifactRepo/composite/missingChild/nonAtomicLoading");
        URI correctChildURI = URIUtil.append((URI)repoFile.toURI(), (String)"one");
        CompositeArtifactRepositoryTest.assertFalse((String)"Child should not be available in repo manager", (boolean)manager.contains(correctChildURI));
        try {
            repo = manager.loadRepository(repoFile.toURI(), null);
        }
        catch (ProvisionException provisionException) {
            exception = true;
        }
        CompositeArtifactRepositoryTest.assertNotNull((Object)repo);
        CompositeArtifactRepositoryTest.assertFalse((String)"an exception should have been reported", (boolean)exception);
        CompositeArtifactRepositoryTest.assertTrue((String)"Successfully loaded child should be available in repo manager", (boolean)manager.contains(URIUtil.append((URI)repo.getLocation(), (String)"one")));
    }
}

