/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class CorruptedJar
extends AbstractProvisioningTest {
    private static final String testDataLocation = "testData/artifactRepo/corruptedJarRepo";
    IArtifactRepository source = null;
    IArtifactRepository target = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IArtifactRepositoryManager mgr = CorruptedJar.getArtifactRepositoryManager();
        try {
            this.source = mgr.loadRepository(CorruptedJar.getTestData("CorruptedJar repo", testDataLocation).toURI(), null);
        }
        catch (Exception e) {
            CorruptedJar.fail("1.0", e);
        }
        try {
            this.target = mgr.createRepository(this.getTestFolder("CorruptedJarTarget").toURI(), "CorruptedJar target repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (Exception e) {
            CorruptedJar.fail("2.0", e);
        }
    }

    public void testDownloadCorruptedJar() {
        ProvisioningContext ctx = new ProvisioningContext(CorruptedJar.getAgent());
        ctx.setArtifactRepositories(new URI[]{CorruptedJar.getTestData("CorruptedJar repo", testDataLocation).toURI()});
        DownloadManager mgr = new DownloadManager(ctx, CorruptedJar.getAgent());
        IArtifactKey key = (IArtifactKey)this.source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).iterator().next();
        mgr.add((IArtifactRequest)new MirrorRequest(key, this.target, null, null, this.getTransport()));
        IStatus s = mgr.start((IProgressMonitor)new NullProgressMonitor());
        CorruptedJar.assertNotOK(s);
    }
}

