/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class LocationTest
extends AbstractProvisioningTest {
    private static final String testDataLocation = "testData/artifactRepo/packedSiblingsWithUUID";
    private File targetLocation;
    private IArtifactRepository targetRepository;
    private IArtifactRepository sourceRepository;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.targetLocation = File.createTempFile("target", ".repo");
        this.targetLocation.delete();
        this.targetLocation.mkdirs();
        this.targetRepository = new SimpleArtifactRepository(LocationTest.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
        IArtifactRepositoryManager mgr = LocationTest.getArtifactRepositoryManager();
        this.sourceRepository = mgr.loadRepository(LocationTest.getTestData("EmptyJar repo", testDataLocation).toURI(), null);
    }

    @Override
    protected void tearDown() throws Exception {
        LocationTest.getArtifactRepositoryManager().removeRepository(this.targetLocation.toURI());
        LocationTest.getArtifactRepositoryManager().removeRepository(this.sourceRepository.getLocation());
        AbstractProvisioningTest.delete(this.targetLocation);
        super.tearDown();
    }

    public void testLocation() throws Exception {
        ArtifactKey key = new ArtifactKey("osgi.bundle", "org.springframework.ide.eclipse", Version.parseVersion((String)"2.3.2.201003220227-RELEASE"));
        LocationTest.assertTrue((boolean)this.sourceRepository.contains((IArtifactKey)key));
        MirrorRequest req = new MirrorRequest((IArtifactKey)key, this.targetRepository, null, null, this.getTransport());
        req.perform(this.sourceRepository, (IProgressMonitor)new NullProgressMonitor());
        IStatus status = req.getResult();
        LocationTest.assertTrue((String)status.getMessage(), (boolean)status.isOK());
    }
}

