/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository.processing;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;

public class Counter
extends ProcessingStep {
    protected long size = -1L;
    long total = 0L;

    public Counter() {
    }

    public Counter(long size) {
        this.size = size;
        this.basicInitialize(null);
    }

    private void basicInitialize(IProcessingStepDescriptor descriptor) {
        if (!this.getStatus().isOK()) {
            return;
        }
        int code = descriptor != null ? (descriptor.isRequired() ? 4 : 1) : 4;
        if (this.size != -1L) {
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", "Counter size not set"));
        }
    }

    public void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        super.initialize(agent, descriptor, context);
        String data = descriptor.getData();
        if (data == null) {
            return;
        }
        try {
            this.size = data.equals("download") ? Long.parseLong(context.getProperty("download.size")) : (data.equals("artifact") ? Long.parseLong(context.getProperty("artifact.size")) : Long.parseLong(data));
        }
        catch (NumberFormatException e) {
            int code = descriptor.isRequired() ? 4 : 1;
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", "Counter size specification invalid", (Throwable)e));
            return;
        }
        this.basicInitialize(descriptor);
    }

    public void write(int b) throws IOException {
        ++this.total;
        this.getDestination().write(b);
    }

    public void close() throws IOException {
        super.close();
        if (this.total != this.size) {
            this.setStatus((IStatus)new Status(2, "plugin id", "Size mismatch.  Was " + this.total + " should have been " + this.size));
        }
    }
}

