/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.core.ContextQuery;

public class AggregateQueryTest
extends TestCase {
    public List getABCDE() {
        return Arrays.asList("A", "B", "C", "D", "E");
    }

    public List get123() {
        return Arrays.asList("1", "2", "3");
    }

    public void testEmptyCompositeQuery() {
        IQuery query = QueryUtil.createPipeQuery(Collections.emptySet());
        query.perform(this.getABCDE().iterator());
    }

    public void testSymmetry() {
        ContextQuery getLatest = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                ArrayList list = new ArrayList();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                Collections.sort(list);
                result.accept(list.get(list.size() - 1));
                return result;
            }
        };
        ContextQuery getAllBut3 = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o.equals("3")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        IQuery compoundQuery = QueryUtil.createCompoundQuery((IQuery)getLatest, (IQuery)getAllBut3, (boolean)true);
        IQueryResult result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)0, (int)AbstractProvisioningTest.queryResultSize(result));
        compoundQuery = QueryUtil.createCompoundQuery((IQuery)getAllBut3, (IQuery)getLatest, (boolean)true);
        result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)0, (int)AbstractProvisioningTest.queryResultSize(result));
        compoundQuery = QueryUtil.createCompoundQuery((IQuery)getLatest, (IQuery)getAllBut3, (boolean)false);
        result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)3, (int)AbstractProvisioningTest.queryResultSize(result));
        compoundQuery = QueryUtil.createCompoundQuery((IQuery)getAllBut3, (IQuery)getLatest, (boolean)false);
        result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)3, (int)AbstractProvisioningTest.queryResultSize(result));
    }

    public void testNonSymmetry() {
        ContextQuery getLatest = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                ArrayList list = new ArrayList();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                Collections.sort(list);
                result.accept(list.get(list.size() - 1));
                return result;
            }
        };
        ContextQuery getAllBut3 = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o.equals("3")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        IQuery compoundQuery = QueryUtil.createPipeQuery((IQuery)getLatest, (IQuery)getAllBut3);
        IQueryResult result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)0, (int)AbstractProvisioningTest.queryResultSize(result));
        compoundQuery = QueryUtil.createPipeQuery((IQuery)getAllBut3, (IQuery)getLatest);
        result = compoundQuery.perform(this.get123().iterator());
        AggregateQueryTest.assertEquals((int)1, (int)AbstractProvisioningTest.queryResultSize(result));
        AggregateQueryTest.assertEquals((Object)"2", result.iterator().next());
    }

    public void testIntersection() {
        MatchQuery ABC = new MatchQuery(){

            public boolean isMatch(Object candidate) {
                return candidate.equals("A") || candidate.equals("B") || candidate.equals("C");
            }
        };
        MatchQuery BCDE = new MatchQuery(){

            public boolean isMatch(Object candidate) {
                return candidate.equals("B") || candidate.equals("C") || candidate.equals("D") || candidate.equals("E");
            }
        };
        IQuery compoundQuery = QueryUtil.createCompoundQuery((IQuery)ABC, (IQuery)BCDE, (boolean)true);
        IQueryResult result = compoundQuery.perform(this.getABCDE().iterator());
        AggregateQueryTest.assertEquals((String)"1.0", (int)AbstractProvisioningTest.queryResultSize(result), (int)2);
        AbstractProvisioningTest.assertContains("1.1", result, "B");
        AbstractProvisioningTest.assertContains("1.2", result, "C");
    }

    public void testIntersection2() {
        ContextQuery ABC = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!o.equals("A") && !o.equals("B") && !o.equals("C")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        ContextQuery BCDE = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!o.equals("B") && !o.equals("C") && !o.equals("D") && !o.equals("E")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        IQuery compoundQuery = QueryUtil.createCompoundQuery((IQuery)ABC, (IQuery)BCDE, (boolean)true);
        IQueryResult result = compoundQuery.perform(this.getABCDE().iterator());
        AggregateQueryTest.assertEquals((String)"1.0", (int)AbstractProvisioningTest.queryResultSize(result), (int)2);
        AbstractProvisioningTest.assertContains("1.1", result, "B");
        AbstractProvisioningTest.assertContains("1.2", result, "C");
    }

    public void testUnion() {
        MatchQuery ABC = new MatchQuery(){

            public boolean isMatch(Object candidate) {
                return candidate.equals("A") || candidate.equals("B") || candidate.equals("C");
            }
        };
        MatchQuery BCDE = new MatchQuery(){

            public boolean isMatch(Object candidate) {
                return candidate.equals("B") || candidate.equals("C") || candidate.equals("D") || candidate.equals("E");
            }
        };
        IQuery compoundQuery = QueryUtil.createCompoundQuery((IQuery)ABC, (IQuery)BCDE, (boolean)false);
        IQueryResult result = compoundQuery.perform(this.getABCDE().iterator());
        AggregateQueryTest.assertEquals((String)"1.0", (int)AbstractProvisioningTest.queryResultSize(result), (int)5);
        AbstractProvisioningTest.assertContains("1.1", result, "A");
        AbstractProvisioningTest.assertContains("1.2", result, "B");
        AbstractProvisioningTest.assertContains("1.3", result, "C");
        AbstractProvisioningTest.assertContains("1.4", result, "D");
        AbstractProvisioningTest.assertContains("1.5", result, "E");
    }

    public void testUnion2() {
        ContextQuery ABC = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!o.equals("A") && !o.equals("B") && !o.equals("C")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        ContextQuery BCDE = new ContextQuery(){

            public Collector perform(Iterator iterator) {
                Collector result = new Collector();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!o.equals("B") && !o.equals("C") && !o.equals("D") && !o.equals("E")) continue;
                    result.accept(o);
                }
                return result;
            }
        };
        IQuery compoundQuery = QueryUtil.createCompoundQuery((IQuery)ABC, (IQuery)BCDE, (boolean)false);
        IQueryResult result = compoundQuery.perform(this.getABCDE().iterator());
        AggregateQueryTest.assertEquals((String)"1.0", (int)AbstractProvisioningTest.queryResultSize(result), (int)5);
        AbstractProvisioningTest.assertContains("1.1", result, "A");
        AbstractProvisioningTest.assertContains("1.2", result, "B");
        AbstractProvisioningTest.assertContains("1.3", result, "C");
        AbstractProvisioningTest.assertContains("1.4", result, "D");
        AbstractProvisioningTest.assertContains("1.5", result, "E");
    }
}

