/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.BackupStore;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class BackupTest
extends AbstractProvisioningTest {
    private static final String BUPREFIX = "BackupTest";
    private File sourceDir;
    private File aDir;
    private File aaDir;
    private File bDir;
    private File aTxt;
    private File bTxt;
    private File abDir;
    private File cTxt;
    private File cTxtRelative;

    @Override
    public void setUp() {
        String userHome = System.getProperty("user.home");
        this.sourceDir = new File(new File(userHome), "P2BUTEST");
        this.aDir = new File(this.sourceDir, "A");
        this.aDir.mkdirs();
        this.aaDir = new File(this.aDir, "AA");
        this.aaDir.mkdir();
        this.abDir = new File(this.aDir, "AB");
        this.abDir.mkdir();
        this.bDir = new File(this.sourceDir, "B");
        this.bDir.mkdirs();
        this.aTxt = new File(this.aaDir, "a.txt");
        this.bTxt = new File(this.aaDir, "b.txt");
        this.cTxt = new File(this.abDir, "c.txt");
        this.cTxtRelative = new File(this.aaDir, "../AB/c.txt");
        try {
            this.writeToFile(this.aTxt, "A\nA file with an A");
            this.writeToFile(this.bTxt, "B\nA file with a B");
            this.writeToFile(this.cTxt, "C\nA file with a C");
        }
        catch (IOException iOException) {
            BackupTest.fail();
        }
    }

    private void writeToFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    @Override
    public void tearDown() {
        this.fullyDelete(this.sourceDir);
    }

    private boolean fullyDelete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                if (!this.fullyDelete(new File(file, children[i].getName()))) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    public void testBackupRelative() {
        BackupStore store = new BackupStore(null, BUPREFIX);
        try {
            store.backup(this.cTxtRelative);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up cTxtRelative");
        }
        if (this.cTxt.exists()) {
            BackupTest.fail((String)"File not moved to backup - still exists");
        }
        try {
            this.writeToFile(this.cTxt, "XXXX\n- This file should be restored with C");
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Could not write a file for testing purposes.");
        }
        try {
            store.restore();
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Restore operation failed with IOException");
        }
        BackupTest.assertFileContent("Restore of C failed - not original content", this.cTxt, "C");
        this.assertNoGarbage(store);
    }

    public void testBackupRestore() {
        BackupStore store = new BackupStore(null, BUPREFIX);
        try {
            store.backup(this.aTxt);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up aTxt");
        }
        if (this.aTxt.exists()) {
            BackupTest.fail((String)"File not moved to backup - still exists");
        }
        try {
            this.writeToFile(this.aTxt, "XXXX\n- This file should be restored with A");
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Could not write a file for testing purposes.");
        }
        try {
            store.backup(this.bDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up bDir");
        }
        if (this.bDir.exists()) {
            BackupTest.fail((String)"Backed up directory was not moved");
        }
        try {
            store.backupCopy(this.bTxt);
            BackupTest.assertFileContent("File should have been copied", this.bTxt, "B");
        }
        catch (IOException iOException) {
            BackupTest.fail((String)"Could not backupCopy bTxt");
        }
        try {
            store.restore();
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Restore operation failed with IOException");
        }
        BackupTest.assertFileContent("Restore of A failed - not original content", this.aTxt, "A");
        if (!this.bDir.isDirectory() && this.bDir.listFiles().length != 0) {
            BackupTest.fail((String)"Empty directory not restored ok");
        }
        this.assertNoGarbage(store);
    }

    public void testBackupDiscard() {
        BackupStore store = new BackupStore(null, BUPREFIX);
        try {
            store.backup(this.aTxt);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up aTxt");
        }
        if (this.aTxt.exists()) {
            BackupTest.fail((String)"File not moved to backup - still exists");
        }
        try {
            this.writeToFile(this.aTxt, "XXXX\n- This file should be restored with A");
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Could not write a file for testing purposes.");
        }
        try {
            store.backup(this.bDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up bDir");
        }
        if (this.bDir.exists()) {
            BackupTest.fail((String)"Backed up directory was not moved");
        }
        store.discard();
        BackupTest.assertFileContent("Discard of A failed - not new content", this.aTxt, "XXXX");
        if (this.bDir.isDirectory()) {
            BackupTest.fail((String)"Remove of empty directory not discarded ok");
        }
        this.assertNoGarbage(store);
    }

    public void testBackupAll() {
        BackupStore store = new BackupStore(null, BUPREFIX);
        try {
            store.backupAll(this.aDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up aDir");
        }
        if (this.aTxt.exists()) {
            BackupTest.fail((String)"File not moved to backup - still exists");
        }
        if (this.bTxt.exists()) {
            BackupTest.fail((String)"File bTxt not moved to backup - still exists");
        }
        try {
            this.writeToFile(this.aTxt, "XXXX\n- This file should be restored with A");
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Could not write a file for testing purposes.");
        }
        try {
            store.restore();
        }
        catch (IOException iOException) {
            BackupTest.fail((String)"Restore failed");
        }
        BackupTest.assertFileContent("A not restored", this.aTxt, "A");
        BackupTest.assertFileContent("B not restored", this.bTxt, "B");
        this.assertNoGarbage(store);
    }

    public void testBackupCopyAll() {
        BackupStore store = new BackupStore(null, BUPREFIX);
        try {
            store.backupCopyAll(this.aDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"IO Exception when backing up aDir");
        }
        if (!this.aTxt.exists()) {
            BackupTest.fail((String)"File not copied to backup - does not exist");
        }
        if (!this.bTxt.exists()) {
            BackupTest.fail((String)"File bTxt not copied to backup - does not exists");
        }
        try {
            this.writeToFile(this.aTxt, "XXXX\n- This file should be restored with A");
            this.writeToFile(this.bTxt, "XXXX\n- This file should be restored with B");
        }
        catch (IOException e) {
            e.printStackTrace();
            BackupTest.fail((String)"Could not write a file for testing purposes.");
        }
        try {
            store.restore();
        }
        catch (IOException iOException) {
            BackupTest.fail((String)"Restore failed");
        }
        BackupTest.assertFileContent("A not restored", this.aTxt, "A");
        BackupTest.assertFileContent("B not restored", this.bTxt, "B");
        this.assertNoGarbage(store);
    }

    private void assertNoGarbage(BackupStore store) {
        File buDir = new File(store.getBackupRoot(), BUPREFIX);
        if (buDir.exists()) {
            BackupTest.fail((String)"Backup directory not cleaned up");
        }
    }
}

