/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.TestProgressMonitor;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.core.ContextQuery;

public class CompoundQueryableTest
extends TestCase {
    IQueryable<Integer> queryable1 = new IQueryable<Integer>(){
        Integer[] elements = new Integer[]{1, 2, 3, 4, 5};

        public IQueryResult<Integer> query(IQuery<Integer> query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQueryable<Integer> queryable2 = new IQueryable<Integer>(){
        Integer[] elements = new Integer[]{4, 6, 8, 10, 12};

        public IQueryResult<Integer> query(IQuery<Integer> query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQueryable queryable3 = new IQueryable(){
        Integer[] elements = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};

        public IQueryResult query(IQuery query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQuery matchQuery = new MatchQuery(){

        public boolean isMatch(Object candidate) {
            int x;
            return candidate instanceof Integer && (x = ((Integer)candidate).intValue()) % 2 == 0;
        }
    };
    IQuery matchMod4query = new MatchQuery(){

        public boolean isMatch(Object candidate) {
            int x;
            return candidate instanceof Integer && (x = ((Integer)candidate).intValue()) % 4 == 0;
        }
    };
    IQuery contextQuery = new ContextQuery(){

        public Collector perform(Iterator iterator) {
            Collector result = new Collector();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Integer) || (Integer)o % 2 != 0) continue;
                result.accept(o);
            }
            return result;
        }
    };
    IQuery greatestNumberQuery = new ContextQuery(){

        public Collector perform(Iterator iterator) {
            Collector result = new Collector();
            int greatest = Integer.MIN_VALUE;
            while (iterator.hasNext()) {
                int item = (Integer)iterator.next();
                if (item <= greatest) continue;
                greatest = item;
            }
            if (greatest == Integer.MIN_VALUE) {
                return result;
            }
            result.accept((Object)greatest);
            return result;
        }
    };

    static Iterator createIterator(Object[] array) {
        return Arrays.asList(array).iterator();
    }

    public void testMatchQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)6, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.3", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.5", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testSingleQueryable() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)2, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
    }

    public void testSingleContextQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 5);
    }

    public void testMultipleContextQueries() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 12);
    }

    public void testCompoundMatchAndQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery((IQuery)this.matchQuery, (IQuery)this.matchMod4query, (boolean)true), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)3, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testCompoundMatchOrQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery((IQuery)this.matchQuery, (IQuery)this.matchMod4query, (boolean)false), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)6, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testMatchQueryProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testSingleQueryableProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testSingleContextQueryProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testMultipleContextQueriesProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testNullProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        cQueryable.query(this.greatestNumberQuery, null);
    }

    public void testDoubleCompoundContextOrQuery() {
        IQueryable cQueryable1 = QueryUtil.compoundQueryable((IQueryable)this.queryable3, this.queryable2);
        IQueryable cQueryable = QueryUtil.compoundQueryable((IQueryable)cQueryable1, this.queryable1);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery((IQuery)this.contextQuery, (IQuery)this.greatestNumberQuery, (boolean)false), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)7, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 13);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testDoubleCompositeQuery() {
        IQueryable cQueryable1 = QueryUtil.compoundQueryable((IQueryable)this.queryable3, this.queryable2);
        IQueryable cQueryable = QueryUtil.compoundQueryable((IQueryable)cQueryable1, this.queryable1);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createPipeQuery((IQuery)this.contextQuery, (IQuery)this.greatestNumberQuery), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 12);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public static class CompoundQueryTestProgressMonitor
    extends TestProgressMonitor {
        private boolean isDone;
        private int assignedWork = 0;
        private int amountWorked = 0;

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.assignedWork += totalWork;
        }

        public void worked(int work) {
            this.amountWorked += work;
        }

        public boolean isWorkDone() {
            return this.amountWorked > 0 && (this.assignedWork == -1 || this.amountWorked == this.assignedWork);
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void done() {
            super.done();
            this.isDone = true;
        }
    }
}

