/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class QueryTest
extends TestCase {
    public void testPerformSimple() {
        List<String> items = Arrays.asList("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQueryResult collector = query.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)3, (int)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains("1.1", collector, "red");
        AbstractProvisioningTest.assertContains("1.2", collector, "green");
        AbstractProvisioningTest.assertContains("1.3", collector, "blue");
    }

    public void testPerformSomeMatches() {
        List<Object> items = Arrays.asList(new Object(), "green", new Object());
        AnyStringQuery query = new AnyStringQuery();
        IQueryResult collector = query.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains("1.1", collector, "green");
    }

    public void testLimitQuery() {
        List<String> items = Arrays.asList("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)1);
        IQueryResult collector = limitQuery.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains("1.1", collector, "red");
    }

    public void testLimitQuery2() {
        List<String> items = Arrays.asList("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)2);
        IQueryResult collector = limitQuery.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)2, (int)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains("1.1", collector, "red");
        AbstractProvisioningTest.assertContains("1.2", collector, "green");
    }

    public void testLimitQuery3() {
        List<String> items = Arrays.asList("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)3);
        IQueryResult collector = limitQuery.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)3, (int)AbstractProvisioningTest.queryResultSize(collector));
        AbstractProvisioningTest.assertContains("1.1", collector, "red");
        AbstractProvisioningTest.assertContains("1.2", collector, "green");
        AbstractProvisioningTest.assertContains("1.3", collector, "blue");
    }

    public void testLimitQuery0() {
        List<String> items = Arrays.asList("red", "green", "blue");
        AnyStringQuery query = new AnyStringQuery();
        IQuery limitQuery = QueryUtil.createLimitQuery((IQuery)query, (int)0);
        IQueryResult collector = limitQuery.perform(items.iterator());
        QueryTest.assertEquals((String)"1.0", (int)0, (int)AbstractProvisioningTest.queryResultSize(collector));
    }

    static class AnyStringQuery
    extends MatchQuery {
        AnyStringQuery() {
        }

        public boolean isMatch(Object candidate) {
            return candidate instanceof String;
        }
    }
}

