/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.directorywatcher;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.BundleContext;

class TestRepositoryWatcher
extends DirectoryWatcher {
    private RepositoryListener listener;

    public static TestRepositoryWatcher createWatcher(File folder) {
        RepositoryListener listener = new RepositoryListener(AbstractProvisioningTest.getUniqueString(), null);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("eclipse.p2.directory.watcher.dir", folder.getAbsolutePath());
        props.put("eclipse.p2.directory.watcher.poll", "500");
        TestRepositoryWatcher result = new TestRepositoryWatcher(props, TestActivator.getContext());
        result.addListener(listener);
        return result;
    }

    private TestRepositoryWatcher(Map<String, String> props, BundleContext context) {
        super(props, context);
    }

    public synchronized void addListener(RepositoryListener repoListener) {
        super.addListener((DirectoryChangeListener)repoListener);
        this.listener = repoListener;
    }

    public IInstallableUnit[] getInstallableUnits() {
        return (IInstallableUnit[])this.listener.getMetadataRepository().query(QueryUtil.createIUAnyQuery(), null).toArray(IInstallableUnit.class);
    }

    public IArtifactKey[] getArtifactKeys() {
        IQueryResult keys = this.listener.getArtifactRepository().query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        return (IArtifactKey[])keys.toArray(IArtifactKey.class);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return this.listener.getArtifactRepository().getArtifactDescriptors(key);
    }

    public File getArtifactFile(IArtifactKey key) {
        return ((IFileArtifactRepository)this.listener.getArtifactRepository()).getArtifactFile(key);
    }
}

