/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.embeddedequinox;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class EmbeddedEquinox {
    private final Map frameworkProperties;
    private final String[] frameworkArgs;
    private Class eclipseStarterClazz;
    private BundleContext context;
    private URL[] frameworkClassPath;

    public EmbeddedEquinox(Map frameworkProperties, String[] frameworkArgs, URL[] frameworkClassPath) {
        this.frameworkProperties = frameworkProperties;
        this.frameworkArgs = frameworkArgs;
        this.frameworkClassPath = frameworkClassPath;
    }

    public BundleContext startFramework() {
        System.setProperty("osgi.framework.useSystemProperties", "false");
        try {
            FrameworkClassLoader frameworkLoader = new FrameworkClassLoader(this.frameworkClassPath, this.getClass().getClassLoader());
            this.eclipseStarterClazz = frameworkLoader.loadClass("org.eclipse.core.runtime.adaptor.EclipseStarter");
            Method setInitialProperties = this.eclipseStarterClazz.getMethod("setInitialProperties", Map.class);
            setInitialProperties.invoke(null, this.frameworkProperties);
            Method runMethod = this.eclipseStarterClazz.getMethod("startup", String[].class, Runnable.class);
            Object[] objectArray = new Object[2];
            objectArray[0] = this.frameworkArgs;
            this.context = (BundleContext)runMethod.invoke(null, objectArray);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return this.context;
    }

    public void shutdown() {
        try {
            Method shutdownMethod = this.eclipseStarterClazz.getMethod("shutdown", null);
            shutdownMethod.invoke(null, null);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public class FrameworkClassLoader
    extends URLClassLoader {
        ClassLoader embeddedBundleLoader;

        public FrameworkClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, (ClassLoader)null);
            this.embeddedBundleLoader = parent;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("org.osgi.framework.") || name.startsWith("org.osgi.resource.")) {
                return this.embeddedBundleLoader.loadClass(name);
            }
            return super.findClass(name);
        }

        @Override
        public URL findResource(String name) {
            if (name.startsWith("org/osgi/framework/") || name.startsWith("org/osgi/resource/")) {
                return this.embeddedBundleLoader.getResource(name);
            }
            return super.findResource(name);
        }

        public Enumeration findResources(String name) throws IOException {
            if (name.startsWith("org/osgi/framework/") || name.startsWith("org/osgi/resource/")) {
                return this.embeddedBundleLoader.getResources(name);
            }
            return super.findResources(name);
        }
    }
}

