/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.equinox.internal.p2.engine.ActionManager;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ActionManagerTest
extends AbstractProvisioningTest {
    public ActionManagerTest(String name) {
        super(name);
    }

    public ActionManagerTest() {
        super("");
    }

    public void testGetTouchpointQualifiedActionId() {
        ActionManager manager = new ActionManager();
        ActionManagerTest.assertNotNull((Object)manager.getTouchpointQualifiedActionId("test", MetadataFactory.createTouchpointType((String)"phaseTest", (Version)Version.create((String)"1"))));
    }

    public void testGetActionWithVersion() {
        ActionManager manager = new ActionManager();
        ActionManagerTest.assertNotNull((Object)manager.getAction("test1.test", new VersionRange("1.0.0")));
    }

    public void testGetActionWithNullVersion() {
        ActionManager manager = new ActionManager();
        ActionManagerTest.assertNotNull((Object)manager.getAction("test1.test", null));
    }

    public void DISABLED_testDynamicAction() throws MalformedURLException, BundleException, InterruptedException {
        ActionManager manager = new ActionManager();
        ActionManagerTest.assertNull((Object)manager.getAction("dummy.touchpointAndAction.dummy", new VersionRange("1.0.0")));
        File dummy = ActionManagerTest.getTestData("0.1", "/testData/engineTest/dummy.touchpointAndAction_1.0.0.jar");
        Bundle bundle = TestActivator.getContext().installBundle(dummy.toURL().toString());
        bundle.start();
        int maxTries = 20;
        int current = 0;
        while (manager.getAction("dummy.touchpointAndAction.dummy", new VersionRange("1.0.0")) == null) {
            if (++current == maxTries) {
                ActionManagerTest.fail((String)"dummy action not added");
            }
            Thread.sleep(100L);
        }
        bundle.uninstall();
        current = 0;
        while (manager.getAction("dummy.touchpointAndAction.dummy", new VersionRange("1.0.0")) != null) {
            if (++current == maxTries) {
                ActionManagerTest.fail((String)"dummy action not removed");
            }
            Thread.sleep(100L);
        }
    }
}

