/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class DownloadManagerTest
extends AbstractProvisioningTest {
    private static final String testDataFileLocation = "testData/artifactRepo/simple/artifacts.xml";
    private static final String testDataFileZipLocation = "testData/artifactRepo/jarfiles/artifacts.jar";

    public static Test suite() {
        return new TestSuite(DownloadManagerTest.class);
    }

    public void testEmpty() {
        DownloadManager manager = this.createDownloadManager(null);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    public void testEmptyWithContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    public void testAddNullArtifactRequest() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        try {
            manager.add(null);
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        DownloadManagerTest.fail((String)"1.0");
    }

    public void testAddNullArtifactRequestArray() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        try {
            manager.add(null);
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        DownloadManagerTest.fail((String)"1.0");
    }

    public void testAddEmptyArtifactRequestArray() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        manager.add(new IArtifactRequest[0]);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    public void testAddArtifactRequestArrayContainingNull() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        try {
            IArtifactRequest[] requests = new IArtifactRequest[1];
            manager.add(requests);
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        DownloadManagerTest.fail((String)"1.0");
    }

    public void testAddArtifactRequest() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest request = this.createArtifactRequest();
        manager.add(request);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    public void testContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        context.setArtifactRepositories(new URI[0]);
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest request = this.createArtifactRequest();
        manager.add(request);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertFalse((String)"1.0", (boolean)result.isOK());
        DownloadManagerTest.assertNotNull((Object)result.getException());
    }

    public void testAddArtifactRequestArray() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest[] requests = new IArtifactRequest[]{this.createArtifactRequest()};
        manager.add(requests);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    private IArtifactRequest createArtifactRequest() {
        IArtifactRequest request = new IArtifactRequest(){

            public IArtifactKey getArtifactKey() {
                return null;
            }

            public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
            }

            public IStatus getResult() {
                return Status.OK_STATUS;
            }
        };
        return request;
    }

    public void testEmptyArtifactRepositoryListContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        context.setArtifactRepositories(new URI[0]);
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest[] requests = new IArtifactRequest[]{this.createArtifactRequest()};
        manager.add(requests);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertEquals((String)"1.0", (int)4, (int)result.getSeverity());
    }

    public void testFileFirstArtifactRepositoryListContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        URI[] artifactRepos = new URI[]{DownloadManagerTest.getTestData("Simple Artifact Repo", testDataFileLocation).toURI(), URIUtil.toJarURI((URI)DownloadManagerTest.getTestData("Simple Artifact Repo Zip", testDataFileZipLocation).toURI(), null)};
        context.setArtifactRepositories(artifactRepos);
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest[] requests = new IArtifactRequest[]{this.createArtifactRequest()};
        manager.add(requests);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[0]);
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[1]);
    }

    public void testFileLastArtifactRepositoryListContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        URI[] artifactRepos = new URI[]{URIUtil.toJarURI((URI)DownloadManagerTest.getTestData("Simple Artifact Repo Zip", testDataFileZipLocation).toURI(), null), DownloadManagerTest.getTestData("Simple Artifact Repo", testDataFileLocation).toURI()};
        context.setArtifactRepositories(artifactRepos);
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest[] requests = new IArtifactRequest[]{this.createArtifactRequest()};
        manager.add(requests);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[0]);
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[1]);
    }

    public void testNoFileArtifactRepositoryListContext() {
        ProvisioningContext context = new ProvisioningContext(DownloadManagerTest.getAgent());
        URI[] artifactRepos = new URI[2];
        try {
            artifactRepos[0] = URIUtil.toJarURI((URI)DownloadManagerTest.getTestData("Simple Artifact Repo Zip", testDataFileZipLocation).toURI(), null);
            String absolute = this.getTempFolder() + "/test2";
            artifactRepos[1] = URIUtil.toJarURI((URI)URIUtil.fromString((String)absolute), null);
        }
        catch (URISyntaxException e) {
            DownloadManagerTest.fail((String)e.getMessage());
        }
        context.setArtifactRepositories(artifactRepos);
        DownloadManager manager = this.createDownloadManager(context);
        IArtifactRequest[] requests = new IArtifactRequest[]{this.createArtifactRequest()};
        manager.add(requests);
        IStatus result = manager.start(null);
        DownloadManagerTest.assertTrue((String)"1.0", (boolean)result.isOK());
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[0]);
        DownloadManagerTest.getArtifactRepositoryManager().removeRepository(artifactRepos[1]);
    }

    private DownloadManager createDownloadManager(ProvisioningContext context) {
        return new DownloadManager(context, DownloadManagerTest.getAgent());
    }
}

