/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ParameterizedProvisioningActionTest
extends AbstractProvisioningTest {
    boolean passTest = false;
    String value;
    ProvisioningAction action = new ProvisioningAction(){

        public IStatus execute(Map parameters) {
            ParameterizedProvisioningActionTest.this.value = (String)parameters.get("test");
            return null;
        }

        public IStatus undo(Map parameters) {
            return null;
        }
    };

    public ParameterizedProvisioningActionTest(String name) {
        super(name);
    }

    public void testBasicParameter() {
        this.value = null;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "testValue");
        HashMap phaseParameters = new HashMap();
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"testValue", (String)this.value);
    }

    public void testVariableParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "test${variable}");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"testValue", (String)this.value);
    }

    public void testEscapedCharacterParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "testV${#97}lue");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"testValue", (String)this.value);
    }

    public void testOutOfRangeEscapedCharacterParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "${#999999999999999999999999999999999999999999999}");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"", (String)this.value);
    }

    public void testLargerThanCharEscapedCharacterParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "testV${#65633}lue");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"testVlue", (String)this.value);
    }

    public void testNegativeOutOfRangeCharEscapedCharacterParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "testV${#-65439}lue");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"testVlue", (String)this.value);
    }

    public void testNotNumberEscapedCharacterParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "${#xFFFF}");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"", (String)this.value);
    }

    public void testNaughtyEscapedCharactersParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "${#36} ${#44} ${#58} ${#59} ${#123} ${#125}");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"$ , : ; { }", (String)this.value);
    }

    public void testNullCharEscapedCharactersParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "a${#0}b");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"a\u0000b", (String)this.value);
    }

    public void testMaxCharEscapedCharactersParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "a${#65535}b");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"a\uffffb", (String)this.value);
    }

    public void testOverMaxCharEscapedCharactersParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "a${#65536}b");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"ab", (String)this.value);
    }

    public void testUnderMinCharEscapedCharactersParameter() {
        this.passTest = false;
        HashMap<String, String> actionParameters = new HashMap<String, String>();
        actionParameters.put("test", "a${#-1}b");
        HashMap<String, String> phaseParameters = new HashMap<String, String>();
        phaseParameters.put("variable", "Value");
        ParameterizedProvisioningAction pAction = new ParameterizedProvisioningAction(this.action, actionParameters, null);
        pAction.execute(phaseParameters);
        ParameterizedProvisioningActionTest.assertEquals((String)"ab", (String)this.value);
    }
}

