/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.net.URI;
import java.util.Collections;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ProvisioningContextTest
extends AbstractProvisioningTest {
    private static final String testDataFileLocation = "testData/provisioningContextTests/";
    private static final int A_UNITCOUNT = 37;
    private static final String TEST = "TestProvisioningContextFollow";
    protected IMetadataRepository repoA;
    protected IMetadataRepository repoB;
    protected IMetadataRepository repoC;
    URI uriA;
    URI uriB;
    URI uriC;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.uriA = ProvisioningContextTest.getTestData("A", "testData/provisioningContextTests/A").toURI();
        this.uriB = ProvisioningContextTest.getTestData("B", "testData/provisioningContextTests/B").toURI();
        this.uriC = ProvisioningContextTest.getTestData("C", "testData/provisioningContextTests/C").toURI();
        this.repoA = ProvisioningContextTest.getMetadataRepositoryManager().loadRepository(this.uriA, this.getMonitor());
        this.repoA.addReferences(Collections.singletonList(new RepositoryReference(this.uriA, null, 1, 1)));
        this.repoB = ProvisioningContextTest.getMetadataRepositoryManager().loadRepository(this.uriB, this.getMonitor());
        this.repoB.addReferences(Collections.singletonList(new RepositoryReference(this.uriB, null, 1, 1)));
        this.repoA.addReferences(Collections.singletonList(new RepositoryReference(this.repoB.getLocation(), null, 0, 1)));
        this.repoC = ProvisioningContextTest.getMetadataRepositoryManager().loadRepository(this.uriC, this.getMonitor());
        this.repoC.addReferences(Collections.singletonList(new RepositoryReference(this.uriC, null, 1, 1)));
        this.repoB.addReferences(Collections.singletonList(new RepositoryReference(this.repoC.getLocation(), null, 0, 1)));
    }

    @Override
    protected void tearDown() throws Exception {
        ProvisioningContextTest.getArtifactRepositoryManager().removeRepository(this.uriA);
        ProvisioningContextTest.getArtifactRepositoryManager().removeRepository(this.uriB);
        ProvisioningContextTest.getArtifactRepositoryManager().removeRepository(this.uriC);
        ProvisioningContextTest.getMetadataRepositoryManager().removeRepository(this.uriA);
        ProvisioningContextTest.getMetadataRepositoryManager().removeRepository(this.uriB);
        ProvisioningContextTest.getMetadataRepositoryManager().removeRepository(this.uriC);
    }

    public void testContextOneRepoNoFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertEquals((String)"Only IUs from A", (int)37, (int)queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size());
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"1 separately located artifact repos", (int)1, (int)followed.length);
    }

    public void testContextOneRepoWithFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"More IUs", (queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size() >= 39 ? 1 : 0) != 0);
        IInstallableUnit[] units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"B"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find B", (units.length > 0 ? 1 : 0) != 0);
        units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"C"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find C", (units.length > 0 ? 1 : 0) != 0);
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"3 artifact repos", (int)3, (int)followed.length);
    }

    public void testContextTwoRepoNoFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation(), this.repoB.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"IUs from A and B", (queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size() > 37 ? 1 : 0) != 0);
        IInstallableUnit[] units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"B"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find B", (units.length > 0 ? 1 : 0) != 0);
        units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"C"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertFalse((String)"should not find C", (units.length > 0 ? 1 : 0) != 0);
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"two artifact repos", (int)2, (int)followed.length);
    }

    public void testContextTwoRepoWithFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation(), this.repoB.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"More IUs", (queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size() >= 39 ? 1 : 0) != 0);
        IInstallableUnit[] units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"B"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find B", (units.length > 0 ? 1 : 0) != 0);
        units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"C"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find C", (units.length > 0 ? 1 : 0) != 0);
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"three artifact repos", (int)3, (int)followed.length);
    }

    public void testContextThreeRepoNoFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation(), this.repoB.getLocation(), this.repoC.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"More IUs", (queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size() >= 39 ? 1 : 0) != 0);
        IInstallableUnit[] units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"B"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find B", (units.length > 0 ? 1 : 0) != 0);
        units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"C"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find C", (units.length > 0 ? 1 : 0) != 0);
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"three artifact repos", (int)3, (int)followed.length);
    }

    public void testContextThreeRepoWithFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation(), this.repoB.getLocation(), this.repoC.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        IQueryable queryable = context.getMetadata(this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"More IUs", (queryable.query(QueryUtil.ALL_UNITS, this.getMonitor()).toUnmodifiableSet().size() >= 39 ? 1 : 0) != 0);
        IInstallableUnit[] units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"B"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find B", (units.length > 0 ? 1 : 0) != 0);
        units = (IInstallableUnit[])queryable.query(QueryUtil.createIUQuery((String)"C"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find C", (units.length > 0 ? 1 : 0) != 0);
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"three artifact repos", (int)3, (int)followed.length);
    }

    public void testContextNoReposNoFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setArtifactRepositories(new URI[0]);
        context.setMetadataRepositories(new URI[0]);
        context.getMetadata(this.getMonitor());
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"1.1", (int)0, (int)followed.length);
    }

    public void testContextNoReposWithFollow() {
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        context.setArtifactRepositories(new URI[0]);
        context.setMetadataRepositories(new URI[0]);
        context.getMetadata(this.getMonitor());
        ExpressionMatchQuery all = new ExpressionMatchQuery(IArtifactRepository.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]);
        IArtifactRepository[] followed = (IArtifactRepository[])context.getArtifactRepositories(this.getMonitor()).query((IQuery)all, this.getMonitor()).toArray(IArtifactRepository.class);
        ProvisioningContextTest.assertEquals((String)"1.1", (int)0, (int)followed.length);
    }

    public void testFollowHelpsResolve() {
        this.createProfile(TEST);
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)ProvisioningContextTest.getAgent(), (String)TEST);
        IInstallableUnit[] units = (IInstallableUnit[])this.repoA.query(QueryUtil.createIUQuery((String)"A"), this.getMonitor()).toArray(IInstallableUnit.class);
        ProvisioningContextTest.assertTrue((String)"should find A in main repo", (units.length > 0 ? 1 : 0) != 0);
        request.add(units[0]);
        ProvisioningContext context = new ProvisioningContext(ProvisioningContextTest.getAgent());
        context.setMetadataRepositories(new URI[]{this.repoA.getLocation()});
        context.setArtifactRepositories(new URI[0]);
        IProvisioningPlan plan = this.getPlanner(ProvisioningContextTest.getAgent()).getProvisioningPlan((IProfileChangeRequest)request, context, this.getMonitor());
        ProvisioningContextTest.assertFalse((String)"resolve should fail with missing requirements", (boolean)plan.getStatus().isOK());
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        plan = this.getPlanner(ProvisioningContextTest.getAgent()).getProvisioningPlan((IProfileChangeRequest)request, context, this.getMonitor());
        ProvisioningContextTest.assertTrue((String)"resolve should pass", (boolean)plan.getStatus().isOK());
    }
}

