/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.extensionlocation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;

public class ExtensionLocationArtifactRepositoryFactoryTest
extends AbstractProvisioningTest {
    private File tempDirectory;
    private ExtensionLocationArtifactRepositoryFactory factory;

    public ExtensionLocationArtifactRepositoryFactoryTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        ExtensionLocationArtifactRepositoryFactoryTest.delete(this.tempDirectory);
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.tempDirectory = new File(tempDir, "extensionlocationtest");
        ExtensionLocationArtifactRepositoryFactoryTest.delete(this.tempDirectory);
        this.tempDirectory.mkdirs();
        this.factory = new ExtensionLocationArtifactRepositoryFactory();
        this.factory.setAgent(ExtensionLocationArtifactRepositoryFactoryTest.getAgent());
    }

    public static File getFile(String path) throws IOException {
        URL fileURL = TestActivator.getContext().getBundle().getEntry(path);
        return new File(FileLocator.toFileURL((URL)fileURL).getPath());
    }

    public void testNonFileURL() {
        try {
            URI nonFileURL = new URI("http://www.eclipse.org");
            this.factory.load(nonFileURL, 0, this.getMonitor());
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.assertEquals((String)"0.5", (int)1000, (int)e.getStatus().getCode());
        }
        catch (URISyntaxException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.99", e);
        }
    }

    public void testNonExistentFile() {
        File directory = new File(this.tempDirectory, "nonexistent");
        ExtensionLocationArtifactRepositoryFactoryTest.delete(directory);
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.assertEquals((String)"0.5", (int)1000, (int)e.getStatus().getCode());
        }
    }

    public void testNotDirectory() {
        File file = new File(this.tempDirectory, "exists.file");
        try {
            file.createNewFile();
            this.factory.load(file.toURI(), 0, this.getMonitor());
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"0.1");
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.assertEquals((String)"0.5", (int)1000, (int)e.getStatus().getCode());
        }
        catch (MalformedURLException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.99", e);
        }
        catch (IOException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.100", e);
        }
    }

    public void testNoFeatureOrPluginsDirectory() {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            try {
                this.factory.load(directory.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testEmptyFeatureAndPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "plugins").mkdir();
        new File(directory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.1", e);
        }
    }

    public void testEmptyFeaturesDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.1", e);
        }
    }

    public void testEmptyPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        new File(directory, "plugins").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.1", e);
        }
    }

    public void testEclipseBaseEmptyFeatureAndPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        eclipseDirectory.mkdir();
        new File(eclipseDirectory, "plugins").mkdir();
        new File(eclipseDirectory, "features").mkdir();
        try {
            this.factory.load(directory.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.1", e);
        }
    }

    public void testNotEclipseBaseEmptyFeatureAndPluginsDirectory() {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File eclipseDirectory = new File(directory, "noteclipse");
            eclipseDirectory.mkdir();
            new File(eclipseDirectory, "plugins").mkdir();
            new File(eclipseDirectory, "features").mkdir();
            try {
                this.factory.load(directory.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testNormalFeaturesandPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
        URI location = directory.toURI();
        try {
            IArtifactRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (this.getArtifactKeyCount(repo) != 2) {
                ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.1");
            }
        }
        catch (ProvisionException provisionException) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testNormalFeaturesDirectory() {
        File directory = new File(this.tempDirectory, "exists/features");
        directory.mkdirs();
        File features = new File(directory, "features");
        features.mkdir();
        ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation/features"), features);
        URI location = directory.toURI();
        try {
            IArtifactRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (this.getArtifactKeyCount(repo) != 1) {
                ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.1");
            }
        }
        catch (ProvisionException provisionException) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testNormalPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists/plugins");
        directory.mkdirs();
        File plugins = new File(directory, "plugins");
        plugins.mkdir();
        ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation/plugins"), plugins);
        URI location = directory.toURI();
        try {
            IArtifactRepository repo = this.factory.load(location, 0, this.getMonitor());
            if (this.getArtifactKeyCount(repo) != 1) {
                ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.1");
            }
        }
        catch (ProvisionException provisionException) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"2.0");
        }
    }

    public void testEclipseBaseNormalFeaturesandPluginsDirectory() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        ExtensionLocationArtifactRepositoryFactoryTest.copy("1.1", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), eclipseDirectory);
        try {
            IArtifactRepository repo = this.factory.load(directory.toURI(), 0, this.getMonitor());
            if (this.getArtifactKeyCount(repo) != 2) {
                ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
            }
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.5", e);
        }
    }

    public void testEclipseBaseModifiableRepository() {
        File directory = new File(this.tempDirectory, "exists");
        directory.mkdirs();
        File eclipseDirectory = new File(directory, "eclipse");
        ExtensionLocationArtifactRepositoryFactoryTest.copy("1.1", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), eclipseDirectory);
        try {
            IArtifactRepository repo = this.factory.load(directory.toURI(), 1, this.getMonitor());
            ExtensionLocationArtifactRepositoryFactoryTest.assertNull((String)"1.0", (Object)repo);
        }
        catch (ProvisionException e) {
            ExtensionLocationArtifactRepositoryFactoryTest.fail("0.5", e);
        }
    }

    public void testUpdateSiteXMLURL() {
        block2: {
            File site = ExtensionLocationArtifactRepositoryFactoryTest.getTestData("0.1", "/testData/updatesite/site");
            try {
                this.factory.load(site.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testXXXSiteXXXXMLURL() {
        block2: {
            File site = ExtensionLocationArtifactRepositoryFactoryTest.getTestData("0.1", "/testData/updatesite/xxxsitexxx");
            try {
                this.factory.load(site.toURI(), 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testArtifactsXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File artifactsXML = new File(directory, "artifacts.xml");
            artifactsXML.createNewFile();
            ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testArtifactsXMLFeaturesandPluginsDirectoryWithExtensionLocation() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File artifactsXML = new File(directory, "artifacts.xml");
            artifactsXML.createNewFile();
            ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            File extensionLocation = new File(String.valueOf(this.tempDirectory.getAbsolutePath()) + ".eclipseextension");
            URI location = extensionLocation.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testContentXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File contentXML = new File(directory, "content.xml");
            contentXML.createNewFile();
            ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testCompositeArtifactsXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File compositeArtifactsXML = new File(directory, "compositeArtifacts.xml");
            compositeArtifactsXML.createNewFile();
            ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }

    public void testCompositeContentXMLFeaturesandPluginsDirectory() throws IOException {
        block2: {
            File directory = new File(this.tempDirectory, "exists");
            directory.mkdirs();
            File compositeContentXML = new File(directory, "compositeContent.xml");
            compositeContentXML.createNewFile();
            ExtensionLocationArtifactRepositoryFactoryTest.copy("1.0", ExtensionLocationArtifactRepositoryFactoryTest.getTestData("1.1", "/testData/extensionlocation"), directory);
            URI location = directory.toURI();
            try {
                this.factory.load(location, 0, this.getMonitor());
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() != 1000) break block2;
                return;
            }
        }
        ExtensionLocationArtifactRepositoryFactoryTest.fail((String)"1.0");
    }
}

