/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.BundleContext;

public class RepoValidator
extends AbstractProvisioningTest {
    public void testValidate() throws ProvisionException {
        String[] ius;
        BundleContext context = TestActivator.getContext();
        String repositoryString = context.getProperty("org.eclipse.equinox.p2.tests.current.build.repo");
        RepoValidator.assertNotNull((String)"Need set the 'org.eclipse.equinox.p2.tests.current.build.repo' property.", (Object)repositoryString);
        URI repositoryLocation = URI.create(repositoryString);
        IPlanner planner = this.getPlanner(RepoValidator.getAgent());
        RepoValidator.assertNotNull((String)"Unable to aquire IPlanner service.", (Object)planner);
        IMetadataRepositoryManager manager = RepoValidator.getMetadataRepositoryManager();
        RepoValidator.assertNotNull((String)"Unable to aquire IMetadataManager service.", (Object)manager);
        IMetadataRepository repository = manager.loadRepository(repositoryLocation, null);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.os", context.getProperty("osgi.os"));
        properties.put("osgi.ws", context.getProperty("osgi.ws"));
        properties.put("osgi.arch", context.getProperty("osgi.arch"));
        IProfile profile = this.createProfile("repoValidator", properties);
        String[] stringArray = ius = new String[]{"org.eclipse.sdk.ide", "org.eclipse.platform.ide"};
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
            IQueryResult result = repository.query(query, this.getMonitor());
            RepoValidator.assertFalse((String)("SDK IU not found in repository: " + repositoryString), (boolean)result.isEmpty());
            IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
            ProvisioningContext provisioningContext = new ProvisioningContext(RepoValidator.getAgent());
            provisioningContext.setMetadataRepositories(new URI[]{repositoryLocation});
            ProfileChangeRequest req = new ProfileChangeRequest(profile);
            req.setProfileProperty("eclipse.p2.install.features", "true");
            req.addInstallableUnits(new IInstallableUnit[]{iu});
            RepoValidator.assertOK("Cannot resolve: " + iu, planner.getProvisioningPlan((IProfileChangeRequest)req, provisioningContext, null).getStatus());
            ++n2;
        }
    }
}

