/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitPatch;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataParser;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IUPatchPersistenceTest
extends AbstractProvisioningTest {
    private static String PackagesNS = "osgi.packages";
    private static String id = "org.eclipse.osgi.services";
    private static Version version = Version.create((String)"3.1.200.v20070605");
    private static IMatchExpression<IInstallableUnit> filter = InstallableUnit.parseFilter((String)"(& (osgi.ws=win32) (osgi.os=win32) (osgi.arch=x86))");
    private static String[][] properties = new String[][]{{"equinox.p2.name", "OSGi Release 4.0.1 Services"}, {"equinox.p2.description", "OSGi Service Platform Release 4.0.1 Service Interfaces and Classes"}, {"equinox.p2.provider", "Eclipse.org"}, {"equinox.p2.contact", "www.eclipse.org"}, {"equinox.p2.copyright", "Copyright (c) 2003, 2004 IBM Corporation and others. A long-winded copyright notice."}};
    private static String[][] provides = new String[][]{{PackagesNS, "org.osgi.service.cm", "1.2.0"}, {PackagesNS, "org.osgi.service.component", "1.0.0"}, {PackagesNS, "org.osgi.service.device", "1.1.0"}, {PackagesNS, "org.osgi.service.event", "1.1.0"}, {PackagesNS, "org.osgi.service.http", "1.2.0"}, {PackagesNS, "org.osgi.service.io", "1.0.0"}, {PackagesNS, "org.osgi.service.log", "1.3.0"}, {PackagesNS, "org.osgi.service.metatype", "1.1.0"}, {PackagesNS, "org.osgi.service.provisioning", "1.1.0"}, {PackagesNS, "org.osgi.service.upnp", "1.1.0"}, {PackagesNS, "org.osgi.service.useradmin", "1.1.0"}, {PackagesNS, "org.osgi.service.wireadmin", "1.0.0"}};
    private static String[][] requires = new String[][]{{PackagesNS, "javax.servlet", "0.0.0", "true"}, {PackagesNS, "javax.servlet.http", "0.0.0", "true"}, {PackagesNS, "org.osgi.framework", "1.2.0", "false"}};
    private static String[][] metaRequires = new String[][]{{PackagesNS, "some.actions1", "0.0.0", "true"}, {PackagesNS, "some.actions2", "1.2.0", "false"}};
    private static String[][] instructions = new String[][]{{"manifest", "Manifest-Version: 1.0\\Bundle-Vendor: Eclipse.org\\Bundle-ContactAddress: www.eclipse.org\\...a whole bunch of other manifest content..."}, {"zipped", "true"}, {"configure", "addProgramArg(programArg:-startup);addProgramArg(programArg:@artifact);"}};
    private static String IU_TEST_TARGET = "installableUnitTest";
    private static Version IU_TEST_VERSION = Version.create((String)"0.0.1");
    private static String IU_TEST_ELEMENT = "test";

    public static IInstallableUnit createPersistenceTestIU() {
        Map propertyMap = IUPatchPersistenceTest.createProperties(properties);
        IProvidedCapability[] additionalProvides = IUPatchPersistenceTest.createProvided(provides);
        IRequirement[] requirements = IUPatchPersistenceTest.createRequired(requires);
        IRequirement[] metaRequirements = IUPatchPersistenceTest.createRequired(metaRequires);
        ITouchpointData tpData = IUPatchPersistenceTest.createTouchpointData(instructions);
        IUpdateDescriptor update = IUPatchPersistenceTest.createUpdateDescriptor();
        boolean singleton = false;
        IInstallableUnit iu = IUPatchPersistenceTest.createIU(id, version, filter, requirements, additionalProvides, propertyMap, TOUCHPOINT_OSGI, tpData, singleton, update, metaRequirements);
        return iu;
    }

    private static IUpdateDescriptor createUpdateDescriptor() {
        return MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(IU_TEST_VERSION, true, IU_TEST_VERSION, true), (int)1, (String)"desc");
    }

    private static Map createProperties(String[][] keyValuePairs) {
        OrderedProperties props = new OrderedProperties(keyValuePairs.length);
        int i = 0;
        while (i < keyValuePairs.length) {
            String[] nextPair = keyValuePairs[i];
            props.put(nextPair[0], nextPair[1]);
            ++i;
        }
        return props;
    }

    private static IProvidedCapability[] createProvided(String[][] provideTuples) {
        IProvidedCapability[] provided = new IProvidedCapability[provideTuples.length];
        int i = 0;
        while (i < provideTuples.length) {
            String[] nextTuple = provideTuples[i];
            provided[i] = MetadataFactory.createProvidedCapability((String)nextTuple[0], (String)nextTuple[1], (Version)Version.create((String)nextTuple[2]));
            ++i;
        }
        return provided;
    }

    private static IRequirement[] createRequired(String[][] requireTuples) {
        IRequirement[] required = new IRequirement[requireTuples.length];
        int i = 0;
        while (i < requireTuples.length) {
            String[] nextTuple = requireTuples[i];
            required[i] = MetadataFactory.createRequirement((String)nextTuple[0], (String)nextTuple[1], (VersionRange)new VersionRange(nextTuple[2]), null, (boolean)Boolean.parseBoolean(nextTuple[3]), (boolean)false);
            ++i;
        }
        return required;
    }

    private static ITouchpointData createTouchpointData(String[][] instructionData) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(instructionData.length);
        int i = 0;
        while (i < instructionData.length) {
            String[] nextInstruction = instructionData[i];
            map.put(nextInstruction[0], nextInstruction[1]);
            ++i;
        }
        return MetadataFactory.createTouchpointData(map);
    }

    public void testIUPersistence() throws IOException {
        IInstallableUnit iu0 = IUPatchPersistenceTest.createPersistenceTestIU();
        IUPatchPersistenceTest.validateIU(iu0);
        ByteArrayOutputStream output0 = new ByteArrayOutputStream(3072);
        IUStringWriter writer0 = new IUStringWriter(output0);
        writer0.writeTest(iu0);
        String iuText0 = output0.toString();
        output0.close();
        IUStringParser parser = new IUStringParser(TestActivator.context, "org.eclipse.equinox.p2.test");
        parser.parse(iuText0);
        IUPatchPersistenceTest.assertTrue((String)("Error parsing test iu: " + parser.getStatus().getMessage()), (boolean)parser.getStatus().isOK());
        InstallableUnit iu1 = (InstallableUnit)parser.getRootObject();
        IUPatchPersistenceTest.validateIU((IInstallableUnit)iu1);
        ByteArrayOutputStream output1 = new ByteArrayOutputStream(1492);
        IUStringWriter writer = new IUStringWriter(output1);
        writer.writeTest((IInstallableUnit)iu1);
        String iuText1 = output1.toString();
        output1.close();
        IUPatchPersistenceTest.assertTrue((String)"Installable unit write after read after write produced different XML", (boolean)iuText1.equals(iuText0));
    }

    public void testIUPatchPersistence() throws IOException {
        IInstallableUnitPatch iu0 = this.createPatchIU();
        IUPatchPersistenceTest.validateIU((IInstallableUnit)iu0);
        ByteArrayOutputStream output0 = new ByteArrayOutputStream(3072);
        IUStringWriter writer0 = new IUStringWriter(output0);
        writer0.writeTest((IInstallableUnit)iu0);
        String iuText0 = output0.toString();
        output0.close();
        IUStringParser parser = new IUStringParser(TestActivator.context, "org.eclipse.equinox.p2.test");
        parser.parse(iuText0);
        IUPatchPersistenceTest.assertTrue((String)("Error parsing test iu: " + parser.getStatus().getMessage()), (boolean)parser.getStatus().isOK());
        InstallableUnitPatch iu1 = (InstallableUnitPatch)parser.getRootObject();
        IUPatchPersistenceTest.validateIU((IInstallableUnit)iu1);
        IUPatchPersistenceTest.validateIUPatch((IInstallableUnitPatch)iu1);
        ByteArrayOutputStream output1 = new ByteArrayOutputStream(1492);
        IUStringWriter writer = new IUStringWriter(output1);
        writer.writeTest((IInstallableUnit)iu1);
        String iuText1 = output1.toString();
        output1.close();
        IUPatchPersistenceTest.assertTrue((String)"Installable unit write after read after write produced different XML", (boolean)iuText1.equals(iuText0));
    }

    private IInstallableUnitPatch createPatchIU() {
        Map propertyMap = IUPatchPersistenceTest.createProperties(properties);
        IProvidedCapability[] additionalProvides = IUPatchPersistenceTest.createProvided(provides);
        IRequirement[] requirements = IUPatchPersistenceTest.createRequired(requires);
        IRequirement[] metaRequirements = IUPatchPersistenceTest.createRequired(metaRequires);
        ITouchpointData tpData = IUPatchPersistenceTest.createTouchpointData(instructions);
        IUpdateDescriptor update = IUPatchPersistenceTest.createUpdateDescriptor();
        boolean singleton = false;
        IRequirementChange change1 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirementChange change2 = MetadataFactory.createRequirementChange(null, (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirementChange change3 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), null);
        IRequirement[][] scope = new IRequirement[][]{{MetadataFactory.createRequirement((String)"foo", (String)"bar", null, null, (boolean)true, (boolean)true), MetadataFactory.createRequirement((String)"foo", (String)"bar", null, null, (boolean)true, (boolean)true)}, {MetadataFactory.createRequirement((String)"zoo", (String)"far", null, null, (boolean)true, (boolean)true)}};
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"zoo", (String)"x", null, null, (boolean)false, (boolean)false, (boolean)false);
        IInstallableUnitPatch iu = IUPatchPersistenceTest.createIUPatch(id, version, filter, requirements, additionalProvides, propertyMap, TOUCHPOINT_OSGI, tpData, singleton, update, new IRequirementChange[]{change1, change2, change3}, scope, lifeCycle, metaRequirements);
        return iu;
    }

    private static void validateIUPatch(IInstallableUnitPatch iu) {
        IUPatchPersistenceTest.validateIU((IInstallableUnit)iu);
        IUPatchPersistenceTest.assertTrue((iu.getApplicabilityScope() != null ? 1 : 0) != 0);
        IUPatchPersistenceTest.assertTrue((iu.getRequirements() != null ? 1 : 0) != 0);
        IUPatchPersistenceTest.assertEquals((int)3, (int)iu.getRequirementsChange().size());
        IUPatchPersistenceTest.assertEquals(null, (Object)((IRequirementChange)iu.getRequirementsChange().get(1)).applyOn());
        IUPatchPersistenceTest.assertNotNull((Object)((IRequirementChange)iu.getRequirementsChange().get(1)).newValue());
        IUPatchPersistenceTest.assertEquals(null, (Object)((IRequirementChange)iu.getRequirementsChange().get(2)).newValue());
        IUPatchPersistenceTest.assertNotNull((Object)((IRequirementChange)iu.getRequirementsChange().get(2)).applyOn());
        IUPatchPersistenceTest.assertEquals((int)2, (int)iu.getApplicabilityScope().length);
        IUPatchPersistenceTest.assertEquals((int)2, (int)iu.getApplicabilityScope()[0].length);
        IUPatchPersistenceTest.assertEquals((int)1, (int)iu.getApplicabilityScope()[1].length);
        IUPatchPersistenceTest.assertNotNull((Object)iu.getLifeCycle());
    }

    private static void validateIU(IInstallableUnit iu) {
        IUPatchPersistenceTest.assertTrue((String)"Installable unit id is not correct", (boolean)id.equals(iu.getId()));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit version is not correct", (boolean)version.equals(iu.getVersion()));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit filter is not correct", (boolean)filter.equals((Object)iu.getFilter()));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit properties are not correct", (boolean)IUPatchPersistenceTest.equal(properties, IUPatchPersistenceTest.extractProperties(iu)));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit provided capabilities are not correct", (boolean)IUPatchPersistenceTest.equal(IUPatchPersistenceTest.addSelfCapability(iu, provides), IUPatchPersistenceTest.extractProvides(iu)));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit required capabilities are not correct", (boolean)IUPatchPersistenceTest.equal(requires, IUPatchPersistenceTest.extractRequires(iu)));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit meta required capabilities are not correct", (boolean)IUPatchPersistenceTest.equal(metaRequires, IUPatchPersistenceTest.extractMetaRequires(iu)));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit update descriptor are not correct", (boolean)id.equals(RequiredCapability.extractName((IMatchExpression)((IMatchExpression)iu.getUpdateDescriptor().getIUsBeingUpdated().iterator().next()))));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit update descriptor are not correct", (1 == iu.getUpdateDescriptor().getSeverity() ? 1 : 0) != 0);
        IUPatchPersistenceTest.assertTrue((String)"Installable unit update descriptor are not correct", (boolean)"desc".equals(iu.getUpdateDescriptor().getDescription()));
        IUPatchPersistenceTest.assertTrue((String)"Installable unit update descriptor are not correct", (boolean)new VersionRange(IU_TEST_VERSION, true, IU_TEST_VERSION, true).equals((Object)RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)iu.getUpdateDescriptor().getIUsBeingUpdated().iterator().next()))));
    }

    private static String[][] extractProperties(IInstallableUnit iu) {
        Map props = iu.getProperties();
        Set keys = props.keySet();
        String[][] pairs = new String[keys.size()][2];
        int index = 0;
        for (String nextKey : keys) {
            String nextValue = (String)props.get(nextKey);
            pairs[index] = new String[]{nextKey, nextValue};
            ++index;
        }
        return pairs;
    }

    private static String[][] addSelfCapability(IInstallableUnit iu, String[][] provideTuples) {
        String[][] augmentedProvides = new String[provideTuples.length + 1][3];
        IProvidedCapability self = IUPatchPersistenceTest.getSelfCapability(iu);
        augmentedProvides[0] = new String[]{self.getNamespace(), self.getName(), self.getVersion().toString()};
        int i = 0;
        while (i < provideTuples.length) {
            augmentedProvides[i + 1] = provideTuples[i];
            ++i;
        }
        return augmentedProvides;
    }

    private static String[][] extractProvides(IInstallableUnit iu) {
        Collection provydes = iu.getProvidedCapabilities();
        String[][] tuples = new String[provydes.size()][3];
        int i = 0;
        for (IProvidedCapability capability : provydes) {
            tuples[i++] = new String[]{capability.getNamespace(), capability.getName(), capability.getVersion().toString()};
        }
        return tuples;
    }

    private static String[][] extractRequires(IInstallableUnit iu) {
        Collection reqs = iu.getRequirements();
        String[][] tuples = new String[reqs.size()][4];
        int i = 0;
        for (IRequiredCapability next : reqs) {
            tuples[i++] = new String[]{next.getNamespace(), next.getName(), next.getRange().toString(), Boolean.valueOf(next.getMin() == 0).toString()};
        }
        return tuples;
    }

    private static String[][] extractMetaRequires(IInstallableUnit iu) {
        Collection requyres = iu.getMetaRequirements();
        String[][] tuples = new String[requyres.size()][4];
        int i = 0;
        for (IRequiredCapability next : requyres) {
            tuples[i++] = new String[]{next.getNamespace(), next.getName(), next.getRange().toString(), Boolean.valueOf(next.getMin() == 0).toString()};
        }
        return tuples;
    }

    class IUStringParser
    extends MetadataParser {
        private IInstallableUnit theIU;

        public IUStringParser(BundleContext context, String bundleId) {
            super(context, bundleId);
            this.theIU = null;
        }

        public void parse(String profileString) throws IOException {
            this.status = null;
            try {
                this.getParser();
                TestHandler testHandler = new TestHandler();
                this.xmlReader.setContentHandler((ContentHandler)((Object)new IUDocHandler(IU_TEST_ELEMENT, testHandler)));
                this.xmlReader.parse(new InputSource(new StringReader(profileString)));
                if (this.isValidXML()) {
                    this.theIU = testHandler.getIU();
                }
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                IUPatchPersistenceTest.fail();
            }
        }

        protected String getErrorMessage() {
            return "Error parsing installable unit string";
        }

        protected Object getRootObject() {
            return this.theIU;
        }

        private final class IUDocHandler
        extends XMLParser.DocHandler {
            public IUDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)IUStringParser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                if (IU_TEST_TARGET.equals(target)) {
                    Version iuTestVersion = IUStringParser.this.extractPIVersion(target, data);
                    if (!IU_TEST_VERSION.equals(iuTestVersion)) {
                        throw new SAXException("Bad iu test version.");
                    }
                }
            }
        }

        private final class TestHandler
        extends XMLParser.RootHandler {
            private MetadataParser.InstallableUnitHandler iuHandler;
            private InstallableUnit iu;
            private List singleton;

            public TestHandler() {
                super((XMLParser)IUStringParser.this);
                this.iuHandler = null;
                this.iu = null;
                this.singleton = new ArrayList(1);
            }

            public InstallableUnit getIU() {
                return this.iu;
            }

            protected void handleRootAttributes(Attributes attributes) {
                this.parseAttributes(attributes, noAttributes, noAttributes);
            }

            public void startElement(String name, Attributes attributes) {
                if ("unit".equals(name)) {
                    if (this.iuHandler == null) {
                        this.iuHandler = new MetadataParser.InstallableUnitHandler((MetadataParser)IUStringParser.this, (XMLParser.AbstractHandler)this, attributes, this.singleton);
                    } else {
                        IUStringParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (IUStringParser.this.isValidXML() && this.iuHandler != null && this.singleton.size() == 1) {
                    this.iu = (InstallableUnit)this.iuHandler.getInstallableUnit();
                }
            }
        }
    }

    class IUStringWriter
    extends MetadataWriter {
        public IUStringWriter(ByteArrayOutputStream stream) throws IOException {
            super((OutputStream)stream, new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)IU_TEST_TARGET, (Version)IU_TEST_VERSION)});
        }

        public void writeTest(IInstallableUnit iu) {
            this.start(IU_TEST_ELEMENT);
            this.writeInstallableUnit(iu);
            this.end(IU_TEST_ELEMENT);
            this.flush();
        }
    }
}

