/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.equinox.p2.metadata.expression.ExpressionParseException;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class FilterTest
extends TestCase {
    static final int ISTRUE = 1;
    static final int ISFALSE = 2;
    static final int ISILLEGAL = 3;

    public static Test suite() {
        return new TestSuite(FilterTest.class);
    }

    public void testComparable() throws Exception {
        IFilterExpression f1 = ExpressionUtil.parseLDAP((String)"(comparable=42)");
        Map<String, SampleComparable> hash = new HashMap<String, SampleComparable>();
        Comparable comp = new SampleComparable("42");
        hash.put("comparable", (SampleComparable)comp);
        FilterTest.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTest.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        comp = Long.valueOf(42L);
        hash.put("comparable", (SampleComparable)comp);
        FilterTest.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTest.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        IFilterExpression f2 = ExpressionUtil.parseLDAP((String)"(comparable=42)");
        hash = new Hashtable();
        comp = new SampleComparable("42");
        hash.put("comparable", (SampleComparable)comp);
        FilterTest.assertTrue((String)"does not match filter", (boolean)f2.match(hash));
        FilterTest.assertTrue((String)"does not match filter", (boolean)f2.match((ServiceReference)new DictionaryServiceReference(hash)));
        comp = Long.valueOf(42L);
        hash.put("comparable", (SampleComparable)comp);
        FilterTest.assertTrue((String)"does not match filter", (boolean)f2.match(hash));
        FilterTest.assertTrue((String)"does not match filter", (boolean)f2.match((ServiceReference)new DictionaryServiceReference(hash)));
        FilterTest.assertEquals((String)"not equal", (Object)f1, (Object)f2);
    }

    public void testFilter() {
        Properties props = new Properties();
        props.put("room", "bedroom");
        props.put("channel", (Object)34);
        props.put("status", "(on\\)*");
        props.put("max record time", (Object)150L);
        props.put("canrecord", "true(x)");
        props.put("shortvalue", (Object)1000);
        props.put("bytevalue", (Object)10);
        props.put("floatvalue", Float.valueOf(1.01f));
        props.put("doublevalue", (Object)2.01);
        props.put("charvalue", Character.valueOf('A'));
        props.put("booleanvalue", Boolean.FALSE);
        props.put("weirdvalue", new Hashtable());
        try {
            props.put("bigintvalue", new BigInteger("4123456"));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        try {
            props.put("bigdecvalue", new BigDecimal("4.123456"));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        this.testFilter("(room=*)", props, 1);
        this.testFilter("(rooom=*)", props, 2);
        this.testFilter("(room=bedroom)", props, 1);
        this.testFilter("(room~= B E D R O O M )", props, 1);
        this.testFilter("(room=abc)", props, 2);
        this.testFilter(" ( room >=aaaa)", props, 1);
        this.testFilter("(room <=aaaa)", props, 2);
        this.testFilter("  ( room =b*) ", props, 1);
        this.testFilter("  ( room =*m) ", props, 1);
        this.testFilter("(room=bed*room)", props, 1);
        this.testFilter("  ( room =b*oo*m) ", props, 1);
        this.testFilter("  ( room =*b*oo*m*) ", props, 1);
        this.testFilter("  ( room =b*b*  *m*) ", props, 2);
        this.testFilter("  (& (room =bedroom) (channel = 34))", props, 1);
        this.testFilter("  (&  (room =b*)  (room =*x) (channel=34))", props, 2);
        this.testFilter("(| (room =bed*)(channel=222)) ", props, 1);
        this.testFilter("(| (room =boom*)(channel=34)) ", props, 1);
        this.testFilter("  (! (room =ab*b*oo*m*) ) ", props, 1);
        this.testFilter("  (status =\\(o*\\\\\\)\\*) ", props, 1);
        this.testFilter("  (status =\\28o*\\5c\\29\\2a) ", props, 1);
        this.testFilter("  (status =\\28o*\\5C\\29\\2A) ", props, 1);
        this.testFilter("  (canRecord =true\\(x\\)) ", props, 1);
        this.testFilter("(max Record Time <=150) ", props, 1);
        this.testFilter("(shortValue >= 100) ", props, 1);
        this.testFilter("  (  &  (  byteValue <= 100  )  (  byteValue >= 10  )  )  ", props, 1);
        this.testFilter("(bigIntValue = 4123456) ", props, 1);
        this.testFilter("(bigDecValue = 4.123456) ", props, 1);
        this.testFilter("(floatValue >= 1.0) ", props, 1);
        this.testFilter("(doubleValue <= 2.011) ", props, 1);
        this.testFilter("(charValue ~= a) ", props, 1);
        this.testFilter("(booleanValue = false) ", props, 1);
        this.testFilter("(& (| (room =d*m) (room =bed*) (room=abc)) (! (channel=999)))", props, 1);
        this.testFilter("(room=bedroom)", null, 2);
        this.testFilter("()", props, 3);
        this.testFilter("(=foo)", props, 3);
        this.testFilter("(", props, 3);
        this.testFilter("(abc = ))", props, 3);
        this.testFilter("(& (abc = xyz) (& (345))", props, 3);
        this.testFilter("  (room = b**oo!*m*) ) ", props, 3);
        this.testFilter("  (room = b**oo)*m*) ) ", props, 3);
        this.testFilter("  (room = *=b**oo*m*) ) ", props, 3);
        this.testFilter("  (room = =b**oo*m*) ) ", props, 3);
        try {
            IFilterExpression f1 = ExpressionUtil.parseLDAP((String)"( a = bedroom  )");
            IFilterExpression f2 = ExpressionUtil.parseLDAP((String)" (a= bedroom  ) ");
            FilterTest.assertEquals((String)"not equal", (String)"(a= bedroom  )", (String)f1.toString());
            FilterTest.assertEquals((String)"not equal", (String)"(a= bedroom  )", (String)f2.toString());
            FilterTest.assertEquals((String)"not equal", (Object)f1, (Object)f2);
            FilterTest.assertEquals((String)"not equal", (Object)f2, (Object)f1);
            FilterTest.assertEquals((String)"not equal", (int)f1.hashCode(), (int)f2.hashCode());
            f1 = ExpressionUtil.parseLDAP((String)"(status =\\28o*\\5c\\29\\2a)");
            FilterTest.assertEquals((String)"not equal", (String)"(status=\\28o*\\5c\\29\\2a)", (String)f1.toString());
            f1 = ExpressionUtil.parseLDAP((String)"(|(a=1)(&(a=1)(b=1)))");
            f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
            System.out.println(f2.toString());
            System.out.println(f1.toString());
            f1 = ExpressionUtil.parseLDAP((String)"(|(&(os=macos)(ws=cocoa)(arch=x86))(&(ws=cocoa)(os=macos)(arch=ppc)))");
            f2 = ExpressionUtil.parseLDAP((String)"(&(os=macos)(ws=cocoa)(|(arch=x86)(arch=ppc)))");
            System.out.println(f2.toString());
            System.out.println(f1.toString());
            FilterTest.assertEquals((String)"not equal", (Object)f1, (Object)f2);
            f1 = ExpressionUtil.parseLDAP((String)"(&(|(x=a)(y=b)(z=a))(|(x=a)(y=b)(z=b)))");
            f2 = ExpressionUtil.parseLDAP((String)"(|(x=a)(y=b)(&(z=a)(z=b)))");
            System.out.println(f2.toString());
            System.out.println(f1.toString());
            FilterTest.assertEquals((String)"not equal", (Object)f1, (Object)f2);
            f1 = ExpressionUtil.parseLDAP((String)"(&(a=1)(|(a=1)(b=1)))");
            f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
            System.out.println(f2.toString());
            System.out.println(f1.toString());
            f1 = ExpressionUtil.parseLDAP((String)"(|(a=1)(&(a=1)(b=1)))");
            f2 = ExpressionUtil.parseLDAP((String)"(a=1)");
            System.out.println(f2.toString());
            System.out.println(f1.toString());
            FilterTest.assertEquals((String)"not equal", (Object)f1, (Object)f2);
        }
        catch (IllegalArgumentException e) {
            FilterTest.fail((String)("unexpected invalid syntax: " + e));
        }
        this.testFilter("(weirdValue = 100) ", props, 2);
    }

    private void testFilter(String query, Dictionary<?, ?> props, int expect) {
        IFilterExpression f1;
        DictionaryServiceReference ref = new DictionaryServiceReference((Map)((Object)props));
        try {
            f1 = ExpressionUtil.parseLDAP((String)query);
            if (expect == 3) {
                FilterTest.fail((String)"expected exception");
            }
        }
        catch (ExpressionParseException e) {
            System.out.println(e.toString());
            if (expect != 3) {
                FilterTest.fail((String)("exception: " + e.toString()));
            }
            return;
        }
        boolean val = f1.match(props);
        FilterTest.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
        val = f1.match((ServiceReference)ref);
        FilterTest.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
    }

    private static class DictionaryServiceReference
    implements ServiceReference {
        private final Map<String, ? extends Object> dictionary;
        private final String[] keys;

        DictionaryServiceReference(Map<String, ? extends Object> dictionary) {
            if (dictionary == null) {
                this.dictionary = null;
                this.keys = new String[0];
                return;
            }
            this.dictionary = dictionary;
            ArrayList<String> keyList = new ArrayList<String>(dictionary.size());
            for (String key : dictionary.keySet()) {
                Iterator i = keyList.iterator();
                while (i.hasNext()) {
                    if (!key.equalsIgnoreCase((String)i.next())) continue;
                    throw new IllegalArgumentException();
                }
                keyList.add(key);
            }
            this.keys = keyList.toArray(new String[keyList.size()]);
        }

        public int compareTo(Object reference) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            return null;
        }

        public Object getProperty(String k) {
            int i = 0;
            int length = this.keys.length;
            while (i < length) {
                String key = this.keys[i];
                if (key.equalsIgnoreCase(k)) {
                    return this.dictionary.get(key);
                }
                ++i;
            }
            return null;
        }

        public String[] getPropertyKeys() {
            return (String[])this.keys.clone();
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SampleComparable
    implements Comparable {
        private int value = -1;

        public SampleComparable(String value) {
            this.value = Integer.parseInt(value);
        }

        public boolean equals(Object o) {
            return o instanceof SampleComparable && this.value == ((SampleComparable)o).value;
        }

        public int compareTo(Object o) {
            return this.value - ((SampleComparable)o).value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

