/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.io.IUDeserializer;
import org.eclipse.equinox.p2.metadata.io.IUSerializer;

public class StandaloneSerializationTest
extends TestCase {
    public void testNothingToWrite() {
        try {
            File f = File.createTempFile(this.getName(), "iu");
            FileOutputStream os = new FileOutputStream(f);
            new IUSerializer((OutputStream)os).write((Collection)Collections.EMPTY_LIST);
            ((OutputStream)os).close();
            StandaloneSerializationTest.assertTrue((f.length() > 0L ? 1 : 0) != 0);
            f.delete();
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
    }

    public void testNoContent() {
        File f = null;
        try {
            f = File.createTempFile(this.getName(), "iu");
            FileOutputStream os = new FileOutputStream(f);
            new IUSerializer((OutputStream)os).write((Collection)Collections.EMPTY_LIST);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        boolean exceptionRaised = false;
        try {
            FileInputStream is = new FileInputStream(f);
            Collection ius = new IUDeserializer().read((InputStream)is);
            StandaloneSerializationTest.assertEquals((int)0, (int)ius.size());
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException iOException) {
            exceptionRaised = true;
        }
        StandaloneSerializationTest.assertTrue((boolean)exceptionRaised);
        f.delete();
    }

    /*
     * Loose catch block
     */
    public void testWritingThenLoading() {
        block22: {
            MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
            iu.setId("foo");
            iu.setVersion(Version.create((String)"1.0.0"));
            MetadataFactory.InstallableUnitDescription iu2 = new MetadataFactory.InstallableUnitDescription();
            iu2.setId("bar");
            iu2.setVersion(Version.create((String)"1.0.0"));
            ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
            ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
            ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu2));
            File f = null;
            try {
                f = File.createTempFile(this.getName(), "iu");
                FileOutputStream os = new FileOutputStream(f);
                new IUSerializer((OutputStream)os).write(ius);
                ((OutputStream)os).close();
            }
            catch (FileNotFoundException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
            }
            catch (UnsupportedEncodingException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
            }
            catch (IOException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
            }
            InputStream is = null;
            try {
                is = new FileInputStream(f);
                StandaloneSerializationTest.assertEquals((int)2, (int)new IUDeserializer().read(is).size());
            }
            catch (FileNotFoundException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                try {
                    is.close();
                    f.delete();
                }
                catch (IOException iOException) {}
                break block22;
            }
            catch (UnsupportedEncodingException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                try {
                    is.close();
                    f.delete();
                }
                catch (IOException iOException) {}
                break block22;
            }
            catch (IOException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                {
                    catch (Throwable throwable) {
                        try {
                            is.close();
                            f.delete();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    is.close();
                    f.delete();
                }
                catch (IOException iOException) {}
                break block22;
            }
            try {
                is.close();
                f.delete();
            }
            catch (IOException iOException) {}
        }
    }
}

