/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;

public class ArtifactRepositoryCleanupTest
extends AbstractProvisioningTest {
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File bystanderRepoLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = ArtifactRepositoryCleanupTest.getTestData("1.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.bystanderRepoLocation = ArtifactRepositoryCleanupTest.getTestData("2.0", "/testData/mirror/mirrorSourceRepo2");
        String tempDir = System.getProperty("java.io.tmpdir");
        this.destRepoLocation = new File(tempDir, "BasicMirrorApplicationTest");
        AbstractProvisioningTest.delete(this.destRepoLocation);
    }

    @Override
    protected void tearDown() throws Exception {
        ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().removeRepository(this.bystanderRepoLocation.toURI());
        ArtifactRepositoryCleanupTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private void runMirrorApplication(File source, File destination, boolean append) throws Exception {
        MirrorApplication application = new MirrorApplication();
        String[] args = new String[]{"-source", source.toURL().toExternalForm(), "-destination", destination.toURL().toExternalForm(), append ? "-append" : ""};
        application.initializeFromArguments(args);
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            application.run(null);
        }
        finally {
            System.setOut(out);
        }
    }

    public void testArtifactMirrorRemovesRepos() {
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("1.0", e);
        }
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithSourceLoaded() {
        try {
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("2.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("2.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithDestinationLoaded() {
        try {
            String repositoryName = this.destRepoLocation.toURI() + " - artifacts";
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("3.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("3.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithBothLoaded() {
        try {
            String repositoryName = this.destRepoLocation.toURI() + " - artifacts";
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("4.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("4.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithBystanderLoaded() {
        try {
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("5.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("5.2", e);
        }
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithSourceAndBystanderLoaded() {
        try {
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("6.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("6.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithDestinationAndBystanderLoaded() {
        try {
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            String repositoryName = this.destRepoLocation.toURI() + " - artifacts";
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("7.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("7.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertFalse((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testArtifactMirrorRemovesReposWithBothAndBystanderLoaded() {
        try {
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            String repositoryName = this.destRepoLocation.toURI() + " - artifacts";
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryCleanupTest.fail("8.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            ArtifactRepositoryCleanupTest.fail("8.2", e);
        }
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.destRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        ArtifactRepositoryCleanupTest.assertTrue((boolean)ArtifactRepositoryCleanupTest.getArtifactRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }
}

