/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.osgi.util.NLS;

public class NewMirrorApplicationMetadataTest
extends AbstractProvisioningTest {
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File sourceRepo2Location;
    protected File sourceRepo3Location;
    protected File sourceRepo4Location;
    protected File sourceRepoWithRefs;
    protected Exception exception = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = NewMirrorApplicationMetadataTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.sourceRepo2Location = NewMirrorApplicationMetadataTest.getTestData("0.1", "/testData/mirror/mirrorSourceRepo2");
        this.sourceRepo3Location = NewMirrorApplicationMetadataTest.getTestData("0.2", "/testData/mirror/mirrorSourceRepo3");
        this.sourceRepo4Location = NewMirrorApplicationMetadataTest.getTestData("0.3", "/testData/mirror/mirrorSourceRepo4");
        this.sourceRepoWithRefs = NewMirrorApplicationMetadataTest.getTestData("0.4", "/testData/mirror/mirrorSourceRepoWithRefs");
        this.destRepoLocation = new File(this.getTempFolder(), "BasicMirrorApplicationTest");
        AbstractProvisioningTest.delete(this.destRepoLocation);
    }

    @Override
    protected void tearDown() throws Exception {
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo2Location.toURI());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo3Location.toURI());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo4Location.toURI());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(this.sourceRepoWithRefs.toURI());
        this.exception = null;
        NewMirrorApplicationMetadataTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private void basicRunMirrorApplication(String message, URL source, URL destination, boolean append) throws Exception {
        MirrorApplication app = new MirrorApplication();
        if (destination != null) {
            RepositoryDescriptor dest = new RepositoryDescriptor();
            dest.setLocation(URIUtil.fromString((String)destination.toExternalForm()));
            dest.setAppend(append);
            dest.setKind("metadata");
            app.addDestination(dest);
        }
        if (source != null) {
            RepositoryDescriptor src = new RepositoryDescriptor();
            src.setLocation(URIUtil.fromString((String)source.toExternalForm()));
            src.setKind("metadata");
            app.addSource(src);
        }
        app.run(null);
    }

    private void basicRunMirrorApplication(String message, URL source, URL destination, boolean append, String name) throws Exception {
        MirrorApplication app = new MirrorApplication();
        if (destination != null) {
            RepositoryDescriptor dest = new RepositoryDescriptor();
            dest.setLocation(URIUtil.fromString((String)destination.toExternalForm()));
            dest.setAppend(append);
            dest.setKind("metadata");
            dest.setName(name);
            app.addDestination(dest);
        }
        if (source != null) {
            RepositoryDescriptor src = new RepositoryDescriptor();
            src.setLocation(URIUtil.fromString((String)source.toExternalForm()));
            src.setKind("metadata");
            app.addSource(src);
        }
        app.run(null);
    }

    private void runMirrorApplication(String message, File source, File destination, boolean append) {
        try {
            this.basicRunMirrorApplication(message, source.toURL(), destination.toURL(), append);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail(message, e);
        }
    }

    private int getNumUnique(IQueryResult c1, IQueryResult c2) {
        Object[] repo1 = c1.toArray(IInstallableUnit.class);
        Object[] repo2 = c2.toArray(IInstallableUnit.class);
        int numKeys = repo1.length + repo2.length;
        int i = 0;
        while (i < repo1.length) {
            int j = 0;
            while (j < repo2.length) {
                if (NewMirrorApplicationMetadataTest.isEqual((IInstallableUnit)repo1[i], (IInstallableUnit)repo2[j])) {
                    --numKeys;
                }
                ++j;
            }
            ++i;
        }
        return numKeys;
    }

    private void metadataMirrorToEmpty(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulatedWithFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo3Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulatedWithPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, true);
        try {
            NewMirrorApplicationMetadataTest.assertContains(String.valueOf(message) + ".5", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains(String.valueOf(message) + ".6", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".7", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".7", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private File metadataMirrorEmpty(String message, boolean append) {
        File emptyRepository = new File(this.getTempFolder(), NewMirrorApplicationMetadataTest.getUniqueString());
        NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
        AbstractProvisioningTest.delete(emptyRepository);
        try {
            NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(emptyRepository.toURI(), "Empty Repository", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail(String.valueOf(message) + ".1", e);
        }
        try {
            this.basicRunMirrorApplication(String.valueOf(message) + ".0", emptyRepository.toURL(), this.destRepoLocation.toURL(), append);
        }
        catch (Exception e) {
            this.exception = e;
        }
        return emptyRepository;
    }

    private File metadataMirrorEmptyToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        return this.metadataMirrorEmpty(String.valueOf(message) + ".1", append);
    }

    public void testMetadataMirrorToEmpty() {
        this.metadataMirrorToEmpty("1.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("1.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("1.2", e);
        }
    }

    public void testMetadataMirrorToEmptyWithClean() {
        this.metadataMirrorToEmpty("2.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("2.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("2.2", e);
        }
    }

    public void testMetadataMirrorToFullDuplicate() {
        this.metadataMirrorToFullDuplicate("3.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("3.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("3.2", e);
        }
    }

    public void testMetadataMirrorToFullDuplicateWithClean() {
        this.metadataMirrorToFullDuplicate("4.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("4.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("4.2", e);
        }
    }

    public void testMetadataMirrorToPopulated() {
        this.metadataMirrorToPopulated("5.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContains("5.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains("5.2", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertEquals((String)"5.3", (int)this.getNumUnique(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)NewMirrorApplicationMetadataTest.queryResultSize(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("5.4", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithClean() {
        this.metadataMirrorToPopulated("6.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("6.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("6.2", e);
        }
    }

    public void testMetadataMirrorToPartialDuplicate() {
        this.metadataMirrorToPartialDuplicate("7.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("7.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("7.2", e);
        }
    }

    public void testMetadataMirrorToPartialDuplicateWithClean() {
        this.metadataMirrorToPartialDuplicate("8.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("8.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("8.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithFullDuplicate() {
        this.metadataMirrorToPopulatedWithFullDuplicate("9.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("9.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("9.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithFullDuplicateWithClean() {
        this.metadataMirrorToPopulatedWithFullDuplicate("10.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("10.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("10.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithPartialDuplicate() {
        this.metadataMirrorToPopulatedWithPartialDuplicate("11.0", true);
        try {
            NewMirrorApplicationMetadataTest.assertContains("11.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains("11.2", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertEquals((String)"11.3", (int)this.getNumUnique(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)NewMirrorApplicationMetadataTest.queryResultSize(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("11.4", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithPartialDuplicateWithClean() {
        this.metadataMirrorToPopulatedWithPartialDuplicate("12.0", false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("12.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("12.2", e);
        }
    }

    public void testMetadataMirrorFromInvalid() {
        File invalidRepository = new File(this.getTempFolder(), NewMirrorApplicationMetadataTest.getUniqueString());
        NewMirrorApplicationMetadataTest.delete(invalidRepository);
        try {
            this.basicRunMirrorApplication("13.1", invalidRepository.toURL(), this.destRepoLocation.toURL(), true);
            NewMirrorApplicationMetadataTest.fail((String)"13.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("13.2", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testMetadataMirrorToInvalid() {
        URI invalidDestRepository = null;
        try {
            try {
                invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
                this.basicRunMirrorApplication("14.1", this.sourceRepoLocation.toURL(), invalidDestRepository.toURL(), true);
                NewMirrorApplicationMetadataTest.fail((String)"14.0 IllegalStateExpection not thrown");
                return;
            }
            catch (ProvisionException e) {
                NewMirrorApplicationMetadataTest.assertEquals((String)"Unexpected error message", (String)NLS.bind((String)Messages.exception_invalidDestination, (Object)URIUtil.toUnencodedString((URI)invalidDestRepository)), (String)e.getMessage());
                if (invalidDestRepository == null) return;
                NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(invalidDestRepository);
                return;
            }
            catch (Exception e) {
                NewMirrorApplicationMetadataTest.fail("14.1", e);
                if (invalidDestRepository == null) return;
                NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(invalidDestRepository);
                return;
            }
        }
        finally {
            if (invalidDestRepository != null) {
                NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(invalidDestRepository);
            }
        }
    }

    public void testMetadataMirrorBothInvalid() {
        File invalidRepository = new File(this.getTempFolder(), NewMirrorApplicationMetadataTest.getUniqueString());
        NewMirrorApplicationMetadataTest.delete(invalidRepository);
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("15.1", invalidRepository.toURL(), invalidDestRepository.toURL(), true);
            NewMirrorApplicationMetadataTest.fail((String)"15.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("15.2", e);
        }
    }

    public void testMetadataMirrorEmptyToEmpty() {
        File emptyRepository = null;
        try {
            emptyRepository = this.metadataMirrorEmptyToPopulated("19.0", false);
            NewMirrorApplicationMetadataTest.assertTrue((String)"Unexpected exception type", (boolean)(this.exception instanceof ProvisionException));
            try {
                NewMirrorApplicationMetadataTest.assertContentEquals("16.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            }
            catch (ProvisionException e) {
                NewMirrorApplicationMetadataTest.fail("16.2", e);
            }
        }
        finally {
            if (emptyRepository != null) {
                NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
                NewMirrorApplicationMetadataTest.delete(emptyRepository);
            }
        }
    }

    public void testArtifactMirrorEmptyToPopulated() {
        File emptyRepository = null;
        try {
            emptyRepository = this.metadataMirrorEmptyToPopulated("17.0", true);
            NewMirrorApplicationMetadataTest.assertTrue((String)"Unexpected exception type", (boolean)(this.exception instanceof ProvisionException));
            try {
                NewMirrorApplicationMetadataTest.assertContains("17.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
                NewMirrorApplicationMetadataTest.assertContentEquals("17.2", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            }
            catch (ProvisionException e) {
                NewMirrorApplicationMetadataTest.fail("17.3", e);
            }
        }
        finally {
            if (emptyRepository != null) {
                NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
                NewMirrorApplicationMetadataTest.delete(emptyRepository);
            }
        }
    }

    public void testArtifactMirrorEmptyToPopulatedWithClean() {
        File emptyRepository = null;
        try {
            emptyRepository = this.metadataMirrorEmptyToPopulated("18.0", false);
            NewMirrorApplicationMetadataTest.assertTrue((String)"Unexpected exception type", (boolean)(this.exception instanceof ProvisionException));
            try {
                NewMirrorApplicationMetadataTest.assertContentEquals("18.1", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            }
            catch (ProvisionException e) {
                NewMirrorApplicationMetadataTest.fail("18.2", e);
            }
        }
        finally {
            NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
            NewMirrorApplicationMetadataTest.delete(emptyRepository);
        }
    }

    public void testArtifactMirrorSourceIsDestination() {
        this.runMirrorApplication("19.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("19.1", this.destRepoLocation, this.destRepoLocation, true);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("19.2", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("19.3", e);
        }
    }

    public void testArtifactMirrorDifferentVersions() {
        this.runMirrorApplication("20.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("20.1", this.sourceRepo4Location, this.destRepoLocation, true);
        try {
            NewMirrorApplicationMetadataTest.assertContains("20.2", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains("20.3", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertEquals((String)"20.4", (int)this.getNumUnique(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)NewMirrorApplicationMetadataTest.queryResultSize(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("20.5", e);
        }
    }

    public void testArtifactMirrorNullSource() {
        try {
            this.basicRunMirrorApplication("21.1", null, this.destRepoLocation.toURL(), true);
            NewMirrorApplicationMetadataTest.fail((String)"21.3 IllegalStateException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("21.2", e);
        }
    }

    public void testArtifactMirrorNullDestination() {
        try {
            this.basicRunMirrorApplication("21.1", this.sourceRepoLocation.toURL(), null, true);
            NewMirrorApplicationMetadataTest.fail((String)"22.3 IllegalStateException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("22.2", e);
        }
    }

    public void testArtifactMirrorNullBoth() {
        try {
            this.basicRunMirrorApplication("23.0", null, null, true);
            NewMirrorApplicationMetadataTest.fail((String)"23.2 IllegalStateException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("23.1", e);
        }
    }

    public void testExistingArtifactRepoProperties() {
        String name = "Destination Name";
        Map properties = null;
        try {
            properties = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties).getProperties();
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("25.0", e);
        }
        this.metadataMirrorToEmpty("25.2", true);
        try {
            IMetadataRepository repository = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            NewMirrorApplicationMetadataTest.assertEquals((String)"25.3", (String)name, (String)repository.getName());
            NewMirrorApplicationMetadataTest.assertRepositoryProperties("25.4", properties, repository.getProperties());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("25.5", e);
        }
    }

    public void testNewArtifactRepoWithNewName() {
        String name = "Bug 256909 test - new";
        try {
            this.basicRunMirrorApplication("Bug 256909 Test", this.sourceRepoLocation.toURL(), this.destRepoLocation.toURL(), false, name);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationMetadataTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("Error running mirror application", e);
        }
        try {
            NewMirrorApplicationMetadataTest.assertEquals((String)"Assert name was set correct", (String)name, (String)NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("Cannot obtain destination", e);
        }
    }

    public void testExistingArtifactRepoWithNewName() {
        String oldName = "The original naem for Bug 256909 test - existing";
        String newName = "Bug 256909 test - existing";
        IMetadataRepository destinationRepo = null;
        try {
            destinationRepo = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), oldName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            NewMirrorApplicationMetadataTest.assertTrue((boolean)destinationRepo.isModifiable());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("Error creating repo at destination", e);
        }
        NewMirrorApplicationMetadataTest.assertEquals((String)"Assert name is set correctly before mirror", (String)oldName, (String)destinationRepo.getName());
        try {
            this.basicRunMirrorApplication("Bug 256809 Test", this.sourceRepoLocation.toURL(), this.destRepoLocation.toURL(), true, newName);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationMetadataTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("Error running mirror application", e);
        }
        try {
            NewMirrorApplicationMetadataTest.assertEquals((String)"Assert name is set correctly after mirror", (String)newName, (String)NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("Error loading destination", e);
        }
    }

    public void testMirrorCompressedSource() {
        File compressedSource = NewMirrorApplicationMetadataTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedMetadataXML = new File(compressedSource.getAbsoluteFile() + "/content.jar");
        NewMirrorApplicationMetadataTest.assertTrue((String)"1", (boolean)compressedMetadataXML.exists());
        try {
            this.basicRunMirrorApplication("2", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationMetadataTest.fail("3", e);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("4", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        NewMirrorApplicationMetadataTest.assertTrue((String)"5", (boolean)destMetadataXML.exists());
    }

    public void testMirrorCompressedSourcetoUncompressedDestination() {
        File compressedSource = NewMirrorApplicationMetadataTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedMetadataXML = new File(compressedSource.getAbsoluteFile() + "/content.jar");
        NewMirrorApplicationMetadataTest.assertTrue((String)"1", (boolean)compressedMetadataXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("2", e);
        }
        try {
            this.basicRunMirrorApplication("3", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationMetadataTest.fail("4", e);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("5", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        NewMirrorApplicationMetadataTest.assertFalse((String)"6", (boolean)destMetadataXML.exists());
        destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.xml");
        NewMirrorApplicationMetadataTest.assertTrue((String)"7", (boolean)destMetadataXML.exists());
    }

    public void testMirrorUncompressedSourceToCompressedDestination() {
        File uncompressedSource = NewMirrorApplicationMetadataTest.getTestData("0", "/testData/mirror/mirrorSourceRepo3");
        File uncompressedContentXML = new File(uncompressedSource.getAbsoluteFile() + "/content.xml");
        NewMirrorApplicationMetadataTest.assertTrue((String)"1", (boolean)uncompressedContentXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("p2.compressed", "true");
            NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", property);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("2", e);
        }
        NewMirrorApplicationMetadataTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "content.jar").exists());
        try {
            this.basicRunMirrorApplication("3", uncompressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationMetadataTest.fail("4", e);
        }
        catch (Exception e) {
            NewMirrorApplicationMetadataTest.fail("5", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        NewMirrorApplicationMetadataTest.assertTrue((String)"6", (boolean)destMetadataXML.exists());
        destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.xml");
        NewMirrorApplicationMetadataTest.assertFalse((String)"7", (boolean)destMetadataXML.exists());
    }

    public void testMirrorApplicationWithCompositeSource() {
        File repoLocation = new File(this.getTempFolder(), "CompositeMetadataMirrorTest");
        AbstractProvisioningTest.delete(repoLocation);
        IMetadataRepository repo = null;
        try {
            repo = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().createRepository(repoLocation.toURI(), "metadata name", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
        }
        catch (ProvisionException provisionException) {
            NewMirrorApplicationMetadataTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeMetadataRepository)) {
            NewMirrorApplicationMetadataTest.fail((String)"Repository is not a CompositeMetadataRepository");
        }
        File child1 = NewMirrorApplicationMetadataTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        File child2 = NewMirrorApplicationMetadataTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        ((CompositeMetadataRepository)repo).addChild(child1.toURI());
        ((CompositeMetadataRepository)repo).addChild(child2.toURI());
        this.runMirrorApplication("Mirroring from Composite Source", repoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationMetadataTest.assertContentEquals("Verifying contents", repo, NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains("3", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertContains("4", NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationMetadataTest.assertEquals((String)"5", (int)this.getNumUnique(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)NewMirrorApplicationMetadataTest.queryResultSize(NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationMetadataTest.fail("Could not load destination", e);
        }
    }

    public void testMirrorReferences() throws Exception {
        MirrorApplication app = new MirrorApplication();
        RepositoryDescriptor dest = new RepositoryDescriptor();
        dest.setLocation(this.destRepoLocation.toURI());
        dest.setAppend(false);
        dest.setKind("metadata");
        app.addDestination(dest);
        RepositoryDescriptor src = new RepositoryDescriptor();
        src.setLocation(this.sourceRepoWithRefs.toURI());
        src.setKind("metadata");
        app.addSource(src);
        app.setReferences(true);
        app.run(null);
        IMetadataRepository destRepo = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
        Collection destRefs = destRepo.getReferences();
        NewMirrorApplicationMetadataTest.assertEquals((int)4, (int)destRefs.size());
    }

    public void testMirrorWithoutReferences() throws Exception {
        MirrorApplication app = new MirrorApplication();
        RepositoryDescriptor dest = new RepositoryDescriptor();
        dest.setLocation(this.destRepoLocation.toURI());
        dest.setAppend(false);
        dest.setKind("metadata");
        app.addDestination(dest);
        RepositoryDescriptor src = new RepositoryDescriptor();
        src.setLocation(this.sourceRepoWithRefs.toURI());
        src.setKind("metadata");
        app.addSource(src);
        app.setReferences(false);
        app.run(null);
        IMetadataRepository destRepo = NewMirrorApplicationMetadataTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
        Collection destRefs = destRepo.getReferences();
        NewMirrorApplicationMetadataTest.assertEquals((int)0, (int)destRefs.size());
    }
}

