/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatProcessingTest
extends TestCase {
    public void testIgnore() {
        Version v = Version.parseVersion((String)"format(n=!;.n.n):100.1.2");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((Object)1, (Object)v.getSegment(0));
        FormatProcessingTest.assertEquals((Object)2, (Object)v.getSegment(1));
    }

    public void testDefaultArrayWithPad() {
        Version v = Version.parseVersion((String)"format(s.?<n.n>=<1.0pm>;=p10;?):alpha");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((Object)Version.parseVersion((String)"raw:'alpha'.<1.0pm>"), (Object)v);
        v = Version.parseVersion((String)"format(s.?<n.n>=<1.0pm>;=p10;?):alpha.1.2");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((Object)Version.parseVersion((String)"raw:'alpha'.<1.2p10>"), (Object)v);
    }

    public void testDefaultValues() {
        Version v = Version.parseVersion((String)"format(n.[n=1;].?[s='foo';].?[a='bar';].?[a=2;]):9.");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((Object)Version.parseVersion((String)"raw:9.1.'foo'.'bar'.2"), (Object)v);
    }

    public void testArrayDefaultValues() {
        Version v = null;
        v = Version.parseVersion((String)"format(n.<n.n>=<1.0>;?):9.");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((Object)Version.parseVersion((String)"raw:9.<1.0>"), (Object)v);
        v = Version.parseVersion((String)"format(n.<n=3;?.?n=4;?>=<1.0>;?):9.");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"individual defaults should be used", (Object)Version.parseVersion((String)"raw:9.<3.4>"), (Object)v);
        v = Version.parseVersion((String)"format(n.<n=3;?.n=4;?>=<1.0>;?):9.");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"individual defaults should not be used", (Object)Version.parseVersion((String)"raw:9.<1.0>"), (Object)v);
    }

    public void testOtherTypeAsDefault() {
        Version v = null;
        v = Version.parseVersion((String)"format(s=123;?n):1");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:123.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=M;?n):1");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:M.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=-M;?n):1");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#1.3", (Object)Version.parseVersion((String)"raw:-M.1"), (Object)v);
        v = Version.parseVersion((String)"format(s=<1.2>;?n):1");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#1.4", (Object)Version.parseVersion((String)"raw:<1.2>.1"), (Object)v);
        v = Version.parseVersion((String)"format(n='abc';?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:'abc'.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=M;?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=-M;?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#2.3", (Object)Version.parseVersion((String)"raw:-M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n=<'a'.'b'>;?n):1");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#2.4", (Object)Version.parseVersion((String)"raw:<'a'.'b'>.1"), (Object)v);
        v = Version.parseVersion((String)"format(<n>='abc';?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#3.1", (Object)Version.parseVersion((String)"raw:'abc'.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=M;?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#3.2", (Object)Version.parseVersion((String)"raw:M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=-M;?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#3.3", (Object)Version.parseVersion((String)"raw:-M.'a'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>=123;?s):a");
        FormatProcessingTest.assertNotNull((Object)v);
        FormatProcessingTest.assertEquals((String)"#3.4", (Object)Version.parseVersion((String)"raw:123.'a'"), (Object)v);
    }

    public void testSameMoreThanOnce() {
        try {
            Version.parseVersion((String)"format(n=!;=!;.n):1.2");
            FormatProcessingTest.fail((String)"error not detected:2 x =!;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(s=[abc];=[123];.n):abc123.2");
            FormatProcessingTest.fail((String)"error not detected:2 x =[];");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(nd=[^:];=[^:];n):1.2");
            FormatProcessingTest.fail((String)"error not detected:2x [^];");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n={1,3};={1,3};.n):1.2");
            FormatProcessingTest.fail((String)"error not detected:2x ={ };");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n=0;=1;.n):1.2");
            FormatProcessingTest.fail((String)"error not detected:2x =default value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((n.n)=pm;=pm;):1.2");
            FormatProcessingTest.fail((String)"error not detected:2x =pm;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
    }

    public void testSetNotSet() {
        try {
            Version.parseVersion((String)"format(nd=[a-z];=[^.:];n):1.2");
            FormatProcessingTest.fail((String)"error not detected: =[];=[^];");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
    }

    public void testBadPadCombinations() {
        try {
            Version.parseVersion((String)"format((n.n)=pm;=[abc];):1.2");
            FormatProcessingTest.fail((String)"error not detected: =p; =[];");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((n.n)=pm;=[^.:];):1.2");
            FormatProcessingTest.fail((String)"error not detected: =p; =[];");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((n.n)=pm;={1,3};):1.2");
            FormatProcessingTest.fail((String)"error not detected: =p; ={};");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((n.n)=pm;=!;):1.2");
            FormatProcessingTest.fail((String)"error not detected: =p; =!;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
    }

    public void testNonPaddable() {
        try {
            Version.parseVersion((String)"format(n=pm;):1");
            FormatProcessingTest.fail((String)"error not detected: n=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(N=pm;):1");
            FormatProcessingTest.fail((String)"error not detected: n=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(s=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: s=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(S=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: S=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(a=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: a=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(d=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: d=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: q=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(r=pm;):a");
            FormatProcessingTest.fail((String)"error not detected: q=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format('x'=pm;n):x1");
            FormatProcessingTest.fail((String)"error not detected: 'x'=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(.=pm;n):x1");
            FormatProcessingTest.fail((String)"error not detected: .=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(p=pm;n):x1");
            FormatProcessingTest.fail((String)"error not detected: p=p;");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatProcessingTest.assertTrue((boolean)true);
        }
    }
}

