/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatSTest
extends TestCase {
    public void testStringAcceptDigit() {
        Version v = Version.parseVersion((String)"format(S):1");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'1'"), (Object)v);
        try {
            Version.parseVersion((String)"format(s):1");
            FormatSTest.fail((String)"Uncaught error: s should not accept digits");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }

    public void testStringAcceptAlpha() {
        Version v = Version.parseVersion((String)"format(s):a");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(S):a");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
    }

    public void testStringDelimitedByNumeric() {
        Version v = Version.parseVersion((String)"format(sn):foobar123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
        try {
            Version.parseVersion((String)"format(Sn):foobar123");
            FormatSTest.fail((String)"Uncaught error: S should eat entire string, no n found at the end");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }

    public void testStringWithSpace() {
        Version v = Version.parseVersion((String)"format(S=[^0-9];n):foo bar123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'foo bar'.123"), (Object)v);
        try {
            Version.parseVersion((String)"format(s=[^];n):foo bar123");
            FormatSTest.fail((String)"Uncaught error: format(s) can not match non letters (space).");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }

    public void testStringDelimitedByDelimiter() {
        Version v = Version.parseVersion((String)"format(s.n):foobar.123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
        v = Version.parseVersion((String)"format(S=[^.];.n):foobar.123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
    }

    public void testStringDelimitedByExplicitDelimiter() {
        Version v = Version.parseVersion((String)"format(s=[^r];d=[r];n):foobar123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'fooba'.123"), (Object)v);
    }

    public void testStringWithAllowedSet() {
        Version v = Version.parseVersion((String)"format(s=[a-z];sn):fooBAR123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'foo'.'BAR'.123"), (Object)v);
    }

    public void testStringWithDisallowedSet() {
        Version v = Version.parseVersion((String)"format(s=[^a-z];sn):FOObar123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'FOO'.'bar'.123"), (Object)v);
    }

    public void testExact() {
        Version v = Version.parseVersion((String)"format(S={4};S):123abc456'def'");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(s={2};s):abc");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};S):abc");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};S):123");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'"), (Object)v);
        v = Version.parseVersion((String)"format(S={4};S={1};S={3};):123abc45");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.'b'.'c45'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};.S={1};s={3};):12.3abc");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'.'abc'"), (Object)v);
        try {
            Version.parseVersion((String)"format(s={4};.s):aaa.abc456'def'");
            FormatSTest.fail((String)"Uncaught error: first segment is less than 4 chars long");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(s={4};.s):123.abc456'def'");
            FormatSTest.fail((String)"Uncaught error: first segment has digits");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(S={4}=[^.];.S):123.abc456'def'");
            FormatSTest.fail((String)"Uncaught error: first segment has only 3 characters");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }

    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(S={2,};):123abc456'def'");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(S={2,};=[^.];.S):123a.bc456'def'");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        try {
            Version.parseVersion((String)"format(s={2,};.S):a.abc456'def'");
            FormatSTest.fail((String)"uncaught error: first segment is shorter than 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(s={2,};.s={10,};):aa.abcd");
            FormatSTest.fail((String)"Uncaught error: secont segment too short");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }

    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(S={1,3};S={1,2};S):123abc456'def'");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'ab'.\"c456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(S={1,4};=[^.];.S={1,4};.S):123.abc4.56'def'");
        FormatSTest.assertNotNull((Object)v);
        FormatSTest.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'abc4'.\"56'def'\""), (Object)v);
        try {
            Version.parseVersion((String)"format(s={2,3};s):a.abc456'def'");
            FormatSTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(s={2,3};.S={2,3};):aa.abc456'd'");
            FormatSTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatSTest.assertTrue((boolean)true);
        }
    }
}

