/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class OSGiVersionTest
extends VersionTesting {
    public void testBasicParsing() {
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1"));
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1.0"));
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1.0.0"));
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1.0.0.9"));
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1.0.0.r12345"));
        OSGiVersionTest.assertNotNull((Object)Version.parseVersion((String)"1.0.0.r12345_hello"));
    }

    public void testOSGiStrings() {
        Version v = Version.parseVersion(null);
        OSGiVersionTest.assertEquals((String)"0.0.0", (String)v.toString());
        v = Version.parseVersion((String)"");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"0.0.0", (String)v.toString());
        v = Version.parseVersion((String)"1");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0", (String)v.toString());
        v = Version.parseVersion((String)"1.0");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0", (String)v.toString());
        v = Version.parseVersion((String)"1.0.0");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0", (String)v.toString());
        v = Version.parseVersion((String)"1.0.0.9");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0.9", (String)v.toString());
        v = Version.parseVersion((String)"1.0.0.r12345");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0.r12345", (String)v.toString());
        v = Version.parseVersion((String)"1.0.0.r12345_hello");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertEquals((String)"1.0.0.r12345_hello", (String)v.toString());
    }

    public void testSerialize() {
        Version v = null;
        v = Version.parseVersion((String)"1");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.9");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.r12345");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.r12345_hello");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
    }

    public void testNegativeFirstValue() {
        try {
            Version.parseVersion((String)"-1");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testPeriodInQualifier() {
        try {
            Version.parseVersion((String)"1.0.0.sailor.moon");
            OSGiVersionTest.fail((String)"Uncaught exception: period is not allowed in osgi qualifier");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testNegativeSecondValue() {
        try {
            Version.parseVersion((String)"1.-1");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testNegativeThirdValue() {
        try {
            Version.parseVersion((String)"1.0.-1");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testEmptyFourthValue() {
        try {
            Version.parseVersion((String)"1.0.0.");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testStringFirstValue() {
        try {
            Version.parseVersion((String)"a");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testStringSecondValue() {
        try {
            Version.parseVersion((String)"1.a");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testStringThirdValue() {
        try {
            Version.parseVersion((String)"1.0.a");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testSinglePeriod() {
        try {
            Version.parseVersion((String)".");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testTwoPeriods() {
        try {
            Version.parseVersion((String)"..");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testThreePeriods() {
        try {
            Version.parseVersion((String)"...");
            OSGiVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiVersionTest.assertTrue((boolean)true);
        }
    }

    public void testEquality() {
        Version v1 = Version.parseVersion((String)"1");
        Version v2 = Version.parseVersion((String)"1.0");
        Version v3 = Version.parseVersion((String)"1.0.0");
        Version v4 = Version.parseVersion((String)"1.0.0.9");
        Version v5 = Version.parseVersion((String)"1.0.0.r12345");
        OSGiVersionTest.assertEquals((Object)v1, (Object)v2);
        OSGiVersionTest.assertEquals((Object)v1, (Object)v3);
        OSGiVersionTest.assertEquals((Object)v2, (Object)v3);
        OSGiVersionTest.assertOrder(v3, v4);
        OSGiVersionTest.assertOrder(v4, v5);
    }

    public void testVersionCompare() {
        Version v1 = Version.parseVersion((String)"1");
        Version v2 = Version.parseVersion((String)"1.0.1");
        Version v3 = Version.parseVersion((String)"1.1");
        Version v4 = Version.parseVersion((String)"1.1.1");
        Version v5 = Version.parseVersion((String)"1.1.1.-");
        Version v6 = Version.parseVersion((String)"1.2");
        Version v7 = Version.parseVersion((String)"2");
        Version v8 = Version.parseVersion((String)"10.0");
        OSGiVersionTest.assertOrder(v1, v2);
        OSGiVersionTest.assertOrder(v2, v3);
        OSGiVersionTest.assertOrder(v3, v4);
        OSGiVersionTest.assertOrder(v4, v5);
        OSGiVersionTest.assertOrder(v5, v6);
        OSGiVersionTest.assertOrder(v6, v7);
        OSGiVersionTest.assertOrder(v7, v8);
    }

    public void testCompatability() {
        Version v = Version.parseVersion((String)"raw:1.2.3.'foo'");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertTrue((String)"a raw:1.2.3.'foo' compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertTrue((String)"a raw:1.2.3 compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3p''");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertFalse((String)"a raw:1.2.3p'' not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.4");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertFalse((String)"a raw (4th is int) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.'foo'.'bar'");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertFalse((String)"a raw (5 elements) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertFalse((String)"a raw (only 2 elements) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.' %@'");
        OSGiVersionTest.assertNotNull((Object)v);
        OSGiVersionTest.assertFalse((String)"a raw (illegal chars in qualifier) not compatible with OSGi", (boolean)v.isOSGiCompatible());
    }
}

