/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.perf;

import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.perf.ProvisioningPerformanceTest;

public class MetadataRepositoryPerformanceTest
extends ProvisioningPerformanceTest {
    private static final int REPEATS = 5;
    protected File repoLocation;
    IMetadataRepository repository;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repoLocation = new File(tempDir, "MetadataRepositoryPerformanceTest");
        MetadataRepositoryPerformanceTest.delete(this.repoLocation);
        this.repoLocation.mkdir();
        IMetadataRepositoryManager manager = MetadataRepositoryPerformanceTest.getMetadataRepositoryManager();
        this.repository = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
    }

    @Override
    protected void tearDown() throws Exception {
        MetadataRepositoryPerformanceTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        MetadataRepositoryPerformanceTest.delete(this.repoLocation);
        super.tearDown();
    }

    public void testQueryLocalRepository() {
        new PerformanceTestRunner(){
            IQuery[] queries = new IQuery[3000];

            protected void setUp() {
                ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(3000);
                int i = 0;
                while (i < 3000) {
                    IInstallableUnit iu = MetadataRepositoryPerformanceTest.this.generateIU(i);
                    this.queries[i] = QueryUtil.createIUQuery((String)iu.getId(), (Version)iu.getVersion());
                    ius.add(iu);
                    ++i;
                }
                MetadataRepositoryPerformanceTest.this.repository.addInstallableUnits(ius);
            }

            protected void tearDown() {
            }

            protected void test() {
                int i = 0;
                while (i < this.queries.length) {
                    MetadataRepositoryPerformanceTest.this.repository.query(this.queries[i], null);
                    ++i;
                }
            }
        }.run((TestCase)this, "Test query local metadata repo for 3000 ius", 5, 10);
    }
}

