/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AbsolutePlanTest
extends AbstractProvisioningTest {
    public void testAddAndRemoveIU() {
        IProfile profile = this.createProfile(this.getName());
        IEngine engine = AbsolutePlanTest.createEngine();
        IProvisioningPlan plan = engine.createPlan(profile, new ProvisioningContext(AbsolutePlanTest.getAgent()));
        IInstallableUnit iuA = AbsolutePlanTest.createEclipseIU("A");
        plan.addInstallableUnit(iuA);
        plan.addInstallableUnit(AbsolutePlanTest.createEclipseIU("B"));
        plan.addInstallableUnit(AbsolutePlanTest.createEclipseIU("C"));
        AbsolutePlanTest.assertEquals((int)3, (int)this.countPlanElements(plan));
        engine.perform(plan, null);
        IProvisioningPlan plan2 = engine.createPlan(profile, new ProvisioningContext(AbsolutePlanTest.getAgent()));
        plan2.removeInstallableUnit(iuA);
        AbsolutePlanTest.assertEquals((int)1, (int)this.countPlanElements(plan2));
    }

    public void testAddAndRemoveProperty() {
        IInstallableUnit iuA = AbsolutePlanTest.createEclipseIU("A");
        IProfile profile = this.createProfile(this.getName());
        IEngine engine = AbsolutePlanTest.createEngine();
        IProvisioningPlan plan = engine.createPlan(profile, new ProvisioningContext(AbsolutePlanTest.getAgent()));
        plan.addInstallableUnit(iuA);
        plan.setInstallableUnitProfileProperty(iuA, "key", "value");
        AbsolutePlanTest.assertEquals((int)1, (int)this.countPlanElements(plan));
        engine.perform(plan, null);
        Operand[] ops = ((ProvisioningPlan)plan).getOperands();
        boolean found = false;
        int i = 0;
        while (i < ops.length) {
            if (ops[i] instanceof InstallableUnitPropertyOperand) {
                found = true;
            }
            ++i;
        }
        AbsolutePlanTest.assertTrue((boolean)found);
        IProvisioningPlan plan2 = engine.createPlan(profile, new ProvisioningContext(AbsolutePlanTest.getAgent()));
        plan2.removeInstallableUnit(iuA);
        plan2.setInstallableUnitProfileProperty(iuA, "key", null);
        AbsolutePlanTest.assertEquals((int)1, (int)this.countPlanElements(plan2));
    }

    public void testAddProperty() {
        IProfile profile = this.createProfile(this.getName());
        IEngine engine = AbsolutePlanTest.createEngine();
        IProvisioningPlan plan = engine.createPlan(profile, new ProvisioningContext(AbsolutePlanTest.getAgent()));
        plan.setProfileProperty("foo", "bar");
        engine.perform(plan, null);
        AbsolutePlanTest.assertEquals((String)"bar", (String)this.getProfileRegistry().getProfile(this.getName()).getProperty("foo"));
    }
}

