/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Map;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ActualChangeRequestTest2
extends AbstractProvisioningTest {
    IInstallableUnit a;
    IInstallableUnit b;
    IInstallableUnit b2;
    IInstallableUnit c;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = ActualChangeRequestTest2.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)}, NO_PROPERTIES, true);
        this.b = ActualChangeRequestTest2.createIU("B", Version.create((String)"1.0.0"), true);
        this.b2 = ActualChangeRequestTest2.createIU("B", Version.create((String)"2.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a, this.b2, this.b});
        this.planner = ActualChangeRequestTest2.createPlanner();
        this.engine = ActualChangeRequestTest2.createEngine();
    }

    public void testRequestStatus() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile1);
        req.addInstallableUnits(new IInstallableUnit[]{this.b});
        req.setInstallableUnitInclusionRules(this.b, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.b));
        req.addInstallableUnits(new IInstallableUnit[]{this.a});
        req.setInstallableUnitInclusionRules(this.a, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        ActualChangeRequestTest2.assertEquals((int)0, (int)((RequestStatus)((PlannerStatus)plan.getStatus()).getRequestChanges().get(this.b)).getSeverity());
        ActualChangeRequestTest2.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        ActualChangeRequestTest2.assertProfileContainsAll("B is missing", this.profile1, new IInstallableUnit[]{this.a, this.b});
        ActualChangeRequestTest2.assertEquals((int)2, (int)ActualChangeRequestTest2.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.b2});
        req2.setInstallableUnitInclusionRules(this.b2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.b2));
        req2.removeInstallableUnits(new IInstallableUnit[]{this.b});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        ActualChangeRequestTest2.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        ActualChangeRequestTest2.assertNotNull(((PlannerStatus)plan2.getStatus()).getRequestChanges().get(this.b));
        ActualChangeRequestTest2.assertNotNull(((PlannerStatus)plan2.getStatus()).getRequestChanges().get(this.b2));
        Map m = ((PlannerStatus)plan2.getStatus()).getRequestSideEffects();
        ActualChangeRequestTest2.assertEquals((int)1, (int)m.size());
        ActualChangeRequestTest2.assertNotNull(m.get(this.a));
        ActualChangeRequestTest2.assertEquals((int)1, (int)((RequestStatus)m.get(this.a)).getSeverity());
        ActualChangeRequestTest2.assertEquals((byte)1, (byte)((RequestStatus)m.get(this.a)).getInitialRequestType());
        this.engine.perform(plan2, null);
        ActualChangeRequestTest2.assertProfileContainsAll("A is missing", this.profile1, new IInstallableUnit[]{this.b2});
        ActualChangeRequestTest2.assertEquals((int)1, (int)ActualChangeRequestTest2.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.a});
        req3.setInstallableUnitInclusionRules(this.a, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a));
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        ActualChangeRequestTest2.assertNotNull(((PlannerStatus)plan3.getStatus()).getRequestChanges().get(this.a));
        ActualChangeRequestTest2.assertEquals((int)4, (int)((RequestStatus)((PlannerStatus)plan3.getStatus()).getRequestChanges().get(this.a)).getSeverity());
        ActualChangeRequestTest2.assertEquals((byte)0, (byte)((RequestStatus)((PlannerStatus)plan3.getStatus()).getRequestChanges().get(this.a)).getInitialRequestType());
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile1);
        req4.addInstallableUnits(new IInstallableUnit[]{this.a});
        req4.setInstallableUnitInclusionRules(this.a, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.a));
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        ActualChangeRequestTest2.assertNotNull(((PlannerStatus)plan4.getStatus()).getRequestChanges().get(this.a));
        ActualChangeRequestTest2.assertEquals((int)4, (int)((RequestStatus)((PlannerStatus)plan4.getStatus()).getRequestChanges().get(this.a)).getSeverity());
        ActualChangeRequestTest2.assertEquals((byte)0, (byte)((RequestStatus)((PlannerStatus)plan4.getStatus()).getRequestChanges().get(this.a)).getInitialRequestType());
    }
}

