/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AddIUProperty
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IProfile profile;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = AddIUProperty.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = AddIUProperty.createIU("A", Version.create((String)"2.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = AddIUProperty.createPlanner();
        this.engine = AddIUProperty.createEngine();
    }

    public void testWithoutIUProperty() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        AddIUProperty.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AddIUProperty.assertInstallOperand(plan, this.a1);
    }

    public void testWithIUProperty() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        req.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        AddIUProperty.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AddIUProperty.assertInstallOperand(plan, this.a1);
    }

    public void testChangeIUProperty() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        AddIUProperty.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        AddIUProperty.assertProfileContainsAll("A1 is missing", this.profile, new IInstallableUnit[]{this.a1});
        IQueryResult allProfileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        AddIUProperty.assertEquals((int)AddIUProperty.queryResultSize(allProfileIUs), (int)1);
        ProfileChangeRequest req4 = ProfileChangeRequest.createByProfileId((IProvisioningAgent)AddIUProperty.getAgent(), (String)this.profile.getProfileId());
        req4.addInstallableUnits(new IInstallableUnit[]{this.a2});
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        AddIUProperty.assertEquals((int)4, (int)plan4.getStatus().getSeverity());
        ProfileChangeRequest req2 = ProfileChangeRequest.createByProfileId((IProvisioningAgent)AddIUProperty.getAgent(), (String)this.profile.getProfileId());
        req2.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        req2.addInstallableUnits(new IInstallableUnit[]{this.a2});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        AddIUProperty.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AddIUProperty.assertInstallOperand(plan2, this.a2);
        this.engine.perform(plan2, null);
        this.profile = this.getProfile(this.profile.getProfileId());
        AddIUProperty.assertProfileContainsAll("A2 is missing", this.profile, new IInstallableUnit[]{this.a2});
        allProfileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        AddIUProperty.assertEquals((int)AddIUProperty.queryResultSize(allProfileIUs), (int)1);
        IQueryResult iuProfileProperties = this.profile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.internal.inclusion.rules", "*"), null);
        AddIUProperty.assertEquals((int)AddIUProperty.queryResultSize(iuProfileProperties), (int)1);
        ProfileChangeRequest req3 = ProfileChangeRequest.createByProfileId((IProvisioningAgent)AddIUProperty.getAgent(), (String)this.profile.getProfileId());
        req3.removeInstallableUnitInclusionRules(this.a1);
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        AddIUProperty.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan3, null);
        allProfileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        AddIUProperty.assertProfileContainsAll("A2 is missing", this.profile, new IInstallableUnit[]{this.a2});
        AddIUProperty.assertEquals((int)AddIUProperty.queryResultSize(allProfileIUs), (int)1);
    }
}

