/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AgentPlanTestInExternalInstanceForCohostedMode
extends AbstractProvisioningTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        try {
            Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
            selfField.setAccessible(true);
            this.previousSelfValue = selfField.get(profileRegistry);
            selfField.set(profileRegistry, "agent");
            this.clearProfileMap(profileRegistry);
        }
        catch (Throwable throwable) {
            AgentPlanTestInExternalInstanceForCohostedMode.fail();
        }
        this.createProfile("agent");
        Properties p = new Properties();
        p.setProperty("org.eclipse.equinox.p2.planner.resolveMetaRequirements", "true");
        this.createProfile("installation", p);
    }

    @Override
    public void tearDown() throws Exception {
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        try {
            Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
            selfField.setAccessible(true);
            Object self = selfField.get(profileRegistry);
            if (self.equals("agent")) {
                selfField.set(profileRegistry, this.previousSelfValue);
            }
            this.clearProfileMap(profileRegistry);
        }
        catch (Throwable throwable) {
            AgentPlanTestInExternalInstanceForCohostedMode.fail();
        }
        super.tearDown();
    }

    public void testGetAgentPlanActionNeededButUnavailable() {
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProfile profile = this.getProfile("installation");
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        ProvisioningContext context = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        context.setMetadataRepositories(new URI[0]);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNotOK(plan.getStatus());
    }

    public void testGetAgentPlanActionNeeded() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1});
        IProfile profile = this.getProfile("installation");
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertTrue((boolean)plan.getStatus().isOK());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNotNull((Object)plan.getInstallerPlan());
    }

    public void testConflictBetweenActionAndThingBeingInstalled() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "A", new VersionRange("[2.0.0, 2.0.0]")), new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IInstallableUnit a2 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("A", Version.createOSGi((int)2, (int)0, (int)0));
        this.createTestMetdataRepository(new IInstallableUnit[]{a, a2, act1});
        IProfile profile = this.getProfile("installation");
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNotOK(plan.getStatus());
    }

    public void testSubsequentInstall() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IInstallableUnit b = AgentPlanTestInExternalInstanceForCohostedMode.createEclipseIU("B");
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, b});
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        IEngine engine = AgentPlanTestInExternalInstanceForCohostedMode.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("installation"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after initial install", this.getProfile("installation"), new IInstallableUnit[]{a, act1});
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("installation"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNull((Object)plan2.getInstallerPlan());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install b", engine.perform(plan2, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after initial install", this.getProfile("installation"), new IInstallableUnit[]{a, b, act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking actions are still installed", this.getProfile("agent"), new IInstallableUnit[]{act1});
    }

    public void testWithOveralInDependency() {
        IInstallableUnit common = AgentPlanTestInExternalInstanceForCohostedMode.createEclipseIU("Common");
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "Common"), new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "Common"), metaReq);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, common});
        IProfile profile = this.getProfile("installation");
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        IEngine engine = AgentPlanTestInExternalInstanceForCohostedMode.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1, common});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{a, common, act1});
    }

    public void testTwoInstallWithActions() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)DEFAULT_VERSION);
        IInstallableUnit act2 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action2", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq2 = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action2", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit b = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("B", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq2);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, b, act1, act2});
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        IEngine engine = AgentPlanTestInExternalInstanceForCohostedMode.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("installation"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{a, act1});
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("installation"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions", engine.perform(plan2.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act2, act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan2, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{b, a, act1, act2});
    }

    public void testCompleteScenario() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act1bCap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1b", (Version)DEFAULT_VERSION);
        IInstallableUnit act1b = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1b", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1bCap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReqb = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1b", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a111 = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", Version.createOSGi((int)1, (int)1, (int)1), true, (IRequirement[])NO_REQUIRES, metaReqb);
        IProvidedCapability act2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)DEFAULT_VERSION);
        IInstallableUnit act2 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action2", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IProvidedCapability act1v2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)Version.createOSGi((int)2, (int)0, (int)0));
        IInstallableUnit act1v2 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1v2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReqd = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action2", new VersionRange("[2.0.0, 2.0.0]"));
        IInstallableUnit d = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("D", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReqd);
        IRequirement[] metaReq2 = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action2", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit b = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("B", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq2);
        IInstallableUnit c = AgentPlanTestInExternalInstanceForCohostedMode.createEclipseIU("C");
        this.createTestMetdataRepository(new IInstallableUnit[]{a, b, act1, act1v2, act2, c, act1b, d, a111});
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        IEngine engine = AgentPlanTestInExternalInstanceForCohostedMode.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("installation"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions for A", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{a, act1});
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("installation"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions for B", engine.perform(plan2.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act2});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install B", engine.perform(plan2, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{b, a, act2});
        ProfileChangeRequest requestForC = new ProfileChangeRequest(this.getProfile("installation"));
        requestForC.addInstallableUnits(new IInstallableUnit[]{c});
        IProvisioningPlan planForC = planner.getProvisioningPlan((IProfileChangeRequest)requestForC, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNull((Object)planForC.getInstallerPlan());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install C", engine.perform(planForC, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after C", this.getProfile("installation"), new IInstallableUnit[]{a, b, c, act2, act1});
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act2, act1});
        ProfileChangeRequest requestUpdateA = new ProfileChangeRequest(this.getProfile("installation"));
        requestUpdateA.removeInstallableUnits(new IInstallableUnit[]{a});
        requestUpdateA.addInstallableUnits(new IInstallableUnit[]{a111});
        IProvisioningPlan planUpdateA = planner.getProvisioningPlan((IProfileChangeRequest)requestUpdateA, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions for A 1.1.1", engine.perform(planUpdateA.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1, act1b, act2});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(planUpdateA, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{act2, act1b, a111, b, c});
        AgentPlanTestInExternalInstanceForCohostedMode.assertTrue((boolean)this.getProfile("installation").query(QueryUtil.createIUQuery((String)"Action1", (Version)DEFAULT_VERSION), null).isEmpty());
        AgentPlanTestInExternalInstanceForCohostedMode.assertEquals((String)this.getProfile("agent").getProfileId(), (String)plan.getInstallerPlan().getProfile().getProfileId());
        ProfileChangeRequest request3 = new ProfileChangeRequest(this.getProfile("installation"));
        request3.removeInstallableUnits(new IInstallableUnit[]{a111});
        IProvisioningPlan plan3 = planner.getProvisioningPlan((IProfileChangeRequest)request3, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install A", engine.perform(plan3, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("installation"), new IInstallableUnit[]{c, b, act2});
        ProfileChangeRequest request4 = new ProfileChangeRequest(this.getProfile("installation"));
        request4.removeInstallableUnits(new IInstallableUnit[]{c});
        IProvisioningPlan uninstallC = planner.getProvisioningPlan((IProfileChangeRequest)request4, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNull((Object)uninstallC.getInstallerPlan());
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install C", engine.perform(uninstallC, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after C", this.getProfile("installation"), new IInstallableUnit[]{b, act2});
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act2});
        ProfileChangeRequest requestForD = new ProfileChangeRequest(this.getProfile("installation"));
        requestForD.addInstallableUnits(new IInstallableUnit[]{d});
        IProvisioningPlan planForD = planner.getProvisioningPlan((IProfileChangeRequest)requestForD, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNotNull((Object)planForD.getInstallerPlan());
        AgentPlanTestInExternalInstanceForCohostedMode.assertEquals((int)1, (int)AgentPlanTestInExternalInstanceForCohostedMode.queryResultSize(planForD.getInstallerPlan().getRemovals().query(QueryUtil.createIUQuery((String)act1b.getId()), null)));
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install actions", engine.perform(planForD.getInstallerPlan(), null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act1v2});
        AgentPlanTestInExternalInstanceForCohostedMode.assertOK("install D", engine.perform(planForD, null));
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after D", this.getProfile("installation"), new IInstallableUnit[]{b, d});
        AgentPlanTestInExternalInstanceForCohostedMode.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("agent"), new IInstallableUnit[]{act2, act1v2});
    }

    public void testConflictBetweenActions() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act1v2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)Version.createOSGi((int)2, (int)0, (int)0));
        IInstallableUnit act1v2 = AgentPlanTestInExternalInstanceForCohostedMode.createIU("Action1", Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1v2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReqd = AgentPlanTestInExternalInstanceForCohostedMode.createRequiredCapabilities("p2.action", "action2", new VersionRange("[2.0.0, 2.0.0]"));
        IInstallableUnit d = AgentPlanTestInExternalInstanceForCohostedMode.createIUWithMetaRequirement("D", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReqd);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, d, act1v2});
        IProfile profile = this.getProfile("installation");
        IPlanner planner = AgentPlanTestInExternalInstanceForCohostedMode.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInExternalInstanceForCohostedMode.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a, d});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInExternalInstanceForCohostedMode.assertNotOK(plan.getStatus());
        AgentPlanTestInExternalInstanceForCohostedMode.assertEquals((Object)request.getProfile(), (Object)plan.getProfile());
    }
}

