/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug249605
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IInstallableUnitPatch p3;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = Bug249605.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)});
        this.b1 = Bug249605.createIU("B", Version.createOSGi((int)1, (int)1, (int)0), true);
        this.b2 = Bug249605.createIU("B", Version.createOSGi((int)1, (int)2, (int)0), true);
        this.b3 = Bug249605.createIU("B", Version.createOSGi((int)1, (int)3, (int)0), true);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p1 = Bug249605.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        IRequirementChange change2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.2.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p2 = Bug249605.createIUPatch("P", Version.create((String)"1.2.0"), null, new IRequirement[0], new IProvidedCapability[0], new HashMap(), null, null, true, MetadataFactory.createUpdateDescriptor((String)"P", (VersionRange)new VersionRange("[1.0.0, 1.2.0)"), (int)0, null), new IRequirementChange[]{change2}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null, new IRequirement[0]);
        IRequirementChange change3 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.3.0, 1.4.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p3 = Bug249605.createIUPatch("P", Version.create((String)"1.3.0"), null, new IRequirement[0], new IProvidedCapability[0], new HashMap(), null, null, true, MetadataFactory.createUpdateDescriptor((String)"P", (VersionRange)new VersionRange("[1.0.0, 1.3.0)"), (int)0, null), new IRequirementChange[]{change3}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null, new IRequirement[0]);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.b3, this.p1, this.p2, this.p3});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = Bug249605.createPlanner();
        this.engine = Bug249605.createEngine();
    }

    public void testInstall() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        req1.setInstallableUnitProfileProperty((IInstallableUnit)this.p1, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug249605.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        Bug249605.assertOK("1.1", this.engine.perform(plan1, (IProgressMonitor)new NullProgressMonitor()));
        Bug249605.assertProfileContains("1.2", this.profile1, new IInstallableUnit[]{this.a1, this.p1, this.b1});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p2});
        req2.removeInstallableUnits(new IInstallableUnit[]{this.p1});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, (IProgressMonitor)new NullProgressMonitor());
        Bug249605.assertOK("2.0", plan2.getStatus());
        Bug249605.assertOK("2.1", this.engine.perform(plan2, (IProgressMonitor)new NullProgressMonitor()));
        Bug249605.assertProfileContains("2.2", this.profile1, new IInstallableUnit[]{this.a1, this.p2, this.b2});
        Bug249605.assertTrue((boolean)UserVisibleRootQuery.isUserVisible((IInstallableUnit)this.p2, (IProfile)this.profile1));
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.p3});
        req3.removeInstallableUnits(new IInstallableUnit[]{this.p2});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, (IProgressMonitor)new NullProgressMonitor());
        Bug249605.assertOK("3.0", plan3.getStatus());
        Bug249605.assertOK("3.1", this.engine.perform(plan3, (IProgressMonitor)new NullProgressMonitor()));
        Bug249605.assertProfileContains("3.2", this.profile1, new IInstallableUnit[]{this.a1, this.p3, this.b3});
        Bug249605.assertTrue((boolean)UserVisibleRootQuery.isUserVisible((IInstallableUnit)this.p3, (IProfile)this.profile1));
    }
}

