/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug271067
extends AbstractProvisioningTest {
    private IProfile profile;
    private File previousStoreValue = null;
    String profileLoadedId = "bootProfile";
    IMetadataRepository repo = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug271067.getTestData("test data bug 271067", "testData/bug271067/profileRegistry");
        File tempFolder = this.getTempFolder();
        Bug271067.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, tempFolder);
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        this.profile = realProfileRegistry.getProfile(this.profileLoadedId);
        Bug271067.assertNotNull((Object)this.profile);
        this.repo = this.loadMetadataRepository(Bug271067.getTestData("Repository for 271067", "testData/bug271067/").toURI());
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        super.tearDown();
    }

    IInstallableUnit getIU(IMetadataRepository source, String id, String version) {
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), (IProgressMonitor)new NullProgressMonitor());
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(c));
        return (IInstallableUnit)c.iterator().next();
    }

    public void testInstallFeaturePatch() {
        ProfileChangeRequest installFeature1 = new ProfileChangeRequest(this.getProfile(this.profileLoadedId));
        IInstallableUnit featureGroup = this.getIU(this.repo, "hello.feature.1.feature.group", "1.0.0");
        IInstallableUnit featureJar = this.getIU(this.repo, "hello.feature.1.feature.jar", "1.0.0");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.0");
        IInstallableUnit patch = this.getIU(this.repo, "hello.patch.feature.group", "1.0.0");
        IInstallableUnit helloPatch = this.getIU(this.repo, "hello", "1.0.0.1");
        IInstallableUnit patchJar = this.getIU(this.repo, "hello.patch.feature.jar", "1.0.0");
        installFeature1.addInstallableUnits(new IInstallableUnit[]{featureGroup, featureJar, helloIU, patch, helloPatch, patchJar});
        installFeature1.setInstallableUnitInclusionRules(featureGroup, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup));
        installFeature1.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installFeature1.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        installFeature1.setInstallableUnitInclusionRules(patch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patch));
        installFeature1.setInstallableUnitInclusionRules(helloPatch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloPatch));
        installFeature1.setInstallableUnitInclusionRules(patchJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patchJar));
        IProvisioningPlan feature1Plan = Bug271067.createPlanner().getProvisioningPlan((IProfileChangeRequest)installFeature1, new ProvisioningContext(Bug271067.getAgent()), null);
        Bug271067.assertOK("installation of feature1 and patch", Bug271067.createEngine().perform(feature1Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(this.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.1")), (IProgressMonitor)new NullProgressMonitor())));
        IInstallableUnit featureGroup2 = this.getIU(this.repo, "hello.feature.2.feature.group", "1.0.0");
        IInstallableUnit helloIU2 = this.getIU(this.repo, "hello", "1.0.2");
        IInstallableUnit featureJar2 = this.getIU(this.repo, "hello.feature.2.feature.jar", "1.0.0");
        ProfileChangeRequest installFeature2 = new ProfileChangeRequest(this.getProfile(this.profileLoadedId));
        installFeature2.addInstallableUnits(new IInstallableUnit[]{featureGroup2, helloIU2, featureJar2});
        installFeature2.setInstallableUnitInclusionRules(featureGroup2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup2));
        installFeature2.setInstallableUnitInclusionRules(helloIU2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU2));
        installFeature2.setInstallableUnitInclusionRules(featureJar2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar2));
        IProvisioningPlan feature2Plan = Bug271067.createPlanner().getProvisioningPlan((IProfileChangeRequest)installFeature2, new ProvisioningContext(Bug271067.getAgent()), null);
        Bug271067.assertOK("installation of feature2", Bug271067.createEngine().perform(feature2Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(this.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.1")), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testInstallFeaturePatchReverseOrder() {
        IInstallableUnit featureGroup2 = this.getIU(this.repo, "hello.feature.2.feature.group", "1.0.0");
        IInstallableUnit helloIU2 = this.getIU(this.repo, "hello", "1.0.2");
        IInstallableUnit featureJar2 = this.getIU(this.repo, "hello.feature.2.feature.jar", "1.0.0");
        ProfileChangeRequest installFeature2 = new ProfileChangeRequest(this.getProfile(this.profileLoadedId));
        installFeature2.addInstallableUnits(new IInstallableUnit[]{featureGroup2, helloIU2, featureJar2});
        installFeature2.setInstallableUnitInclusionRules(featureGroup2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup2));
        installFeature2.setInstallableUnitInclusionRules(helloIU2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU2));
        installFeature2.setInstallableUnitInclusionRules(featureJar2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar2));
        IProvisioningPlan feature2Plan = Bug271067.createPlanner().getProvisioningPlan((IProfileChangeRequest)installFeature2, new ProvisioningContext(Bug271067.getAgent()), null);
        Bug271067.assertOK("installation of feature2", Bug271067.createEngine().perform(feature2Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(this.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.2")), (IProgressMonitor)new NullProgressMonitor())));
        ProfileChangeRequest installFeature1 = new ProfileChangeRequest(this.getProfile(this.profileLoadedId));
        IInstallableUnit featureGroup = this.getIU(this.repo, "hello.feature.1.feature.group", "1.0.0");
        IInstallableUnit featureJar = this.getIU(this.repo, "hello.feature.1.feature.jar", "1.0.0");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.0");
        IInstallableUnit patch = this.getIU(this.repo, "hello.patch.feature.group", "1.0.0");
        IInstallableUnit helloPatch = this.getIU(this.repo, "hello", "1.0.0.1");
        IInstallableUnit patchJar = this.getIU(this.repo, "hello.patch.feature.jar", "1.0.0");
        installFeature1.addInstallableUnits(new IInstallableUnit[]{featureGroup, featureJar, helloIU, patch, helloPatch, patchJar});
        installFeature1.setInstallableUnitInclusionRules(featureGroup, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup));
        installFeature1.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installFeature1.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        installFeature1.setInstallableUnitInclusionRules(patch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patch));
        installFeature1.setInstallableUnitInclusionRules(helloPatch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloPatch));
        installFeature1.setInstallableUnitInclusionRules(patchJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patchJar));
        IProvisioningPlan feature1Plan = Bug271067.createPlanner().getProvisioningPlan((IProfileChangeRequest)installFeature1, new ProvisioningContext(Bug271067.getAgent()), null);
        Bug271067.assertOK("installation of feature1 and patch", Bug271067.createEngine().perform(feature1Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(this.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.1")), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void installTogether() {
        IInstallableUnit featureGroup2 = this.getIU(this.repo, "hello.feature.2.feature.group", "1.0.0");
        IInstallableUnit helloIU2 = this.getIU(this.repo, "hello", "1.0.2");
        IInstallableUnit featureJar2 = this.getIU(this.repo, "hello.feature.2.feature.jar", "1.0.0");
        IInstallableUnit featureGroup = this.getIU(this.repo, "hello.feature.1.feature.group", "1.0.0");
        IInstallableUnit featureJar = this.getIU(this.repo, "hello.feature.1.feature.jar", "1.0.0");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.0");
        IInstallableUnit patch = this.getIU(this.repo, "hello.patch.feature.group", "1.0.0");
        IInstallableUnit helloPatch = this.getIU(this.repo, "hello", "1.0.0.1");
        IInstallableUnit patchJar = this.getIU(this.repo, "hello.patch.feature.jar", "1.0.0");
        ProfileChangeRequest installEverything = new ProfileChangeRequest(this.getProfile(this.profileLoadedId));
        installEverything.addInstallableUnits(new IInstallableUnit[]{featureGroup2, helloIU2, featureJar2, featureGroup, featureJar, helloIU, patch, helloPatch, patchJar});
        installEverything.setInstallableUnitInclusionRules(featureGroup2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup2));
        installEverything.setInstallableUnitInclusionRules(helloIU2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU2));
        installEverything.setInstallableUnitInclusionRules(featureJar2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar2));
        installEverything.setInstallableUnitInclusionRules(featureGroup, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup));
        installEverything.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installEverything.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        installEverything.setInstallableUnitInclusionRules(patch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patch));
        installEverything.setInstallableUnitInclusionRules(helloPatch, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloPatch));
        installEverything.setInstallableUnitInclusionRules(patchJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)patchJar));
        IProvisioningPlan plan = Bug271067.createPlanner().getProvisioningPlan((IProfileChangeRequest)installEverything, new ProvisioningContext(Bug271067.getAgent()), null);
        Bug271067.assertOK("installation of feature1 and patch", Bug271067.createEngine().perform(plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug271067.assertEquals((int)1, (int)Bug271067.queryResultSize(this.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.1")), (IProgressMonitor)new NullProgressMonitor())));
    }
}

