/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug306279d
extends AbstractProvisioningTest {
    IInstallableUnit a;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnit x;
    IInstallableUnit y;

    @Override
    protected void setUp() throws Exception {
        this.b1 = Bug306279d.createIU("B", Version.createOSGi((int)1, (int)0, (int)0));
        this.b2 = Bug306279d.createIU("B", Version.createOSGi((int)2, (int)0, (int)0));
        this.b3 = Bug306279d.createIU("B", Version.createOSGi((int)3, (int)0, (int)0));
        IRequirement[] reqB = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)false)};
        this.a = Bug306279d.createIU("A", Version.create((String)"1.0.0"), reqB);
        IRequirement[] reqX = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)1, (int)0), false), null, (boolean)false, (boolean)false, (boolean)true)};
        this.x = Bug306279d.createIU("X", Version.create((String)"1.0.0"), reqX);
        IRequirement[] reqY = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange(Version.createOSGi((int)3, (int)0, (int)0), true, Version.createOSGi((int)3, (int)1, (int)0), false), null, (boolean)false, (boolean)false, (boolean)true)};
        this.y = Bug306279d.createIU("Y", Version.create((String)"1.0.0"), reqY);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.x, this.y, this.a, this.b1, this.b2, this.b3});
    }

    public void testNoBInstalled() throws OperationCanceledException {
        IPlanner planner = Bug306279d.createPlanner();
        IProfile profile = this.createProfile(Bug306279d.getUniqueString());
        IProfileChangeRequest pcr = planner.createChangeRequest(profile);
        pcr.add(this.a);
        pcr.add(this.x);
        pcr.add(this.y);
        pcr.setInstallableUnitInclusionRules(this.x, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.x));
        pcr.setInstallableUnitInclusionRules(this.y, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.y));
        IRequirement negationX = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"X", (VersionRange)VersionRange.emptyRange, null, (int)0, (int)0, (boolean)false);
        IRequirement negationY = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)VersionRange.emptyRange, null, (int)0, (int)0, (boolean)false);
        ArrayList<IRequirement> req = new ArrayList<IRequirement>();
        req.add(negationX);
        req.add(negationY);
        pcr.addExtraRequirements(req);
        IProvisioningPlan plan = planner.getProvisioningPlan(pcr, null, null);
        Bug306279d.assertEquals((int)0, (int)plan.getStatus().getCode());
        Bug306279d.assertEquals((int)0, (int)plan.getAdditions().query(QueryUtil.createIUQuery((String)"B"), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet().size());
    }

    public void testBFromXInstalled() throws OperationCanceledException {
        IPlanner planner = Bug306279d.createPlanner();
        IProfile profile = this.createProfile(Bug306279d.getUniqueString());
        IProfileChangeRequest pcr = planner.createChangeRequest(profile);
        pcr.add(this.a);
        pcr.add(this.x);
        pcr.add(this.y);
        pcr.setInstallableUnitInclusionRules(this.x, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.x));
        pcr.setInstallableUnitInclusionRules(this.y, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.y));
        IRequirement negationY = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)VersionRange.emptyRange, null, (int)0, (int)0, (boolean)false);
        ArrayList<IRequirement> req = new ArrayList<IRequirement>();
        req.add(negationY);
        pcr.addExtraRequirements(req);
        IProvisioningPlan plan = planner.getProvisioningPlan(pcr, null, null);
        Bug306279d.assertEquals((int)0, (int)plan.getStatus().getCode());
        Bug306279d.assertEquals((int)1, (int)plan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.b2), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet().size());
    }

    public void testBFromYInstalled() throws OperationCanceledException {
        IPlanner planner = Bug306279d.createPlanner();
        IProfile profile = this.createProfile(Bug306279d.getUniqueString());
        IProfileChangeRequest pcr = planner.createChangeRequest(profile);
        pcr.add(this.a);
        pcr.add(this.x);
        pcr.add(this.y);
        pcr.setInstallableUnitInclusionRules(this.x, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.x));
        pcr.setInstallableUnitInclusionRules(this.y, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.y));
        IRequirement negationX = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"X", (VersionRange)VersionRange.emptyRange, null, (int)0, (int)0, (boolean)false);
        ArrayList<IRequirement> req = new ArrayList<IRequirement>();
        req.add(negationX);
        pcr.addExtraRequirements(req);
        IProvisioningPlan plan = planner.getProvisioningPlan(pcr, null, null);
        Bug306279d.assertEquals((int)0, (int)plan.getStatus().getCode());
        Bug306279d.assertEquals((int)1, (int)plan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.b3), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet().size());
    }
}

