/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.planner.AbstractPlannerTest;

public class Bug362692
extends AbstractPlannerTest {
    @Override
    protected String getTestDataPath() {
        return "testData/bug362692";
    }

    @Override
    protected String getProfileId() {
        return "bootProfile";
    }

    public void testInstall() {
        IPlanner planner = Bug362692.createPlanner();
        HashSet<IInstallableUnit> expected = new HashSet<IInstallableUnit>();
        IQueryResult queryResult = this.repo.query(QueryUtil.createIUQuery((String)"PluginA", (Version)Version.createOSGi((int)1, (int)1, (int)1, null)), (IProgressMonitor)new NullProgressMonitor());
        expected.addAll(queryResult.toSet());
        queryResult = this.repo.query(QueryUtil.createIUQuery((String)"PluginB", (Version)Version.createOSGi((int)1, (int)1, (int)2, null)), (IProgressMonitor)new NullProgressMonitor());
        expected.addAll(queryResult.toSet());
        queryResult = this.repo.query(QueryUtil.createIUQuery((String)"PluginC", (Version)Version.createOSGi((int)1, (int)1, (int)3, null)), (IProgressMonitor)new NullProgressMonitor());
        expected.addAll(queryResult.toSet());
        queryResult = this.repo.query(QueryUtil.createIUQuery((String)"PluginD", (Version)Version.createOSGi((int)1, (int)1, (int)4, null)), (IProgressMonitor)new NullProgressMonitor());
        expected.addAll(queryResult.toSet());
        queryResult = this.repo.query(QueryUtil.createIUQuery((String)"PluginE", (Version)Version.createOSGi((int)1, (int)1, (int)5, null)), (IProgressMonitor)new NullProgressMonitor());
        expected.addAll(queryResult.toSet());
        HashSet<IInstallableUnit> toAdd = new HashSet<IInstallableUnit>();
        IQueryResult allIUs = this.repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        boolean already = false;
        for (IInstallableUnit iu : allIUs) {
            queryResult = this.getProfile().query(QueryUtil.createIUQuery((String)iu.getId(), (Version)iu.getVersion()), (IProgressMonitor)new NullProgressMonitor());
            if (queryResult.isEmpty()) {
                toAdd.add(iu);
                continue;
            }
            System.out.println("Already installed: " + iu.getId() + " " + iu.getVersion());
            already = true;
        }
        if (!already) {
            System.out.println("Already installed: None!");
        }
        this.validate(expected, toAdd);
        ArrayList<URI> repoURLs = new ArrayList<URI>();
        repoURLs.add(this.repo.getLocation());
        repoURLs.add(new Path(this.getTestDataPath()).append("shared").toFile().toURI());
        ProvisioningContext context = this.getContext(repoURLs);
        context.setExtraInstallableUnits(new ArrayList<IInstallableUnit>(toAdd));
        IProfileChangeRequest actualChangeRequest = this.createProfileChangeRequest(toAdd, null, null);
        IProvisioningPlan plan = planner.getProvisioningPlan(actualChangeRequest, context, (IProgressMonitor)new NullProgressMonitor());
        Collection compressedPlan = this.compress(plan);
        if (compressedPlan.isEmpty()) {
            System.out.println("Plan: ...is empty!");
        }
        Iterator iter = compressedPlan.iterator();
        while (iter.hasNext()) {
            System.out.println("Plan: " + iter.next());
        }
        this.validate(expected, plan);
    }

    private void validate(Collection<IInstallableUnit> expected, Collection<IInstallableUnit> toAdd) {
        MultiStatus errors = new MultiStatus("org.eclipse.equinox.p2.test", 0, "Errors while validating plan.", null);
        for (IInstallableUnit unit : expected) {
            IQuery query = QueryUtil.createIUQuery((String)unit.getId(), (Version)unit.getVersion());
            IQueryResult queryResult = this.getProfile().query(query, (IProgressMonitor)new NullProgressMonitor());
            if (!queryResult.isEmpty() || toAdd.contains(unit)) continue;
            errors.add((IStatus)new Status(4, "org.eclipse.equinox.p2.test", String.valueOf(unit.getId()) + " " + unit.getVersion() + " isn't in the profile and isn't an incoming addition."));
        }
        Bug362692.assertOK("Errors while validating plan.", (IStatus)errors);
    }

    private void validate(Collection<IInstallableUnit> expected, IProvisioningPlan plan) {
        MultiStatus errors = new MultiStatus("org.eclipse.equinox.p2.test", 0, "Errors while validating plan.", null);
        for (IInstallableUnit unit : expected) {
            IQuery query = QueryUtil.createIUQuery((String)unit.getId(), (Version)unit.getVersion());
            IQueryResult queryResult = this.getProfile().query(query, (IProgressMonitor)new NullProgressMonitor());
            if (queryResult.isEmpty()) {
                if (!plan.getAdditions().query(query, (IProgressMonitor)new NullProgressMonitor()).isEmpty()) continue;
                errors.add((IStatus)new Status(4, "org.eclipse.equinox.p2.test", String.valueOf(unit.getId()) + " " + unit.getVersion() + " isn't in the profile and isn't an incoming addition."));
                continue;
            }
            if (plan.getRemovals().query(query, (IProgressMonitor)new NullProgressMonitor()).isEmpty()) continue;
            errors.add((IStatus)new Status(4, "org.eclipse.equinox.p2.test", String.valueOf(unit.getId()) + " " + unit.getVersion() + " is in the profile but is being removed."));
        }
        Bug362692.assertOK("Errors while validating plan.", (IStatus)errors);
    }
}

