/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.osgi.framework.Version;

public class ExplanationForPartialInstallation
extends AbstractProvisioningTest {
    private IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IInstallableUnit sdk;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sdk = ExplanationForPartialInstallation.createIU("SDK", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationForPartialInstallation.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit sdkPart = ExplanationForPartialInstallation.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        IInstallableUnit sdkPart2 = ExplanationForPartialInstallation.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("2.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk, sdkPart, sdkPart2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = ExplanationForPartialInstallation.createPlanner();
        this.engine = ExplanationForPartialInstallation.createEngine();
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.sdk});
        this.engine.perform(this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null), null);
    }

    public void testPartialProblemSingleton() {
        IInstallableUnit cdt = ExplanationForPartialInstallation.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationForPartialInstallation.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit emf = ExplanationForPartialInstallation.createIU("EMF", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{cdt, emf});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt, emf});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        ExplanationForPartialInstallation.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(cdt));
        ExplanationForPartialInstallation.assertFalse((boolean)requestStatus.getConflictsWithInstalledRoots().contains(emf));
        ExplanationForPartialInstallation.assertFalse((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.sdk));
    }

    public void testPartialProblemRequirement() {
        IInstallableUnit cdt = ExplanationForPartialInstallation.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationForPartialInstallation.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "MissingPart", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit emf = ExplanationForPartialInstallation.createIU("EMF", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{cdt, emf});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt, emf});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        ExplanationForPartialInstallation.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(cdt));
        ExplanationForPartialInstallation.assertFalse((boolean)requestStatus.getConflictsWithInstalledRoots().contains(emf));
        ExplanationForPartialInstallation.assertFalse((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.sdk));
    }
}

