/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ExplanationLargeConflict
extends AbstractProvisioningTest {
    IMetadataRepository repo1;
    IMetadataRepository repo2;
    private IPlanner planner;
    private IProfile SDKprofile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.repo1 = this.loadMetadataRepository(ExplanationLargeConflict.getTestData("repo1", "testData/testLargeConflict/repo1").toURI());
        this.repo2 = this.loadMetadataRepository(ExplanationLargeConflict.getTestData("repo2", "testData/testLargeConflict/repo2").toURI());
        File reporegistry1 = ExplanationLargeConflict.getTestData("test data explanation large conflict", "testData/testLargeConflict/profileRegistry");
        File tempFolder = this.getTempFolder();
        ExplanationLargeConflict.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(ExplanationLargeConflict.getAgent(), tempFolder, null, false);
        this.SDKprofile = registry.getProfile("SDKProfile");
        ExplanationLargeConflict.assertNotNull((Object)this.SDKprofile);
        this.planner = ExplanationLargeConflict.createPlanner();
    }

    public void testIndependentConflict() {
        long sTime = System.currentTimeMillis();
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IQueryResult c = this.repo1.query(QueryUtil.createIUQuery((String)"org.eclipse.jdt.feature.group"), null);
        ExplanationLargeConflict.assertEquals((int)1, (int)ExplanationLargeConflict.queryResultSize(c));
        IInstallableUnit jdt1 = (IInstallableUnit)c.iterator().next();
        IQueryResult c2 = this.repo2.query(QueryUtil.createIUQuery((String)"org.eclipse.jdt.feature.group"), null);
        ExplanationLargeConflict.assertEquals((int)1, (int)ExplanationLargeConflict.queryResultSize(c2));
        IInstallableUnit jdt2 = (IInstallableUnit)c2.iterator().next();
        ExplanationLargeConflict.assertNotSame((Object)jdt1, (Object)jdt2);
        ProfileChangeRequest pcr = new ProfileChangeRequest(profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{jdt1, jdt2});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        ExplanationLargeConflict.assertNotOK(plan.getStatus());
        LogHelper.log((IStatus)plan.getStatus());
        long eTime = System.currentTimeMillis();
        System.out.println("Time to compute conflict: " + (eTime - sTime));
    }

    public void testMissingRequirement() {
        long sTime = System.currentTimeMillis();
        IRequirement[] cap = ExplanationLargeConflict.createRequiredCapabilities("missing", "missing", new VersionRange("[0.0.0, 1.0.0)"));
        IInstallableUnit otherIU2 = ExplanationLargeConflict.createIU("foo", Version.create((String)"0.9.0"), null, cap, BUNDLE_CAPABILITY, NO_PROPERTIES, TOUCHPOINT_OSGI, NO_TP_DATA, true);
        ProfileChangeRequest pcr3 = new ProfileChangeRequest(this.SDKprofile);
        pcr3.addInstallableUnits(new IInstallableUnit[]{otherIU2});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr3, null, null);
        ExplanationLargeConflict.assertNotOK(plan3.getStatus());
        LogHelper.log((IStatus)plan3.getStatus());
        long eTime = System.currentTimeMillis();
        System.out.println("Time to compute conflict: " + (eTime - sTime));
    }

    public void testSingletonConflict() {
        long sTime = System.currentTimeMillis();
        IInstallableUnit otherIU = ExplanationLargeConflict.createIU("org.eclipse.equinox.p2.director", Version.create((String)"0.9.0"), null, (IRequirement[])NO_REQUIRES, BUNDLE_CAPABILITY, NO_PROPERTIES, TOUCHPOINT_OSGI, NO_TP_DATA, true);
        ProfileChangeRequest pcr2 = new ProfileChangeRequest(this.SDKprofile);
        pcr2.addInstallableUnits(new IInstallableUnit[]{otherIU});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr2, null, null);
        ExplanationLargeConflict.assertNotOK(plan2.getStatus());
        LogHelper.log((IStatus)plan2.getStatus());
        long eTime = System.currentTimeMillis();
        System.out.println("Time to compute conflict: " + (eTime - sTime));
    }

    public void testExplanationLargeConflictInSDK() {
        long sTime = System.currentTimeMillis();
        IQueryResult c = this.repo2.query(QueryUtil.createIUQuery((String)"org.eclipse.cvs.feature.group"), null);
        ExplanationLargeConflict.assertEquals((int)1, (int)ExplanationLargeConflict.queryResultSize(c));
        IInstallableUnit cvs = (IInstallableUnit)c.iterator().next();
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.SDKprofile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cvs});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        ExplanationLargeConflict.assertNotOK(plan.getStatus());
        LogHelper.log((IStatus)plan.getStatus());
        long eTime = System.currentTimeMillis();
        System.out.println("Time to compute conflict: " + (eTime - sTime));
    }
}

