/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.osgi.framework.Version;

public class ExplanationSeveralConflictingRoots
extends AbstractProvisioningTest {
    private IProfile profile;
    private IPlanner planner;
    private IInstallableUnit sdk;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sdk = ExplanationSeveralConflictingRoots.createIU("SDK", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationSeveralConflictingRoots.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit sdkPart = ExplanationSeveralConflictingRoots.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        IInstallableUnit sdkPart2 = ExplanationSeveralConflictingRoots.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("2.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk, sdkPart, sdkPart2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = ExplanationSeveralConflictingRoots.createPlanner();
        IEngine engine = ExplanationSeveralConflictingRoots.createEngine();
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.sdk});
        engine.perform(this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null), null);
    }

    public void testConflictingSingletonAndMissingDependency() {
        IInstallableUnit cdt = ExplanationSeveralConflictingRoots.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationSeveralConflictingRoots.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit emf = ExplanationSeveralConflictingRoots.createIU("EMF", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationSeveralConflictingRoots.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "EMFPart", new VersionRange("[1.0.0, 1.0.0]")));
        this.createTestMetdataRepository(new IInstallableUnit[]{cdt, emf});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt, emf});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        Set conflictRoots = ((PlannerStatus)plan.getStatus()).getRequestStatus().getConflictsWithInstalledRoots();
        ExplanationSeveralConflictingRoots.assertTrue((conflictRoots.contains(cdt) || conflictRoots.contains(emf) ? 1 : 0) != 0);
    }

    public void testConflictingSingletonAndMissingDependency2() {
        IInstallableUnit cdt = ExplanationSeveralConflictingRoots.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationSeveralConflictingRoots.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "ASingleton", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit aSingleton1 = ExplanationSeveralConflictingRoots.createIU("ASingleton", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        IInstallableUnit aSingleton2 = ExplanationSeveralConflictingRoots.createIU("ASingleton", PublisherHelper.fromOSGiVersion((Version)new Version("2.0.0")), true);
        IRequirement emfOnSingleton = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"ASingleton", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement emfMissing = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"EMFPart", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IInstallableUnit emf = ExplanationSeveralConflictingRoots.createIU("EMF", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), new IRequirement[]{emfOnSingleton, emfMissing});
        this.createTestMetdataRepository(new IInstallableUnit[]{aSingleton1, aSingleton2, cdt, emf});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt, emf});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        Set conflictRoots = ((PlannerStatus)plan.getStatus()).getRequestStatus().getConflictsWithInstalledRoots();
        ExplanationSeveralConflictingRoots.assertTrue((conflictRoots.contains(cdt) || conflictRoots.contains(emf) ? 1 : 0) != 0);
    }

    public void testConflictingSingletonAndMissingDependency3() {
        IInstallableUnit cdt = ExplanationSeveralConflictingRoots.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationSeveralConflictingRoots.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit sdkPart3 = ExplanationSeveralConflictingRoots.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("3.0.0")), true);
        IRequirement emfOnSingleton = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"SDKPart", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement emfMissing = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"EMFPart", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IInstallableUnit emf = ExplanationSeveralConflictingRoots.createIU("EMF", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), new IRequirement[]{emfOnSingleton, emfMissing});
        this.createTestMetdataRepository(new IInstallableUnit[]{sdkPart3, cdt, emf});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt, emf});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        Set conflictRoots = ((PlannerStatus)plan.getStatus()).getRequestStatus().getConflictsWithInstalledRoots();
        ExplanationSeveralConflictingRoots.assertTrue((conflictRoots.contains(cdt) || conflictRoots.contains(emf) ? 1 : 0) != 0);
    }
}

